/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrollau;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.payrollau.LeavePeriodStatus;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.ZoneId;

public class LeavePeriod {
    StringUtil util = new StringUtil();
    @JsonProperty(value="NumberOfUnits")
    private Double numberOfUnits;
    @JsonProperty(value="PayPeriodEndDate")
    private String payPeriodEndDate;
    @JsonProperty(value="PayPeriodStartDate")
    private String payPeriodStartDate;
    @JsonProperty(value="LeavePeriodStatus")
    private LeavePeriodStatus leavePeriodStatus;

    public LeavePeriod numberOfUnits(Double numberOfUnits) {
        this.numberOfUnits = numberOfUnits;
        return this;
    }

    @ApiModelProperty(example="22.8", value="The Number of Units for the leave")
    public Double getNumberOfUnits() {
        return this.numberOfUnits;
    }

    public void setNumberOfUnits(Double numberOfUnits) {
        this.numberOfUnits = numberOfUnits;
    }

    public LeavePeriod payPeriodEndDate(String payPeriodEndDate) {
        this.payPeriodEndDate = payPeriodEndDate;
        return this;
    }

    @ApiModelProperty(example="/Date(322560000000+0000)/", value="The Pay Period End Date (YYYY-MM-DD)")
    public String getPayPeriodEndDate() {
        return this.payPeriodEndDate;
    }

    public LocalDate getPayPeriodEndDateAsDate() {
        if (this.payPeriodEndDate != null) {
            try {
                return this.util.convertStringToDate(this.payPeriodEndDate);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setPayPeriodEndDate(String payPeriodEndDate) {
        this.payPeriodEndDate = payPeriodEndDate;
    }

    public void setPayPeriodEndDate(LocalDate payPeriodEndDate) {
        Instant instant = payPeriodEndDate.atStartOfDay(ZoneId.of((String)"UTC").normalized()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        this.payPeriodEndDate = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
    }

    public LeavePeriod payPeriodStartDate(String payPeriodStartDate) {
        this.payPeriodStartDate = payPeriodStartDate;
        return this;
    }

    @ApiModelProperty(example="/Date(322560000000+0000)/", value="The Pay Period Start Date (YYYY-MM-DD)")
    public String getPayPeriodStartDate() {
        return this.payPeriodStartDate;
    }

    public LocalDate getPayPeriodStartDateAsDate() {
        if (this.payPeriodStartDate != null) {
            try {
                return this.util.convertStringToDate(this.payPeriodStartDate);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setPayPeriodStartDate(String payPeriodStartDate) {
        this.payPeriodStartDate = payPeriodStartDate;
    }

    public void setPayPeriodStartDate(LocalDate payPeriodStartDate) {
        Instant instant = payPeriodStartDate.atStartOfDay(ZoneId.of((String)"UTC").normalized()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        this.payPeriodStartDate = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
    }

    public LeavePeriod leavePeriodStatus(LeavePeriodStatus leavePeriodStatus) {
        this.leavePeriodStatus = leavePeriodStatus;
        return this;
    }

    @ApiModelProperty(value="")
    public LeavePeriodStatus getLeavePeriodStatus() {
        return this.leavePeriodStatus;
    }

    public void setLeavePeriodStatus(LeavePeriodStatus leavePeriodStatus) {
        this.leavePeriodStatus = leavePeriodStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LeavePeriod leavePeriod = (LeavePeriod)o;
        return Objects.equals(this.numberOfUnits, leavePeriod.numberOfUnits) && Objects.equals(this.payPeriodEndDate, leavePeriod.payPeriodEndDate) && Objects.equals(this.payPeriodStartDate, leavePeriod.payPeriodStartDate) && Objects.equals((Object)this.leavePeriodStatus, (Object)leavePeriod.leavePeriodStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.numberOfUnits, this.payPeriodEndDate, this.payPeriodStartDate, this.leavePeriodStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LeavePeriod {\n");
        sb.append("    numberOfUnits: ").append(this.toIndentedString(this.numberOfUnits)).append("\n");
        sb.append("    payPeriodEndDate: ").append(this.toIndentedString(this.payPeriodEndDate)).append("\n");
        sb.append("    payPeriodStartDate: ").append(this.toIndentedString(this.payPeriodStartDate)).append("\n");
        sb.append("    leavePeriodStatus: ").append(this.toIndentedString((Object)this.leavePeriodStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

