/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrollau;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.payrollau.DeductionLine;
import com.xero.models.payrollau.EarningsLine;
import com.xero.models.payrollau.LeaveLine;
import com.xero.models.payrollau.PaidLeaveEarningsLine;
import com.xero.models.payrollau.ReimbursementLine;
import com.xero.models.payrollau.SuperLine;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.ZoneId;

public class OpeningBalances {
    StringUtil util = new StringUtil();
    @JsonProperty(value="OpeningBalanceDate")
    private String openingBalanceDate;
    @JsonProperty(value="Tax")
    private String tax;
    @JsonProperty(value="EarningsLines")
    private List<EarningsLine> earningsLines = new ArrayList<EarningsLine>();
    @JsonProperty(value="DeductionLines")
    private List<DeductionLine> deductionLines = new ArrayList<DeductionLine>();
    @JsonProperty(value="SuperLines")
    private List<SuperLine> superLines = new ArrayList<SuperLine>();
    @JsonProperty(value="ReimbursementLines")
    private List<ReimbursementLine> reimbursementLines = new ArrayList<ReimbursementLine>();
    @JsonProperty(value="LeaveLines")
    private List<LeaveLine> leaveLines = new ArrayList<LeaveLine>();
    @JsonProperty(value="PaidLeaveEarningsLines")
    private List<PaidLeaveEarningsLine> paidLeaveEarningsLines = new ArrayList<PaidLeaveEarningsLine>();

    public OpeningBalances openingBalanceDate(String openingBalanceDate) {
        this.openingBalanceDate = openingBalanceDate;
        return this;
    }

    @ApiModelProperty(example="/Date(322560000000+0000)/", value="Opening Balance Date. (YYYY-MM-DD)")
    public String getOpeningBalanceDate() {
        return this.openingBalanceDate;
    }

    public LocalDate getOpeningBalanceDateAsDate() {
        if (this.openingBalanceDate != null) {
            try {
                return this.util.convertStringToDate(this.openingBalanceDate);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setOpeningBalanceDate(String openingBalanceDate) {
        this.openingBalanceDate = openingBalanceDate;
    }

    public void setOpeningBalanceDate(LocalDate openingBalanceDate) {
        Instant instant = openingBalanceDate.atStartOfDay(ZoneId.of((String)"UTC").normalized()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        this.openingBalanceDate = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
    }

    public OpeningBalances tax(String tax) {
        this.tax = tax;
        return this;
    }

    @ApiModelProperty(example="4333d5cd-53a5-4c31-98e5-a8b4e5676b0b", value="Opening Balance tax")
    public String getTax() {
        return this.tax;
    }

    public void setTax(String tax) {
        this.tax = tax;
    }

    public OpeningBalances earningsLines(List<EarningsLine> earningsLines) {
        this.earningsLines = earningsLines;
        return this;
    }

    public OpeningBalances addEarningsLinesItem(EarningsLine earningsLinesItem) {
        if (this.earningsLines == null) {
            this.earningsLines = new ArrayList<EarningsLine>();
        }
        this.earningsLines.add(earningsLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<EarningsLine> getEarningsLines() {
        return this.earningsLines;
    }

    public void setEarningsLines(List<EarningsLine> earningsLines) {
        this.earningsLines = earningsLines;
    }

    public OpeningBalances deductionLines(List<DeductionLine> deductionLines) {
        this.deductionLines = deductionLines;
        return this;
    }

    public OpeningBalances addDeductionLinesItem(DeductionLine deductionLinesItem) {
        if (this.deductionLines == null) {
            this.deductionLines = new ArrayList<DeductionLine>();
        }
        this.deductionLines.add(deductionLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<DeductionLine> getDeductionLines() {
        return this.deductionLines;
    }

    public void setDeductionLines(List<DeductionLine> deductionLines) {
        this.deductionLines = deductionLines;
    }

    public OpeningBalances superLines(List<SuperLine> superLines) {
        this.superLines = superLines;
        return this;
    }

    public OpeningBalances addSuperLinesItem(SuperLine superLinesItem) {
        if (this.superLines == null) {
            this.superLines = new ArrayList<SuperLine>();
        }
        this.superLines.add(superLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<SuperLine> getSuperLines() {
        return this.superLines;
    }

    public void setSuperLines(List<SuperLine> superLines) {
        this.superLines = superLines;
    }

    public OpeningBalances reimbursementLines(List<ReimbursementLine> reimbursementLines) {
        this.reimbursementLines = reimbursementLines;
        return this;
    }

    public OpeningBalances addReimbursementLinesItem(ReimbursementLine reimbursementLinesItem) {
        if (this.reimbursementLines == null) {
            this.reimbursementLines = new ArrayList<ReimbursementLine>();
        }
        this.reimbursementLines.add(reimbursementLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<ReimbursementLine> getReimbursementLines() {
        return this.reimbursementLines;
    }

    public void setReimbursementLines(List<ReimbursementLine> reimbursementLines) {
        this.reimbursementLines = reimbursementLines;
    }

    public OpeningBalances leaveLines(List<LeaveLine> leaveLines) {
        this.leaveLines = leaveLines;
        return this;
    }

    public OpeningBalances addLeaveLinesItem(LeaveLine leaveLinesItem) {
        if (this.leaveLines == null) {
            this.leaveLines = new ArrayList<LeaveLine>();
        }
        this.leaveLines.add(leaveLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<LeaveLine> getLeaveLines() {
        return this.leaveLines;
    }

    public void setLeaveLines(List<LeaveLine> leaveLines) {
        this.leaveLines = leaveLines;
    }

    public OpeningBalances paidLeaveEarningsLines(List<PaidLeaveEarningsLine> paidLeaveEarningsLines) {
        this.paidLeaveEarningsLines = paidLeaveEarningsLines;
        return this;
    }

    public OpeningBalances addPaidLeaveEarningsLinesItem(PaidLeaveEarningsLine paidLeaveEarningsLinesItem) {
        if (this.paidLeaveEarningsLines == null) {
            this.paidLeaveEarningsLines = new ArrayList<PaidLeaveEarningsLine>();
        }
        this.paidLeaveEarningsLines.add(paidLeaveEarningsLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<PaidLeaveEarningsLine> getPaidLeaveEarningsLines() {
        return this.paidLeaveEarningsLines;
    }

    public void setPaidLeaveEarningsLines(List<PaidLeaveEarningsLine> paidLeaveEarningsLines) {
        this.paidLeaveEarningsLines = paidLeaveEarningsLines;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpeningBalances openingBalances = (OpeningBalances)o;
        return Objects.equals(this.openingBalanceDate, openingBalances.openingBalanceDate) && Objects.equals(this.tax, openingBalances.tax) && Objects.equals(this.earningsLines, openingBalances.earningsLines) && Objects.equals(this.deductionLines, openingBalances.deductionLines) && Objects.equals(this.superLines, openingBalances.superLines) && Objects.equals(this.reimbursementLines, openingBalances.reimbursementLines) && Objects.equals(this.leaveLines, openingBalances.leaveLines) && Objects.equals(this.paidLeaveEarningsLines, openingBalances.paidLeaveEarningsLines);
    }

    public int hashCode() {
        return Objects.hash(this.openingBalanceDate, this.tax, this.earningsLines, this.deductionLines, this.superLines, this.reimbursementLines, this.leaveLines, this.paidLeaveEarningsLines);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OpeningBalances {\n");
        sb.append("    openingBalanceDate: ").append(this.toIndentedString(this.openingBalanceDate)).append("\n");
        sb.append("    tax: ").append(this.toIndentedString(this.tax)).append("\n");
        sb.append("    earningsLines: ").append(this.toIndentedString(this.earningsLines)).append("\n");
        sb.append("    deductionLines: ").append(this.toIndentedString(this.deductionLines)).append("\n");
        sb.append("    superLines: ").append(this.toIndentedString(this.superLines)).append("\n");
        sb.append("    reimbursementLines: ").append(this.toIndentedString(this.reimbursementLines)).append("\n");
        sb.append("    leaveLines: ").append(this.toIndentedString(this.leaveLines)).append("\n");
        sb.append("    paidLeaveEarningsLines: ").append(this.toIndentedString(this.paidLeaveEarningsLines)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

