/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrollau;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

public class PaidLeaveEarningsLine {
    StringUtil util = new StringUtil();
    @JsonProperty(value="LeaveTypeID")
    private UUID leaveTypeID;
    @JsonProperty(value="Amount")
    private Double amount;
    @JsonProperty(value="SGCAppliedLeaveLoadingAmount")
    private Double sgCAppliedLeaveLoadingAmount;
    @JsonProperty(value="SGCExemptedLeaveLoadingAmount")
    private Double sgCExemptedLeaveLoadingAmount;
    @JsonProperty(value="ResetSTPCategorisation")
    private Boolean resetSTPCategorisation;

    public PaidLeaveEarningsLine leaveTypeID(UUID leaveTypeID) {
        this.leaveTypeID = leaveTypeID;
        return this;
    }

    @ApiModelProperty(example="742998cb-7584-4ecf-aa88-d694f59c50f9", required=true, value="Xero leave type identifier")
    public UUID getLeaveTypeID() {
        return this.leaveTypeID;
    }

    public void setLeaveTypeID(UUID leaveTypeID) {
        this.leaveTypeID = leaveTypeID;
    }

    public PaidLeaveEarningsLine amount(Double amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(example="500.0", required=true, value="Paid leave amount")
    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public PaidLeaveEarningsLine sgCAppliedLeaveLoadingAmount(Double sgCAppliedLeaveLoadingAmount) {
        this.sgCAppliedLeaveLoadingAmount = sgCAppliedLeaveLoadingAmount;
        return this;
    }

    @ApiModelProperty(example="50.0", value="The amount of leave loading applied for the leave type that is subject to Superannuation Guarantee Contributions. *Only applicable for Leave Types with Annual Leave Categories")
    public Double getSgCAppliedLeaveLoadingAmount() {
        return this.sgCAppliedLeaveLoadingAmount;
    }

    public void setSgCAppliedLeaveLoadingAmount(Double sgCAppliedLeaveLoadingAmount) {
        this.sgCAppliedLeaveLoadingAmount = sgCAppliedLeaveLoadingAmount;
    }

    public PaidLeaveEarningsLine sgCExemptedLeaveLoadingAmount(Double sgCExemptedLeaveLoadingAmount) {
        this.sgCExemptedLeaveLoadingAmount = sgCExemptedLeaveLoadingAmount;
        return this;
    }

    @ApiModelProperty(example="60.0", value="The amount of leave loading applied for the leave type that is exempt from Superannuation Guarantee Contributions. *Only applicable for Leave Types with Annual Leave Categories")
    public Double getSgCExemptedLeaveLoadingAmount() {
        return this.sgCExemptedLeaveLoadingAmount;
    }

    public void setSgCExemptedLeaveLoadingAmount(Double sgCExemptedLeaveLoadingAmount) {
        this.sgCExemptedLeaveLoadingAmount = sgCExemptedLeaveLoadingAmount;
    }

    public PaidLeaveEarningsLine resetSTPCategorisation(Boolean resetSTPCategorisation) {
        this.resetSTPCategorisation = resetSTPCategorisation;
        return this;
    }

    @ApiModelProperty(example="true", value="Reset the STP categorisations for the leave type. *Only applicable for Leave Types with Annual Leave Categories")
    public Boolean getResetSTPCategorisation() {
        return this.resetSTPCategorisation;
    }

    public void setResetSTPCategorisation(Boolean resetSTPCategorisation) {
        this.resetSTPCategorisation = resetSTPCategorisation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaidLeaveEarningsLine paidLeaveEarningsLine = (PaidLeaveEarningsLine)o;
        return Objects.equals(this.leaveTypeID, paidLeaveEarningsLine.leaveTypeID) && Objects.equals(this.amount, paidLeaveEarningsLine.amount) && Objects.equals(this.sgCAppliedLeaveLoadingAmount, paidLeaveEarningsLine.sgCAppliedLeaveLoadingAmount) && Objects.equals(this.sgCExemptedLeaveLoadingAmount, paidLeaveEarningsLine.sgCExemptedLeaveLoadingAmount) && Objects.equals(this.resetSTPCategorisation, paidLeaveEarningsLine.resetSTPCategorisation);
    }

    public int hashCode() {
        return Objects.hash(this.leaveTypeID, this.amount, this.sgCAppliedLeaveLoadingAmount, this.sgCExemptedLeaveLoadingAmount, this.resetSTPCategorisation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaidLeaveEarningsLine {\n");
        sb.append("    leaveTypeID: ").append(this.toIndentedString(this.leaveTypeID)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    sgCAppliedLeaveLoadingAmount: ").append(this.toIndentedString(this.sgCAppliedLeaveLoadingAmount)).append("\n");
        sb.append("    sgCExemptedLeaveLoadingAmount: ").append(this.toIndentedString(this.sgCExemptedLeaveLoadingAmount)).append("\n");
        sb.append("    resetSTPCategorisation: ").append(this.toIndentedString(this.resetSTPCategorisation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

