/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrollau;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.OffsetDateTime;

public class ReimbursementType {
    StringUtil util = new StringUtil();
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="AccountCode")
    private String accountCode;
    @JsonProperty(value="ReimbursementTypeID")
    private UUID reimbursementTypeID;
    @JsonProperty(value="UpdatedDateUTC")
    private String updatedDateUTC;
    @JsonProperty(value="CurrentRecord")
    private Boolean currentRecord;

    public ReimbursementType name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="PTO", value="Name of the earnings rate (max length = 100)")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ReimbursementType accountCode(String accountCode) {
        this.accountCode = accountCode;
        return this;
    }

    @ApiModelProperty(example="720", value="See Accounts")
    public String getAccountCode() {
        return this.accountCode;
    }

    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }

    public ReimbursementType reimbursementTypeID(UUID reimbursementTypeID) {
        this.reimbursementTypeID = reimbursementTypeID;
        return this;
    }

    @ApiModelProperty(example="e0eb6747-7c17-4075-b804-989f8d4e5d39", value="Xero identifier")
    public UUID getReimbursementTypeID() {
        return this.reimbursementTypeID;
    }

    public void setReimbursementTypeID(UUID reimbursementTypeID) {
        this.reimbursementTypeID = reimbursementTypeID;
    }

    @ApiModelProperty(example="/Date(1583967733054+0000)/", value="Last modified timestamp")
    public String getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public OffsetDateTime getUpdatedDateUTCAsDate() {
        if (this.updatedDateUTC != null) {
            try {
                return this.util.convertStringToOffsetDateTime(this.updatedDateUTC);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public ReimbursementType currentRecord(Boolean currentRecord) {
        this.currentRecord = currentRecord;
        return this;
    }

    @ApiModelProperty(example="true", value="Is the current record")
    public Boolean getCurrentRecord() {
        return this.currentRecord;
    }

    public void setCurrentRecord(Boolean currentRecord) {
        this.currentRecord = currentRecord;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReimbursementType reimbursementType = (ReimbursementType)o;
        return Objects.equals(this.name, reimbursementType.name) && Objects.equals(this.accountCode, reimbursementType.accountCode) && Objects.equals(this.reimbursementTypeID, reimbursementType.reimbursementTypeID) && Objects.equals(this.updatedDateUTC, reimbursementType.updatedDateUTC) && Objects.equals(this.currentRecord, reimbursementType.currentRecord);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.accountCode, this.reimbursementTypeID, this.updatedDateUTC, this.currentRecord);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReimbursementType {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    accountCode: ").append(this.toIndentedString(this.accountCode)).append("\n");
        sb.append("    reimbursementTypeID: ").append(this.toIndentedString(this.reimbursementTypeID)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("    currentRecord: ").append(this.toIndentedString(this.currentRecord)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

