/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrollau;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.payrollau.EmploymentBasis;
import com.xero.models.payrollau.ResidencyStatus;
import com.xero.models.payrollau.SeniorMaritalStatus;
import com.xero.models.payrollau.TFNExemptionType;
import com.xero.models.payrollau.TaxScaleType;
import com.xero.models.payrollau.WorkCondition;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.OffsetDateTime;

public class TaxDeclaration {
    StringUtil util = new StringUtil();
    @JsonProperty(value="EmployeeID")
    private UUID employeeID;
    @JsonProperty(value="EmploymentBasis")
    private EmploymentBasis employmentBasis;
    @JsonProperty(value="TFNExemptionType")
    private TFNExemptionType tfNExemptionType;
    @JsonProperty(value="TaxFileNumber")
    private String taxFileNumber;
    @JsonProperty(value="ABN")
    private String ABN;
    @JsonProperty(value="AustralianResidentForTaxPurposes")
    private Boolean australianResidentForTaxPurposes;
    @JsonProperty(value="ResidencyStatus")
    private ResidencyStatus residencyStatus;
    @JsonProperty(value="TaxScaleType")
    private TaxScaleType taxScaleType;
    @JsonProperty(value="WorkCondition")
    private WorkCondition workCondition;
    @JsonProperty(value="SeniorMaritalStatus")
    private SeniorMaritalStatus seniorMaritalStatus;
    @JsonProperty(value="TaxFreeThresholdClaimed")
    private Boolean taxFreeThresholdClaimed;
    @JsonProperty(value="TaxOffsetEstimatedAmount")
    private BigDecimal taxOffsetEstimatedAmount;
    @JsonProperty(value="HasHELPDebt")
    private Boolean hasHELPDebt;
    @JsonProperty(value="HasSFSSDebt")
    private Boolean hasSFSSDebt;
    @JsonProperty(value="HasTradeSupportLoanDebt")
    private Boolean hasTradeSupportLoanDebt;
    @JsonProperty(value="UpwardVariationTaxWithholdingAmount")
    private BigDecimal upwardVariationTaxWithholdingAmount;
    @JsonProperty(value="EligibleToReceiveLeaveLoading")
    private Boolean eligibleToReceiveLeaveLoading;
    @JsonProperty(value="ApprovedWithholdingVariationPercentage")
    private BigDecimal approvedWithholdingVariationPercentage;
    @JsonProperty(value="HasStudentStartupLoan")
    private Boolean hasStudentStartupLoan;
    @JsonProperty(value="HasLoanOrStudentDebt")
    private Boolean hasLoanOrStudentDebt;
    @JsonProperty(value="UpdatedDateUTC")
    private String updatedDateUTC;

    public TaxDeclaration employeeID(UUID employeeID) {
        this.employeeID = employeeID;
        return this;
    }

    @ApiModelProperty(value="Address line 1 for employee home address")
    public UUID getEmployeeID() {
        return this.employeeID;
    }

    public void setEmployeeID(UUID employeeID) {
        this.employeeID = employeeID;
    }

    public TaxDeclaration employmentBasis(EmploymentBasis employmentBasis) {
        this.employmentBasis = employmentBasis;
        return this;
    }

    @ApiModelProperty(value="")
    public EmploymentBasis getEmploymentBasis() {
        return this.employmentBasis;
    }

    public void setEmploymentBasis(EmploymentBasis employmentBasis) {
        this.employmentBasis = employmentBasis;
    }

    public TaxDeclaration tfNExemptionType(TFNExemptionType tfNExemptionType) {
        this.tfNExemptionType = tfNExemptionType;
        return this;
    }

    @ApiModelProperty(value="")
    public TFNExemptionType getTfNExemptionType() {
        return this.tfNExemptionType;
    }

    public void setTfNExemptionType(TFNExemptionType tfNExemptionType) {
        this.tfNExemptionType = tfNExemptionType;
    }

    public TaxDeclaration taxFileNumber(String taxFileNumber) {
        this.taxFileNumber = taxFileNumber;
        return this;
    }

    @ApiModelProperty(example="123123123", value="The tax file number e.g 123123123.")
    public String getTaxFileNumber() {
        return this.taxFileNumber;
    }

    public void setTaxFileNumber(String taxFileNumber) {
        this.taxFileNumber = taxFileNumber;
    }

    public TaxDeclaration ABN(String ABN) {
        this.ABN = ABN;
        return this;
    }

    @ApiModelProperty(example="21006819692", value="11-digit Australian Business Number e.g 21006819692 or an empty string (\"\") to unset a previously set value. Only applicable, and mandatory if income type is NONEMPLOYEE.")
    public String getABN() {
        return this.ABN;
    }

    public void setABN(String ABN) {
        this.ABN = ABN;
    }

    public TaxDeclaration australianResidentForTaxPurposes(Boolean australianResidentForTaxPurposes) {
        this.australianResidentForTaxPurposes = australianResidentForTaxPurposes;
        return this;
    }

    @ApiModelProperty(example="true", value="If the employee is Australian resident for tax purposes. e.g true or false")
    public Boolean getAustralianResidentForTaxPurposes() {
        return this.australianResidentForTaxPurposes;
    }

    public void setAustralianResidentForTaxPurposes(Boolean australianResidentForTaxPurposes) {
        this.australianResidentForTaxPurposes = australianResidentForTaxPurposes;
    }

    public TaxDeclaration residencyStatus(ResidencyStatus residencyStatus) {
        this.residencyStatus = residencyStatus;
        return this;
    }

    @ApiModelProperty(value="")
    public ResidencyStatus getResidencyStatus() {
        return this.residencyStatus;
    }

    public void setResidencyStatus(ResidencyStatus residencyStatus) {
        this.residencyStatus = residencyStatus;
    }

    public TaxDeclaration taxScaleType(TaxScaleType taxScaleType) {
        this.taxScaleType = taxScaleType;
        return this;
    }

    @ApiModelProperty(value="")
    public TaxScaleType getTaxScaleType() {
        return this.taxScaleType;
    }

    public void setTaxScaleType(TaxScaleType taxScaleType) {
        this.taxScaleType = taxScaleType;
    }

    public TaxDeclaration workCondition(WorkCondition workCondition) {
        this.workCondition = workCondition;
        return this;
    }

    @ApiModelProperty(value="")
    public WorkCondition getWorkCondition() {
        return this.workCondition;
    }

    public void setWorkCondition(WorkCondition workCondition) {
        this.workCondition = workCondition;
    }

    public TaxDeclaration seniorMaritalStatus(SeniorMaritalStatus seniorMaritalStatus) {
        this.seniorMaritalStatus = seniorMaritalStatus;
        return this;
    }

    @ApiModelProperty(value="")
    public SeniorMaritalStatus getSeniorMaritalStatus() {
        return this.seniorMaritalStatus;
    }

    public void setSeniorMaritalStatus(SeniorMaritalStatus seniorMaritalStatus) {
        this.seniorMaritalStatus = seniorMaritalStatus;
    }

    public TaxDeclaration taxFreeThresholdClaimed(Boolean taxFreeThresholdClaimed) {
        this.taxFreeThresholdClaimed = taxFreeThresholdClaimed;
        return this;
    }

    @ApiModelProperty(example="false", value="If tax free threshold claimed. e.g true or false")
    public Boolean getTaxFreeThresholdClaimed() {
        return this.taxFreeThresholdClaimed;
    }

    public void setTaxFreeThresholdClaimed(Boolean taxFreeThresholdClaimed) {
        this.taxFreeThresholdClaimed = taxFreeThresholdClaimed;
    }

    public TaxDeclaration taxOffsetEstimatedAmount(BigDecimal taxOffsetEstimatedAmount) {
        this.taxOffsetEstimatedAmount = taxOffsetEstimatedAmount;
        return this;
    }

    @ApiModelProperty(example="100", value="If has tax offset estimated then the tax offset estimated amount. e.g 100")
    public BigDecimal getTaxOffsetEstimatedAmount() {
        return this.taxOffsetEstimatedAmount;
    }

    public void setTaxOffsetEstimatedAmount(BigDecimal taxOffsetEstimatedAmount) {
        this.taxOffsetEstimatedAmount = taxOffsetEstimatedAmount;
    }

    public TaxDeclaration hasHELPDebt(Boolean hasHELPDebt) {
        this.hasHELPDebt = hasHELPDebt;
        return this;
    }

    @ApiModelProperty(example="false", value="If employee has HECS or HELP debt. e.g true or false")
    public Boolean getHasHELPDebt() {
        return this.hasHELPDebt;
    }

    public void setHasHELPDebt(Boolean hasHELPDebt) {
        this.hasHELPDebt = hasHELPDebt;
    }

    public TaxDeclaration hasSFSSDebt(Boolean hasSFSSDebt) {
        this.hasSFSSDebt = hasSFSSDebt;
        return this;
    }

    @ApiModelProperty(example="false", value="If employee has financial supplement debt. e.g true or false")
    public Boolean getHasSFSSDebt() {
        return this.hasSFSSDebt;
    }

    public void setHasSFSSDebt(Boolean hasSFSSDebt) {
        this.hasSFSSDebt = hasSFSSDebt;
    }

    public TaxDeclaration hasTradeSupportLoanDebt(Boolean hasTradeSupportLoanDebt) {
        this.hasTradeSupportLoanDebt = hasTradeSupportLoanDebt;
        return this;
    }

    @ApiModelProperty(example="false", value="If employee has trade support loan. e.g true or false")
    public Boolean getHasTradeSupportLoanDebt() {
        return this.hasTradeSupportLoanDebt;
    }

    public void setHasTradeSupportLoanDebt(Boolean hasTradeSupportLoanDebt) {
        this.hasTradeSupportLoanDebt = hasTradeSupportLoanDebt;
    }

    public TaxDeclaration upwardVariationTaxWithholdingAmount(BigDecimal upwardVariationTaxWithholdingAmount) {
        this.upwardVariationTaxWithholdingAmount = upwardVariationTaxWithholdingAmount;
        return this;
    }

    @ApiModelProperty(example="50", value="If the employee has requested that additional tax be withheld each pay run. e.g 50")
    public BigDecimal getUpwardVariationTaxWithholdingAmount() {
        return this.upwardVariationTaxWithholdingAmount;
    }

    public void setUpwardVariationTaxWithholdingAmount(BigDecimal upwardVariationTaxWithholdingAmount) {
        this.upwardVariationTaxWithholdingAmount = upwardVariationTaxWithholdingAmount;
    }

    public TaxDeclaration eligibleToReceiveLeaveLoading(Boolean eligibleToReceiveLeaveLoading) {
        this.eligibleToReceiveLeaveLoading = eligibleToReceiveLeaveLoading;
        return this;
    }

    @ApiModelProperty(example="false", value="If the employee is eligible to receive an additional percentage on top of ordinary earnings when they take leave (typically 17.5%). e.g true or false")
    public Boolean getEligibleToReceiveLeaveLoading() {
        return this.eligibleToReceiveLeaveLoading;
    }

    public void setEligibleToReceiveLeaveLoading(Boolean eligibleToReceiveLeaveLoading) {
        this.eligibleToReceiveLeaveLoading = eligibleToReceiveLeaveLoading;
    }

    public TaxDeclaration approvedWithholdingVariationPercentage(BigDecimal approvedWithholdingVariationPercentage) {
        this.approvedWithholdingVariationPercentage = approvedWithholdingVariationPercentage;
        return this;
    }

    @ApiModelProperty(example="75", value="If the employee has approved withholding variation. e.g (0 - 100)")
    public BigDecimal getApprovedWithholdingVariationPercentage() {
        return this.approvedWithholdingVariationPercentage;
    }

    public void setApprovedWithholdingVariationPercentage(BigDecimal approvedWithholdingVariationPercentage) {
        this.approvedWithholdingVariationPercentage = approvedWithholdingVariationPercentage;
    }

    public TaxDeclaration hasStudentStartupLoan(Boolean hasStudentStartupLoan) {
        this.hasStudentStartupLoan = hasStudentStartupLoan;
        return this;
    }

    @ApiModelProperty(example="true", value="If the employee is eligible for student startup loan rules")
    public Boolean getHasStudentStartupLoan() {
        return this.hasStudentStartupLoan;
    }

    public void setHasStudentStartupLoan(Boolean hasStudentStartupLoan) {
        this.hasStudentStartupLoan = hasStudentStartupLoan;
    }

    public TaxDeclaration hasLoanOrStudentDebt(Boolean hasLoanOrStudentDebt) {
        this.hasLoanOrStudentDebt = hasLoanOrStudentDebt;
        return this;
    }

    @ApiModelProperty(example="true", value="If the employee has any of the following loans or debts: Higher Education Loan Program (HELP/HECS), VET Student Loan (VSL), Financial Supplement (FS), Student Start-up Loan (SSL), or Trade Support Loan (TSL)")
    public Boolean getHasLoanOrStudentDebt() {
        return this.hasLoanOrStudentDebt;
    }

    public void setHasLoanOrStudentDebt(Boolean hasLoanOrStudentDebt) {
        this.hasLoanOrStudentDebt = hasLoanOrStudentDebt;
    }

    @ApiModelProperty(example="/Date(1583967733054+0000)/", value="Last modified timestamp")
    public String getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public OffsetDateTime getUpdatedDateUTCAsDate() {
        if (this.updatedDateUTC != null) {
            try {
                return this.util.convertStringToOffsetDateTime(this.updatedDateUTC);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaxDeclaration taxDeclaration = (TaxDeclaration)o;
        return Objects.equals(this.employeeID, taxDeclaration.employeeID) && Objects.equals((Object)this.employmentBasis, (Object)taxDeclaration.employmentBasis) && Objects.equals((Object)this.tfNExemptionType, (Object)taxDeclaration.tfNExemptionType) && Objects.equals(this.taxFileNumber, taxDeclaration.taxFileNumber) && Objects.equals(this.ABN, taxDeclaration.ABN) && Objects.equals(this.australianResidentForTaxPurposes, taxDeclaration.australianResidentForTaxPurposes) && Objects.equals((Object)this.residencyStatus, (Object)taxDeclaration.residencyStatus) && Objects.equals((Object)this.taxScaleType, (Object)taxDeclaration.taxScaleType) && Objects.equals((Object)this.workCondition, (Object)taxDeclaration.workCondition) && Objects.equals((Object)this.seniorMaritalStatus, (Object)taxDeclaration.seniorMaritalStatus) && Objects.equals(this.taxFreeThresholdClaimed, taxDeclaration.taxFreeThresholdClaimed) && Objects.equals(this.taxOffsetEstimatedAmount, taxDeclaration.taxOffsetEstimatedAmount) && Objects.equals(this.hasHELPDebt, taxDeclaration.hasHELPDebt) && Objects.equals(this.hasSFSSDebt, taxDeclaration.hasSFSSDebt) && Objects.equals(this.hasTradeSupportLoanDebt, taxDeclaration.hasTradeSupportLoanDebt) && Objects.equals(this.upwardVariationTaxWithholdingAmount, taxDeclaration.upwardVariationTaxWithholdingAmount) && Objects.equals(this.eligibleToReceiveLeaveLoading, taxDeclaration.eligibleToReceiveLeaveLoading) && Objects.equals(this.approvedWithholdingVariationPercentage, taxDeclaration.approvedWithholdingVariationPercentage) && Objects.equals(this.hasStudentStartupLoan, taxDeclaration.hasStudentStartupLoan) && Objects.equals(this.hasLoanOrStudentDebt, taxDeclaration.hasLoanOrStudentDebt) && Objects.equals(this.updatedDateUTC, taxDeclaration.updatedDateUTC);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.employeeID, this.employmentBasis, this.tfNExemptionType, this.taxFileNumber, this.ABN, this.australianResidentForTaxPurposes, this.residencyStatus, this.taxScaleType, this.workCondition, this.seniorMaritalStatus, this.taxFreeThresholdClaimed, this.taxOffsetEstimatedAmount, this.hasHELPDebt, this.hasSFSSDebt, this.hasTradeSupportLoanDebt, this.upwardVariationTaxWithholdingAmount, this.eligibleToReceiveLeaveLoading, this.approvedWithholdingVariationPercentage, this.hasStudentStartupLoan, this.hasLoanOrStudentDebt, this.updatedDateUTC});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaxDeclaration {\n");
        sb.append("    employeeID: ").append(this.toIndentedString(this.employeeID)).append("\n");
        sb.append("    employmentBasis: ").append(this.toIndentedString((Object)this.employmentBasis)).append("\n");
        sb.append("    tfNExemptionType: ").append(this.toIndentedString((Object)this.tfNExemptionType)).append("\n");
        sb.append("    taxFileNumber: ").append(this.toIndentedString(this.taxFileNumber)).append("\n");
        sb.append("    ABN: ").append(this.toIndentedString(this.ABN)).append("\n");
        sb.append("    australianResidentForTaxPurposes: ").append(this.toIndentedString(this.australianResidentForTaxPurposes)).append("\n");
        sb.append("    residencyStatus: ").append(this.toIndentedString((Object)this.residencyStatus)).append("\n");
        sb.append("    taxScaleType: ").append(this.toIndentedString((Object)this.taxScaleType)).append("\n");
        sb.append("    workCondition: ").append(this.toIndentedString((Object)this.workCondition)).append("\n");
        sb.append("    seniorMaritalStatus: ").append(this.toIndentedString((Object)this.seniorMaritalStatus)).append("\n");
        sb.append("    taxFreeThresholdClaimed: ").append(this.toIndentedString(this.taxFreeThresholdClaimed)).append("\n");
        sb.append("    taxOffsetEstimatedAmount: ").append(this.toIndentedString(this.taxOffsetEstimatedAmount)).append("\n");
        sb.append("    hasHELPDebt: ").append(this.toIndentedString(this.hasHELPDebt)).append("\n");
        sb.append("    hasSFSSDebt: ").append(this.toIndentedString(this.hasSFSSDebt)).append("\n");
        sb.append("    hasTradeSupportLoanDebt: ").append(this.toIndentedString(this.hasTradeSupportLoanDebt)).append("\n");
        sb.append("    upwardVariationTaxWithholdingAmount: ").append(this.toIndentedString(this.upwardVariationTaxWithholdingAmount)).append("\n");
        sb.append("    eligibleToReceiveLeaveLoading: ").append(this.toIndentedString(this.eligibleToReceiveLeaveLoading)).append("\n");
        sb.append("    approvedWithholdingVariationPercentage: ").append(this.toIndentedString(this.approvedWithholdingVariationPercentage)).append("\n");
        sb.append("    hasStudentStartupLoan: ").append(this.toIndentedString(this.hasStudentStartupLoan)).append("\n");
        sb.append("    hasLoanOrStudentDebt: ").append(this.toIndentedString(this.hasLoanOrStudentDebt)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

