/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrollnz;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

public class Account {
    StringUtil util = new StringUtil();
    @JsonProperty(value="accountID")
    private UUID accountID;
    @JsonProperty(value="type")
    private TypeEnum type;
    @JsonProperty(value="code")
    private String code;
    @JsonProperty(value="name")
    private String name;

    public Account accountID(UUID accountID) {
        this.accountID = accountID;
        return this;
    }

    @ApiModelProperty(value="The Xero identifier for Settings.")
    public UUID getAccountID() {
        return this.accountID;
    }

    public void setAccountID(UUID accountID) {
        this.accountID = accountID;
    }

    public Account type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The assigned AccountType")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Account code(String code) {
        this.code = code;
        return this;
    }

    @ApiModelProperty(value="A unique 3 digit number for each Account")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Account name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Name of the Account.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Account account = (Account)o;
        return Objects.equals(this.accountID, account.accountID) && Objects.equals((Object)this.type, (Object)account.type) && Objects.equals(this.code, account.code) && Objects.equals(this.name, account.name);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountID, this.type, this.code, this.name});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Account {\n");
        sb.append("    accountID: ").append(this.toIndentedString(this.accountID)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        PAYELIABILITY("PAYELIABILITY"),
        WAGESPAYABLE("WAGESPAYABLE"),
        WAGESEXPENSE("WAGESEXPENSE"),
        BANK("BANK");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

