/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrollnz;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import com.xero.models.payrollnz.TaxCode;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.threeten.bp.LocalDate;

public class EmployeeTax {
    StringUtil util = new StringUtil();
    @JsonProperty(value="irdNumber")
    private String irdNumber;
    @JsonProperty(value="taxCode")
    private TaxCode taxCode;
    @JsonProperty(value="specialTaxRatePercentage")
    private Double specialTaxRatePercentage;
    @JsonProperty(value="hasSpecialStudentLoanRate")
    private Boolean hasSpecialStudentLoanRate;
    @JsonProperty(value="specialStudentLoanRatePercentage")
    private Double specialStudentLoanRatePercentage;
    @JsonProperty(value="isEligibleForKiwiSaver")
    private Boolean isEligibleForKiwiSaver;
    @JsonProperty(value="esctRatePercentage")
    private Double esctRatePercentage;
    @JsonProperty(value="kiwiSaverContributions")
    private KiwiSaverContributionsEnum kiwiSaverContributions;
    @JsonProperty(value="kiwiSaverEmployeeContributionRatePercentage")
    private Double kiwiSaverEmployeeContributionRatePercentage;
    @JsonProperty(value="kiwiSaverEmployerContributionRatePercentage")
    private Double kiwiSaverEmployerContributionRatePercentage;
    @JsonProperty(value="kiwiSaverEmployerSalarySacrificeContributionRatePercentage")
    private Double kiwiSaverEmployerSalarySacrificeContributionRatePercentage;
    @JsonProperty(value="kiwiSaverOptOutDate")
    private LocalDate kiwiSaverOptOutDate;
    @JsonProperty(value="kiwiSaverContributionHolidayEndDate")
    private LocalDate kiwiSaverContributionHolidayEndDate;
    @JsonProperty(value="hasStudentLoanBalance")
    private Boolean hasStudentLoanBalance;
    @JsonProperty(value="studentLoanBalance")
    private Double studentLoanBalance;
    @JsonProperty(value="studentLoanAsAt")
    private LocalDate studentLoanAsAt;

    public EmployeeTax irdNumber(String irdNumber) {
        this.irdNumber = irdNumber;
        return this;
    }

    @ApiModelProperty(example="111111111", value="The IRD Number.")
    public String getIrdNumber() {
        return this.irdNumber;
    }

    public void setIrdNumber(String irdNumber) {
        this.irdNumber = irdNumber;
    }

    public EmployeeTax taxCode(TaxCode taxCode) {
        this.taxCode = taxCode;
        return this;
    }

    @ApiModelProperty(value="")
    public TaxCode getTaxCode() {
        return this.taxCode;
    }

    public void setTaxCode(TaxCode taxCode) {
        this.taxCode = taxCode;
    }

    public EmployeeTax specialTaxRatePercentage(Double specialTaxRatePercentage) {
        this.specialTaxRatePercentage = specialTaxRatePercentage;
        return this;
    }

    @ApiModelProperty(example="17.5", value="Special tax rate percentage.")
    public Double getSpecialTaxRatePercentage() {
        return this.specialTaxRatePercentage;
    }

    public void setSpecialTaxRatePercentage(Double specialTaxRatePercentage) {
        this.specialTaxRatePercentage = specialTaxRatePercentage;
    }

    public EmployeeTax hasSpecialStudentLoanRate(Boolean hasSpecialStudentLoanRate) {
        this.hasSpecialStudentLoanRate = hasSpecialStudentLoanRate;
        return this;
    }

    @ApiModelProperty(example="true", value="Does the employee has a special student loan rate?")
    public Boolean getHasSpecialStudentLoanRate() {
        return this.hasSpecialStudentLoanRate;
    }

    public void setHasSpecialStudentLoanRate(Boolean hasSpecialStudentLoanRate) {
        this.hasSpecialStudentLoanRate = hasSpecialStudentLoanRate;
    }

    public EmployeeTax specialStudentLoanRatePercentage(Double specialStudentLoanRatePercentage) {
        this.specialStudentLoanRatePercentage = specialStudentLoanRatePercentage;
        return this;
    }

    @ApiModelProperty(example="2.0", value="The employee student loan rate percentage.")
    public Double getSpecialStudentLoanRatePercentage() {
        return this.specialStudentLoanRatePercentage;
    }

    public void setSpecialStudentLoanRatePercentage(Double specialStudentLoanRatePercentage) {
        this.specialStudentLoanRatePercentage = specialStudentLoanRatePercentage;
    }

    public EmployeeTax isEligibleForKiwiSaver(Boolean isEligibleForKiwiSaver) {
        this.isEligibleForKiwiSaver = isEligibleForKiwiSaver;
        return this;
    }

    @ApiModelProperty(example="true", value="The employee eligibility for KiwiSaver.")
    public Boolean getIsEligibleForKiwiSaver() {
        return this.isEligibleForKiwiSaver;
    }

    public void setIsEligibleForKiwiSaver(Boolean isEligibleForKiwiSaver) {
        this.isEligibleForKiwiSaver = isEligibleForKiwiSaver;
    }

    public EmployeeTax esctRatePercentage(Double esctRatePercentage) {
        this.esctRatePercentage = esctRatePercentage;
        return this;
    }

    @ApiModelProperty(example="1.0", value="Employer superannuation contribution tax rate.")
    public Double getEsctRatePercentage() {
        return this.esctRatePercentage;
    }

    public void setEsctRatePercentage(Double esctRatePercentage) {
        this.esctRatePercentage = esctRatePercentage;
    }

    public EmployeeTax kiwiSaverContributions(KiwiSaverContributionsEnum kiwiSaverContributions) {
        this.kiwiSaverContributions = kiwiSaverContributions;
        return this;
    }

    @ApiModelProperty(example="MakeContributions", value="Contribution Option which can be 'MakeContributions' 'OptOut', 'OnAContributionsHoliday', 'OnASavingsSuspension', 'NotCurrentlyAKiwiSaverMember' for employees without a KiwiSaver membership")
    public KiwiSaverContributionsEnum getKiwiSaverContributions() {
        return this.kiwiSaverContributions;
    }

    public void setKiwiSaverContributions(KiwiSaverContributionsEnum kiwiSaverContributions) {
        this.kiwiSaverContributions = kiwiSaverContributions;
    }

    public EmployeeTax kiwiSaverEmployeeContributionRatePercentage(Double kiwiSaverEmployeeContributionRatePercentage) {
        this.kiwiSaverEmployeeContributionRatePercentage = kiwiSaverEmployeeContributionRatePercentage;
        return this;
    }

    @ApiModelProperty(example="4.0", value="Employee Contribution percentage.")
    public Double getKiwiSaverEmployeeContributionRatePercentage() {
        return this.kiwiSaverEmployeeContributionRatePercentage;
    }

    public void setKiwiSaverEmployeeContributionRatePercentage(Double kiwiSaverEmployeeContributionRatePercentage) {
        this.kiwiSaverEmployeeContributionRatePercentage = kiwiSaverEmployeeContributionRatePercentage;
    }

    public EmployeeTax kiwiSaverEmployerContributionRatePercentage(Double kiwiSaverEmployerContributionRatePercentage) {
        this.kiwiSaverEmployerContributionRatePercentage = kiwiSaverEmployerContributionRatePercentage;
        return this;
    }

    @ApiModelProperty(example="10.0", value="Employer Contribution percentage.")
    public Double getKiwiSaverEmployerContributionRatePercentage() {
        return this.kiwiSaverEmployerContributionRatePercentage;
    }

    public void setKiwiSaverEmployerContributionRatePercentage(Double kiwiSaverEmployerContributionRatePercentage) {
        this.kiwiSaverEmployerContributionRatePercentage = kiwiSaverEmployerContributionRatePercentage;
    }

    public EmployeeTax kiwiSaverEmployerSalarySacrificeContributionRatePercentage(Double kiwiSaverEmployerSalarySacrificeContributionRatePercentage) {
        this.kiwiSaverEmployerSalarySacrificeContributionRatePercentage = kiwiSaverEmployerSalarySacrificeContributionRatePercentage;
        return this;
    }

    @ApiModelProperty(example="2.0", value="Employer Contribution through Salary Sacrifice percentage.")
    public Double getKiwiSaverEmployerSalarySacrificeContributionRatePercentage() {
        return this.kiwiSaverEmployerSalarySacrificeContributionRatePercentage;
    }

    public void setKiwiSaverEmployerSalarySacrificeContributionRatePercentage(Double kiwiSaverEmployerSalarySacrificeContributionRatePercentage) {
        this.kiwiSaverEmployerSalarySacrificeContributionRatePercentage = kiwiSaverEmployerSalarySacrificeContributionRatePercentage;
    }

    public EmployeeTax kiwiSaverOptOutDate(LocalDate kiwiSaverOptOutDate) {
        this.kiwiSaverOptOutDate = kiwiSaverOptOutDate;
        return this;
    }

    @ApiModelProperty(value="Opt Out Date.")
    public LocalDate getKiwiSaverOptOutDate() {
        return this.kiwiSaverOptOutDate;
    }

    public void setKiwiSaverOptOutDate(LocalDate kiwiSaverOptOutDate) {
        this.kiwiSaverOptOutDate = kiwiSaverOptOutDate;
    }

    public EmployeeTax kiwiSaverContributionHolidayEndDate(LocalDate kiwiSaverContributionHolidayEndDate) {
        this.kiwiSaverContributionHolidayEndDate = kiwiSaverContributionHolidayEndDate;
        return this;
    }

    @ApiModelProperty(value="Contribution holiday expiry date or end date.")
    public LocalDate getKiwiSaverContributionHolidayEndDate() {
        return this.kiwiSaverContributionHolidayEndDate;
    }

    public void setKiwiSaverContributionHolidayEndDate(LocalDate kiwiSaverContributionHolidayEndDate) {
        this.kiwiSaverContributionHolidayEndDate = kiwiSaverContributionHolidayEndDate;
    }

    public EmployeeTax hasStudentLoanBalance(Boolean hasStudentLoanBalance) {
        this.hasStudentLoanBalance = hasStudentLoanBalance;
        return this;
    }

    @ApiModelProperty(example="false", value="Does the employee have a remaining student loan balance? Set a remaining balance if you have received a letter from IR.")
    public Boolean getHasStudentLoanBalance() {
        return this.hasStudentLoanBalance;
    }

    public void setHasStudentLoanBalance(Boolean hasStudentLoanBalance) {
        this.hasStudentLoanBalance = hasStudentLoanBalance;
    }

    public EmployeeTax studentLoanBalance(Double studentLoanBalance) {
        this.studentLoanBalance = studentLoanBalance;
        return this;
    }

    @ApiModelProperty(example="30.0", value="The employee's student loan balance shown on the letter from IR.")
    public Double getStudentLoanBalance() {
        return this.studentLoanBalance;
    }

    public void setStudentLoanBalance(Double studentLoanBalance) {
        this.studentLoanBalance = studentLoanBalance;
    }

    public EmployeeTax studentLoanAsAt(LocalDate studentLoanAsAt) {
        this.studentLoanAsAt = studentLoanAsAt;
        return this;
    }

    @ApiModelProperty(value="The date of the letter from IR.")
    public LocalDate getStudentLoanAsAt() {
        return this.studentLoanAsAt;
    }

    public void setStudentLoanAsAt(LocalDate studentLoanAsAt) {
        this.studentLoanAsAt = studentLoanAsAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmployeeTax employeeTax = (EmployeeTax)o;
        return Objects.equals(this.irdNumber, employeeTax.irdNumber) && Objects.equals((Object)this.taxCode, (Object)employeeTax.taxCode) && Objects.equals(this.specialTaxRatePercentage, employeeTax.specialTaxRatePercentage) && Objects.equals(this.hasSpecialStudentLoanRate, employeeTax.hasSpecialStudentLoanRate) && Objects.equals(this.specialStudentLoanRatePercentage, employeeTax.specialStudentLoanRatePercentage) && Objects.equals(this.isEligibleForKiwiSaver, employeeTax.isEligibleForKiwiSaver) && Objects.equals(this.esctRatePercentage, employeeTax.esctRatePercentage) && Objects.equals((Object)this.kiwiSaverContributions, (Object)employeeTax.kiwiSaverContributions) && Objects.equals(this.kiwiSaverEmployeeContributionRatePercentage, employeeTax.kiwiSaverEmployeeContributionRatePercentage) && Objects.equals(this.kiwiSaverEmployerContributionRatePercentage, employeeTax.kiwiSaverEmployerContributionRatePercentage) && Objects.equals(this.kiwiSaverEmployerSalarySacrificeContributionRatePercentage, employeeTax.kiwiSaverEmployerSalarySacrificeContributionRatePercentage) && Objects.equals(this.kiwiSaverOptOutDate, employeeTax.kiwiSaverOptOutDate) && Objects.equals(this.kiwiSaverContributionHolidayEndDate, employeeTax.kiwiSaverContributionHolidayEndDate) && Objects.equals(this.hasStudentLoanBalance, employeeTax.hasStudentLoanBalance) && Objects.equals(this.studentLoanBalance, employeeTax.studentLoanBalance) && Objects.equals(this.studentLoanAsAt, employeeTax.studentLoanAsAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.irdNumber, this.taxCode, this.specialTaxRatePercentage, this.hasSpecialStudentLoanRate, this.specialStudentLoanRatePercentage, this.isEligibleForKiwiSaver, this.esctRatePercentage, this.kiwiSaverContributions, this.kiwiSaverEmployeeContributionRatePercentage, this.kiwiSaverEmployerContributionRatePercentage, this.kiwiSaverEmployerSalarySacrificeContributionRatePercentage, this.kiwiSaverOptOutDate, this.kiwiSaverContributionHolidayEndDate, this.hasStudentLoanBalance, this.studentLoanBalance, this.studentLoanAsAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmployeeTax {\n");
        sb.append("    irdNumber: ").append(this.toIndentedString(this.irdNumber)).append("\n");
        sb.append("    taxCode: ").append(this.toIndentedString((Object)this.taxCode)).append("\n");
        sb.append("    specialTaxRatePercentage: ").append(this.toIndentedString(this.specialTaxRatePercentage)).append("\n");
        sb.append("    hasSpecialStudentLoanRate: ").append(this.toIndentedString(this.hasSpecialStudentLoanRate)).append("\n");
        sb.append("    specialStudentLoanRatePercentage: ").append(this.toIndentedString(this.specialStudentLoanRatePercentage)).append("\n");
        sb.append("    isEligibleForKiwiSaver: ").append(this.toIndentedString(this.isEligibleForKiwiSaver)).append("\n");
        sb.append("    esctRatePercentage: ").append(this.toIndentedString(this.esctRatePercentage)).append("\n");
        sb.append("    kiwiSaverContributions: ").append(this.toIndentedString((Object)this.kiwiSaverContributions)).append("\n");
        sb.append("    kiwiSaverEmployeeContributionRatePercentage: ").append(this.toIndentedString(this.kiwiSaverEmployeeContributionRatePercentage)).append("\n");
        sb.append("    kiwiSaverEmployerContributionRatePercentage: ").append(this.toIndentedString(this.kiwiSaverEmployerContributionRatePercentage)).append("\n");
        sb.append("    kiwiSaverEmployerSalarySacrificeContributionRatePercentage: ").append(this.toIndentedString(this.kiwiSaverEmployerSalarySacrificeContributionRatePercentage)).append("\n");
        sb.append("    kiwiSaverOptOutDate: ").append(this.toIndentedString(this.kiwiSaverOptOutDate)).append("\n");
        sb.append("    kiwiSaverContributionHolidayEndDate: ").append(this.toIndentedString(this.kiwiSaverContributionHolidayEndDate)).append("\n");
        sb.append("    hasStudentLoanBalance: ").append(this.toIndentedString(this.hasStudentLoanBalance)).append("\n");
        sb.append("    studentLoanBalance: ").append(this.toIndentedString(this.studentLoanBalance)).append("\n");
        sb.append("    studentLoanAsAt: ").append(this.toIndentedString(this.studentLoanAsAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum KiwiSaverContributionsEnum {
        MAKECONTRIBUTIONS("MakeContributions"),
        OPTOUT("OptOut"),
        ONACONTRIBUTIONSHOLIDAY("OnAContributionsHoliday"),
        ONASAVINGSSUSPENSION("OnASavingsSuspension"),
        NOTCURRENTLYAKIWISAVERMEMBER("NotCurrentlyAKiwiSaverMember");

        private String value;

        private KiwiSaverContributionsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static KiwiSaverContributionsEnum fromValue(String value) {
            for (KiwiSaverContributionsEnum b : KiwiSaverContributionsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

