/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrollnz;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;

public class Employment {
    StringUtil util = new StringUtil();
    @JsonProperty(value="payrollCalendarID")
    private UUID payrollCalendarID;
    @JsonProperty(value="payRunCalendarID")
    private UUID payRunCalendarID;
    @JsonProperty(value="startDate")
    private LocalDate startDate;
    @JsonProperty(value="engagementType")
    private String engagementType;
    @JsonProperty(value="fixedTermEndDate")
    private LocalDate fixedTermEndDate;

    public Employment payrollCalendarID(UUID payrollCalendarID) {
        this.payrollCalendarID = payrollCalendarID;
        return this;
    }

    @ApiModelProperty(value="Xero unique identifier for the payroll calendar of the employee")
    public UUID getPayrollCalendarID() {
        return this.payrollCalendarID;
    }

    public void setPayrollCalendarID(UUID payrollCalendarID) {
        this.payrollCalendarID = payrollCalendarID;
    }

    public Employment payRunCalendarID(UUID payRunCalendarID) {
        this.payRunCalendarID = payRunCalendarID;
        return this;
    }

    @ApiModelProperty(value="Xero unique identifier for the payrun calendar for the employee (Deprecated in version 1.1.6)")
    public UUID getPayRunCalendarID() {
        return this.payRunCalendarID;
    }

    public void setPayRunCalendarID(UUID payRunCalendarID) {
        this.payRunCalendarID = payRunCalendarID;
    }

    public Employment startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(value="Start date of the employment (YYYY-MM-DD)")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public Employment engagementType(String engagementType) {
        this.engagementType = engagementType;
        return this;
    }

    @ApiModelProperty(example="Permanent", value="Engagement type of the employee")
    public String getEngagementType() {
        return this.engagementType;
    }

    public void setEngagementType(String engagementType) {
        this.engagementType = engagementType;
    }

    public Employment fixedTermEndDate(LocalDate fixedTermEndDate) {
        this.fixedTermEndDate = fixedTermEndDate;
        return this;
    }

    @ApiModelProperty(example="Sun Jan 19 00:00:00 UTC 2020", value="End date for an employee with a fixed-term engagement type")
    public LocalDate getFixedTermEndDate() {
        return this.fixedTermEndDate;
    }

    public void setFixedTermEndDate(LocalDate fixedTermEndDate) {
        this.fixedTermEndDate = fixedTermEndDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Employment employment = (Employment)o;
        return Objects.equals(this.payrollCalendarID, employment.payrollCalendarID) && Objects.equals(this.payRunCalendarID, employment.payRunCalendarID) && Objects.equals(this.startDate, employment.startDate) && Objects.equals(this.engagementType, employment.engagementType) && Objects.equals(this.fixedTermEndDate, employment.fixedTermEndDate);
    }

    public int hashCode() {
        return Objects.hash(this.payrollCalendarID, this.payRunCalendarID, this.startDate, this.engagementType, this.fixedTermEndDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Employment {\n");
        sb.append("    payrollCalendarID: ").append(this.toIndentedString(this.payrollCalendarID)).append("\n");
        sb.append("    payRunCalendarID: ").append(this.toIndentedString(this.payRunCalendarID)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    engagementType: ").append(this.toIndentedString(this.engagementType)).append("\n");
        sb.append("    fixedTermEndDate: ").append(this.toIndentedString(this.fixedTermEndDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

