/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrollnz;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import com.xero.models.payrollnz.TaxCode;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class TaxSettings {
    StringUtil util = new StringUtil();
    @JsonProperty(value="periodUnits")
    private Double periodUnits;
    @JsonProperty(value="periodType")
    private PeriodTypeEnum periodType;
    @JsonProperty(value="taxCode")
    private TaxCode taxCode;
    @JsonProperty(value="specialTaxRate")
    private String specialTaxRate;
    @JsonProperty(value="lumpSumTaxCode")
    private String lumpSumTaxCode;
    @JsonProperty(value="lumpSumAmount")
    private String lumpSumAmount;

    public TaxSettings periodUnits(Double periodUnits) {
        this.periodUnits = periodUnits;
        return this;
    }

    @ApiModelProperty(value="The number of units for the period type")
    public Double getPeriodUnits() {
        return this.periodUnits;
    }

    public void setPeriodUnits(Double periodUnits) {
        this.periodUnits = periodUnits;
    }

    public TaxSettings periodType(PeriodTypeEnum periodType) {
        this.periodType = periodType;
        return this;
    }

    @ApiModelProperty(example="weeks", value="The type of period (\"weeks\" or \"months\")")
    public PeriodTypeEnum getPeriodType() {
        return this.periodType;
    }

    public void setPeriodType(PeriodTypeEnum periodType) {
        this.periodType = periodType;
    }

    public TaxSettings taxCode(TaxCode taxCode) {
        this.taxCode = taxCode;
        return this;
    }

    @ApiModelProperty(value="")
    public TaxCode getTaxCode() {
        return this.taxCode;
    }

    public void setTaxCode(TaxCode taxCode) {
        this.taxCode = taxCode;
    }

    public TaxSettings specialTaxRate(String specialTaxRate) {
        this.specialTaxRate = specialTaxRate;
        return this;
    }

    @ApiModelProperty(value="Tax rate for STC and WT")
    public String getSpecialTaxRate() {
        return this.specialTaxRate;
    }

    public void setSpecialTaxRate(String specialTaxRate) {
        this.specialTaxRate = specialTaxRate;
    }

    public TaxSettings lumpSumTaxCode(String lumpSumTaxCode) {
        this.lumpSumTaxCode = lumpSumTaxCode;
        return this;
    }

    @ApiModelProperty(value="Tax code for a lump sum amount")
    public String getLumpSumTaxCode() {
        return this.lumpSumTaxCode;
    }

    public void setLumpSumTaxCode(String lumpSumTaxCode) {
        this.lumpSumTaxCode = lumpSumTaxCode;
    }

    public TaxSettings lumpSumAmount(String lumpSumAmount) {
        this.lumpSumAmount = lumpSumAmount;
        return this;
    }

    @ApiModelProperty(value="The total of the lump sum amount")
    public String getLumpSumAmount() {
        return this.lumpSumAmount;
    }

    public void setLumpSumAmount(String lumpSumAmount) {
        this.lumpSumAmount = lumpSumAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaxSettings taxSettings = (TaxSettings)o;
        return Objects.equals(this.periodUnits, taxSettings.periodUnits) && Objects.equals((Object)this.periodType, (Object)taxSettings.periodType) && Objects.equals((Object)this.taxCode, (Object)taxSettings.taxCode) && Objects.equals(this.specialTaxRate, taxSettings.specialTaxRate) && Objects.equals(this.lumpSumTaxCode, taxSettings.lumpSumTaxCode) && Objects.equals(this.lumpSumAmount, taxSettings.lumpSumAmount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.periodUnits, this.periodType, this.taxCode, this.specialTaxRate, this.lumpSumTaxCode, this.lumpSumAmount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaxSettings {\n");
        sb.append("    periodUnits: ").append(this.toIndentedString(this.periodUnits)).append("\n");
        sb.append("    periodType: ").append(this.toIndentedString((Object)this.periodType)).append("\n");
        sb.append("    taxCode: ").append(this.toIndentedString((Object)this.taxCode)).append("\n");
        sb.append("    specialTaxRate: ").append(this.toIndentedString(this.specialTaxRate)).append("\n");
        sb.append("    lumpSumTaxCode: ").append(this.toIndentedString(this.lumpSumTaxCode)).append("\n");
        sb.append("    lumpSumAmount: ").append(this.toIndentedString(this.lumpSumAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PeriodTypeEnum {
        WEEKS("weeks"),
        MONTHS("months");

        private String value;

        private PeriodTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PeriodTypeEnum fromValue(String value) {
            for (PeriodTypeEnum b : PeriodTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

