/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrollnz;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;

public class TimesheetLine {
    StringUtil util = new StringUtil();
    @JsonProperty(value="timesheetLineID")
    private UUID timesheetLineID;
    @JsonProperty(value="date")
    private LocalDate date;
    @JsonProperty(value="earningsRateID")
    private UUID earningsRateID;
    @JsonProperty(value="trackingItemID")
    private UUID trackingItemID;
    @JsonProperty(value="numberOfUnits")
    private Double numberOfUnits;

    public TimesheetLine timesheetLineID(UUID timesheetLineID) {
        this.timesheetLineID = timesheetLineID;
        return this;
    }

    @ApiModelProperty(value="The Xero identifier for a Timesheet Line")
    public UUID getTimesheetLineID() {
        return this.timesheetLineID;
    }

    public void setTimesheetLineID(UUID timesheetLineID) {
        this.timesheetLineID = timesheetLineID;
    }

    public TimesheetLine date(LocalDate date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(required=true, value="The Date that this Timesheet Line is for (YYYY-MM-DD)")
    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public TimesheetLine earningsRateID(UUID earningsRateID) {
        this.earningsRateID = earningsRateID;
        return this;
    }

    @ApiModelProperty(required=true, value="The Xero identifier for the Earnings Rate that the Timesheet is for")
    public UUID getEarningsRateID() {
        return this.earningsRateID;
    }

    public void setEarningsRateID(UUID earningsRateID) {
        this.earningsRateID = earningsRateID;
    }

    public TimesheetLine trackingItemID(UUID trackingItemID) {
        this.trackingItemID = trackingItemID;
        return this;
    }

    @ApiModelProperty(value="The Xero identifier for the Tracking Item that the Timesheet is for")
    public UUID getTrackingItemID() {
        return this.trackingItemID;
    }

    public void setTrackingItemID(UUID trackingItemID) {
        this.trackingItemID = trackingItemID;
    }

    public TimesheetLine numberOfUnits(Double numberOfUnits) {
        this.numberOfUnits = numberOfUnits;
        return this;
    }

    @ApiModelProperty(required=true, value="The Number of Units of the Timesheet Line")
    public Double getNumberOfUnits() {
        return this.numberOfUnits;
    }

    public void setNumberOfUnits(Double numberOfUnits) {
        this.numberOfUnits = numberOfUnits;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimesheetLine timesheetLine = (TimesheetLine)o;
        return Objects.equals(this.timesheetLineID, timesheetLine.timesheetLineID) && Objects.equals(this.date, timesheetLine.date) && Objects.equals(this.earningsRateID, timesheetLine.earningsRateID) && Objects.equals(this.trackingItemID, timesheetLine.trackingItemID) && Objects.equals(this.numberOfUnits, timesheetLine.numberOfUnits);
    }

    public int hashCode() {
        return Objects.hash(this.timesheetLineID, this.date, this.earningsRateID, this.trackingItemID, this.numberOfUnits);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TimesheetLine {\n");
        sb.append("    timesheetLineID: ").append(this.toIndentedString(this.timesheetLineID)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    earningsRateID: ").append(this.toIndentedString(this.earningsRateID)).append("\n");
        sb.append("    trackingItemID: ").append(this.toIndentedString(this.trackingItemID)).append("\n");
        sb.append("    numberOfUnits: ").append(this.toIndentedString(this.numberOfUnits)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

