/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrolluk;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;

public class SalaryAndWage {
    StringUtil util = new StringUtil();
    @JsonProperty(value="salaryAndWagesID")
    private UUID salaryAndWagesID;
    @JsonProperty(value="earningsRateID")
    private UUID earningsRateID;
    @JsonProperty(value="numberOfUnitsPerWeek")
    private Double numberOfUnitsPerWeek;
    @JsonProperty(value="ratePerUnit")
    private Double ratePerUnit;
    @JsonProperty(value="numberOfUnitsPerDay")
    private Double numberOfUnitsPerDay;
    @JsonProperty(value="effectiveFrom")
    private LocalDate effectiveFrom;
    @JsonProperty(value="annualSalary")
    private Double annualSalary;
    @JsonProperty(value="status")
    private StatusEnum status;
    @JsonProperty(value="paymentType")
    private PaymentTypeEnum paymentType;

    public SalaryAndWage salaryAndWagesID(UUID salaryAndWagesID) {
        this.salaryAndWagesID = salaryAndWagesID;
        return this;
    }

    @ApiModelProperty(value="Xero unique identifier for a salary and wages record")
    public UUID getSalaryAndWagesID() {
        return this.salaryAndWagesID;
    }

    public void setSalaryAndWagesID(UUID salaryAndWagesID) {
        this.salaryAndWagesID = salaryAndWagesID;
    }

    public SalaryAndWage earningsRateID(UUID earningsRateID) {
        this.earningsRateID = earningsRateID;
        return this;
    }

    @ApiModelProperty(required=true, value="Xero unique identifier for an earnings rate")
    public UUID getEarningsRateID() {
        return this.earningsRateID;
    }

    public void setEarningsRateID(UUID earningsRateID) {
        this.earningsRateID = earningsRateID;
    }

    public SalaryAndWage numberOfUnitsPerWeek(Double numberOfUnitsPerWeek) {
        this.numberOfUnitsPerWeek = numberOfUnitsPerWeek;
        return this;
    }

    @ApiModelProperty(required=true, value="The Number of Units per week for the corresponding salary and wages")
    public Double getNumberOfUnitsPerWeek() {
        return this.numberOfUnitsPerWeek;
    }

    public void setNumberOfUnitsPerWeek(Double numberOfUnitsPerWeek) {
        this.numberOfUnitsPerWeek = numberOfUnitsPerWeek;
    }

    public SalaryAndWage ratePerUnit(Double ratePerUnit) {
        this.ratePerUnit = ratePerUnit;
        return this;
    }

    @ApiModelProperty(value="The rate of each unit for the corresponding salary and wages")
    public Double getRatePerUnit() {
        return this.ratePerUnit;
    }

    public void setRatePerUnit(Double ratePerUnit) {
        this.ratePerUnit = ratePerUnit;
    }

    public SalaryAndWage numberOfUnitsPerDay(Double numberOfUnitsPerDay) {
        this.numberOfUnitsPerDay = numberOfUnitsPerDay;
        return this;
    }

    @ApiModelProperty(value="The Number of Units per day for the corresponding salary and wages")
    public Double getNumberOfUnitsPerDay() {
        return this.numberOfUnitsPerDay;
    }

    public void setNumberOfUnitsPerDay(Double numberOfUnitsPerDay) {
        this.numberOfUnitsPerDay = numberOfUnitsPerDay;
    }

    public SalaryAndWage effectiveFrom(LocalDate effectiveFrom) {
        this.effectiveFrom = effectiveFrom;
        return this;
    }

    @ApiModelProperty(required=true, value="The effective date of the corresponding salary and wages")
    public LocalDate getEffectiveFrom() {
        return this.effectiveFrom;
    }

    public void setEffectiveFrom(LocalDate effectiveFrom) {
        this.effectiveFrom = effectiveFrom;
    }

    public SalaryAndWage annualSalary(Double annualSalary) {
        this.annualSalary = annualSalary;
        return this;
    }

    @ApiModelProperty(required=true, value="The annual salary")
    public Double getAnnualSalary() {
        return this.annualSalary;
    }

    public void setAnnualSalary(Double annualSalary) {
        this.annualSalary = annualSalary;
    }

    public SalaryAndWage status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="The current status of the corresponding salary and wages")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public SalaryAndWage paymentType(PaymentTypeEnum paymentType) {
        this.paymentType = paymentType;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of the payment of the corresponding salary and wages")
    public PaymentTypeEnum getPaymentType() {
        return this.paymentType;
    }

    public void setPaymentType(PaymentTypeEnum paymentType) {
        this.paymentType = paymentType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SalaryAndWage salaryAndWage = (SalaryAndWage)o;
        return Objects.equals(this.salaryAndWagesID, salaryAndWage.salaryAndWagesID) && Objects.equals(this.earningsRateID, salaryAndWage.earningsRateID) && Objects.equals(this.numberOfUnitsPerWeek, salaryAndWage.numberOfUnitsPerWeek) && Objects.equals(this.ratePerUnit, salaryAndWage.ratePerUnit) && Objects.equals(this.numberOfUnitsPerDay, salaryAndWage.numberOfUnitsPerDay) && Objects.equals(this.effectiveFrom, salaryAndWage.effectiveFrom) && Objects.equals(this.annualSalary, salaryAndWage.annualSalary) && Objects.equals((Object)this.status, (Object)salaryAndWage.status) && Objects.equals((Object)this.paymentType, (Object)salaryAndWage.paymentType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.salaryAndWagesID, this.earningsRateID, this.numberOfUnitsPerWeek, this.ratePerUnit, this.numberOfUnitsPerDay, this.effectiveFrom, this.annualSalary, this.status, this.paymentType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SalaryAndWage {\n");
        sb.append("    salaryAndWagesID: ").append(this.toIndentedString(this.salaryAndWagesID)).append("\n");
        sb.append("    earningsRateID: ").append(this.toIndentedString(this.earningsRateID)).append("\n");
        sb.append("    numberOfUnitsPerWeek: ").append(this.toIndentedString(this.numberOfUnitsPerWeek)).append("\n");
        sb.append("    ratePerUnit: ").append(this.toIndentedString(this.ratePerUnit)).append("\n");
        sb.append("    numberOfUnitsPerDay: ").append(this.toIndentedString(this.numberOfUnitsPerDay)).append("\n");
        sb.append("    effectiveFrom: ").append(this.toIndentedString(this.effectiveFrom)).append("\n");
        sb.append("    annualSalary: ").append(this.toIndentedString(this.annualSalary)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    paymentType: ").append(this.toIndentedString((Object)this.paymentType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ACTIVE("Active"),
        PENDING("Pending"),
        HISTORY("History");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PaymentTypeEnum {
        SALARY("Salary"),
        HOURLY("Hourly");

        private String value;

        private PaymentTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PaymentTypeEnum fromValue(String value) {
            for (PaymentTypeEnum b : PaymentTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

