/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrolluk;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import com.xero.models.payrolluk.TimesheetLine;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalDateTime;

public class Timesheet {
    StringUtil util = new StringUtil();
    @JsonProperty(value="timesheetID")
    private UUID timesheetID;
    @JsonProperty(value="payrollCalendarID")
    private UUID payrollCalendarID;
    @JsonProperty(value="employeeID")
    private UUID employeeID;
    @JsonProperty(value="startDate")
    private LocalDate startDate;
    @JsonProperty(value="endDate")
    private LocalDate endDate;
    @JsonProperty(value="status")
    private StatusEnum status;
    @JsonProperty(value="totalHours")
    private Double totalHours;
    @JsonProperty(value="updatedDateUTC")
    private LocalDateTime updatedDateUTC;
    @JsonProperty(value="timesheetLines")
    private List<TimesheetLine> timesheetLines = new ArrayList<TimesheetLine>();

    public Timesheet timesheetID(UUID timesheetID) {
        this.timesheetID = timesheetID;
        return this;
    }

    @ApiModelProperty(value="The Xero identifier for a Timesheet")
    public UUID getTimesheetID() {
        return this.timesheetID;
    }

    public void setTimesheetID(UUID timesheetID) {
        this.timesheetID = timesheetID;
    }

    public Timesheet payrollCalendarID(UUID payrollCalendarID) {
        this.payrollCalendarID = payrollCalendarID;
        return this;
    }

    @ApiModelProperty(required=true, value="The Xero identifier for the Payroll Calendar that the Timesheet applies to")
    public UUID getPayrollCalendarID() {
        return this.payrollCalendarID;
    }

    public void setPayrollCalendarID(UUID payrollCalendarID) {
        this.payrollCalendarID = payrollCalendarID;
    }

    public Timesheet employeeID(UUID employeeID) {
        this.employeeID = employeeID;
        return this;
    }

    @ApiModelProperty(required=true, value="The Xero identifier for the Employee that the Timesheet is for")
    public UUID getEmployeeID() {
        return this.employeeID;
    }

    public void setEmployeeID(UUID employeeID) {
        this.employeeID = employeeID;
    }

    public Timesheet startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The Start Date of the Timesheet period (YYYY-MM-DD)")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public Timesheet endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The End Date of the Timesheet period (YYYY-MM-DD)")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public Timesheet status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="Status of the timesheet")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Timesheet totalHours(Double totalHours) {
        this.totalHours = totalHours;
        return this;
    }

    @ApiModelProperty(value="The Total Hours of the Timesheet")
    public Double getTotalHours() {
        return this.totalHours;
    }

    public void setTotalHours(Double totalHours) {
        this.totalHours = totalHours;
    }

    public Timesheet updatedDateUTC(LocalDateTime updatedDateUTC) {
        this.updatedDateUTC = updatedDateUTC;
        return this;
    }

    @ApiModelProperty(value="The UTC date time that the Timesheet was last updated")
    public LocalDateTime getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public void setUpdatedDateUTC(LocalDateTime updatedDateUTC) {
        this.updatedDateUTC = updatedDateUTC;
    }

    public Timesheet timesheetLines(List<TimesheetLine> timesheetLines) {
        this.timesheetLines = timesheetLines;
        return this;
    }

    public Timesheet addTimesheetLinesItem(TimesheetLine timesheetLinesItem) {
        if (this.timesheetLines == null) {
            this.timesheetLines = new ArrayList<TimesheetLine>();
        }
        this.timesheetLines.add(timesheetLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<TimesheetLine> getTimesheetLines() {
        return this.timesheetLines;
    }

    public void setTimesheetLines(List<TimesheetLine> timesheetLines) {
        this.timesheetLines = timesheetLines;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Timesheet timesheet = (Timesheet)o;
        return Objects.equals(this.timesheetID, timesheet.timesheetID) && Objects.equals(this.payrollCalendarID, timesheet.payrollCalendarID) && Objects.equals(this.employeeID, timesheet.employeeID) && Objects.equals(this.startDate, timesheet.startDate) && Objects.equals(this.endDate, timesheet.endDate) && Objects.equals((Object)this.status, (Object)timesheet.status) && Objects.equals(this.totalHours, timesheet.totalHours) && Objects.equals(this.updatedDateUTC, timesheet.updatedDateUTC) && Objects.equals(this.timesheetLines, timesheet.timesheetLines);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.timesheetID, this.payrollCalendarID, this.employeeID, this.startDate, this.endDate, this.status, this.totalHours, this.updatedDateUTC, this.timesheetLines});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Timesheet {\n");
        sb.append("    timesheetID: ").append(this.toIndentedString(this.timesheetID)).append("\n");
        sb.append("    payrollCalendarID: ").append(this.toIndentedString(this.payrollCalendarID)).append("\n");
        sb.append("    employeeID: ").append(this.toIndentedString(this.employeeID)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    totalHours: ").append(this.toIndentedString(this.totalHours)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("    timesheetLines: ").append(this.toIndentedString(this.timesheetLines)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        DRAFT("Draft"),
        APPROVED("Approved"),
        COMPLETED("Completed");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

