/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.project;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.OffsetDateTime;

public class TimeEntry {
    StringUtil util = new StringUtil();
    @JsonProperty(value="timeEntryId")
    private UUID timeEntryId;
    @JsonProperty(value="userId")
    private UUID userId;
    @JsonProperty(value="projectId")
    private UUID projectId;
    @JsonProperty(value="taskId")
    private UUID taskId;
    @JsonProperty(value="dateUtc")
    private OffsetDateTime dateUtc;
    @JsonProperty(value="dateEnteredUtc")
    private OffsetDateTime dateEnteredUtc;
    @JsonProperty(value="duration")
    private Integer duration;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="status")
    private StatusEnum status;

    public TimeEntry timeEntryId(UUID timeEntryId) {
        this.timeEntryId = timeEntryId;
        return this;
    }

    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", value="Identifier of the time entry.")
    public UUID getTimeEntryId() {
        return this.timeEntryId;
    }

    public void setTimeEntryId(UUID timeEntryId) {
        this.timeEntryId = timeEntryId;
    }

    public TimeEntry userId(UUID userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", value="The xero user identifier of the person who logged time.")
    public UUID getUserId() {
        return this.userId;
    }

    public void setUserId(UUID userId) {
        this.userId = userId;
    }

    public TimeEntry projectId(UUID projectId) {
        this.projectId = projectId;
        return this;
    }

    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", value="Identifier of the project, that the task (which the time entry is logged against) belongs to.")
    public UUID getProjectId() {
        return this.projectId;
    }

    public void setProjectId(UUID projectId) {
        this.projectId = projectId;
    }

    public TimeEntry taskId(UUID taskId) {
        this.taskId = taskId;
        return this;
    }

    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", value="Identifier of the task that time entry is logged against.")
    public UUID getTaskId() {
        return this.taskId;
    }

    public void setTaskId(UUID taskId) {
        this.taskId = taskId;
    }

    public TimeEntry dateUtc(OffsetDateTime dateUtc) {
        this.dateUtc = dateUtc;
        return this;
    }

    @ApiModelProperty(value="The date time that time entry is logged on. UTC Date Time in ISO-8601 format.")
    public OffsetDateTime getDateUtc() {
        return this.dateUtc;
    }

    public void setDateUtc(OffsetDateTime dateUtc) {
        this.dateUtc = dateUtc;
    }

    public TimeEntry dateEnteredUtc(OffsetDateTime dateEnteredUtc) {
        this.dateEnteredUtc = dateEnteredUtc;
        return this;
    }

    @ApiModelProperty(value="The date time that time entry is created. UTC Date Time in ISO-8601 format. By default it is set to server time.")
    public OffsetDateTime getDateEnteredUtc() {
        return this.dateEnteredUtc;
    }

    public void setDateEnteredUtc(OffsetDateTime dateEnteredUtc) {
        this.dateEnteredUtc = dateEnteredUtc;
    }

    public TimeEntry duration(Integer duration) {
        this.duration = duration;
        return this;
    }

    @ApiModelProperty(value="The duration of logged minutes.")
    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public TimeEntry description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="A description of the time entry.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TimeEntry status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="Status of the time entry. By default a time entry is created with status of `ACTIVE`. A `LOCKED` state indicates that the time entry is currently changing state (for example being invoiced). Updates are not allowed when in this state. It will have a status of INVOICED once it is invoiced.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeEntry timeEntry = (TimeEntry)o;
        return Objects.equals(this.timeEntryId, timeEntry.timeEntryId) && Objects.equals(this.userId, timeEntry.userId) && Objects.equals(this.projectId, timeEntry.projectId) && Objects.equals(this.taskId, timeEntry.taskId) && Objects.equals(this.dateUtc, timeEntry.dateUtc) && Objects.equals(this.dateEnteredUtc, timeEntry.dateEnteredUtc) && Objects.equals(this.duration, timeEntry.duration) && Objects.equals(this.description, timeEntry.description) && Objects.equals((Object)this.status, (Object)timeEntry.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.timeEntryId, this.userId, this.projectId, this.taskId, this.dateUtc, this.dateEnteredUtc, this.duration, this.description, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TimeEntry {\n");
        sb.append("    timeEntryId: ").append(this.toIndentedString(this.timeEntryId)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    projectId: ").append(this.toIndentedString(this.projectId)).append("\n");
        sb.append("    taskId: ").append(this.toIndentedString(this.taskId)).append("\n");
        sb.append("    dateUtc: ").append(this.toIndentedString(this.dateUtc)).append("\n");
        sb.append("    dateEnteredUtc: ").append(this.toIndentedString(this.dateEnteredUtc)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ACTIVE("ACTIVE"),
        LOCKED("LOCKED"),
        INVOICED("INVOICED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

