/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.aggre.repository;

import cn.hutool.core.thread.ThreadUtil;
import com.github.xiaoymin.knife4j.aggre.core.pojo.BasicAuth;
import com.github.xiaoymin.knife4j.aggre.core.pojo.CommonRoute;
import com.github.xiaoymin.knife4j.aggre.core.pojo.SwaggerRoute;
import com.github.xiaoymin.knife4j.aggre.polaris.PolarisInstance;
import com.github.xiaoymin.knife4j.aggre.polaris.PolarisRoute;
import com.github.xiaoymin.knife4j.aggre.polaris.PolarisService;
import com.github.xiaoymin.knife4j.aggre.repository.AbstractRepository;
import com.github.xiaoymin.knife4j.aggre.spring.support.PolarisSetting;
import com.github.xiaoymin.knife4j.core.util.CollectionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolarisRepository
extends AbstractRepository {
    private volatile boolean stop = false;
    private Thread thread;
    Logger logger = LoggerFactory.getLogger(PolarisRepository.class);
    private PolarisSetting polarisSetting;
    final ThreadPoolExecutor threadPoolExecutor = ThreadUtil.newExecutor((int)5, (int)5);
    private Map<String, PolarisInstance> polarisInstanceMap = new HashMap<String, PolarisInstance>();

    public PolarisRepository(PolarisSetting polarisSetting) {
        this.polarisSetting = polarisSetting;
        if (polarisSetting != null && CollectionUtils.isNotEmpty(polarisSetting.getRoutes())) {
            this.initPolaris(polarisSetting);
            this.applyRoutes(polarisSetting);
        }
    }

    private void initPolaris(PolarisSetting polarisSetting) {
        ArrayList optionalList = new ArrayList();
        polarisSetting.initJwtCookie();
        polarisSetting.getRoutes().forEach(route -> optionalList.add(this.threadPoolExecutor.submit(new PolarisService(polarisSetting, polarisSetting.getServiceUrl(), polarisSetting.getJwtCookie(), (PolarisRoute)route))));
        optionalList.forEach(optionalFuture -> {
            try {
                Optional instanceOptional = (Optional)optionalFuture.get();
                instanceOptional.ifPresent(polarisInstance -> this.polarisInstanceMap.put(polarisInstance.getService(), (PolarisInstance)polarisInstance));
            }
            catch (Exception e) {
                this.logger.error("Polaris get error:" + e.getMessage(), (Throwable)e);
            }
        });
    }

    private void applyRoutes(PolarisSetting polarisSetting) {
        if (CollectionUtils.isNotEmpty(this.polarisInstanceMap)) {
            polarisSetting.getRoutes().forEach(route -> {
                if (route.getRouteAuth() == null || !route.getRouteAuth().isEnable()) {
                    route.setRouteAuth(polarisSetting.getRouteAuth());
                }
                this.routeMap.put(route.pkId(), new SwaggerRoute((PolarisRoute)route, this.polarisInstanceMap.get(route.getService())));
            });
            polarisSetting.getRoutes().forEach(route -> this.routeMap.put(route.pkId(), new SwaggerRoute((PolarisRoute)route, this.polarisInstanceMap.get(route.getService()))));
        }
    }

    @Override
    public BasicAuth getAuth(String header) {
        BasicAuth basicAuth = null;
        if (this.polarisSetting != null && CollectionUtils.isNotEmpty(this.polarisSetting.getRoutes())) {
            if (this.polarisSetting.getRouteAuth() != null && this.polarisSetting.getRouteAuth().isEnable()) {
                basicAuth = this.polarisSetting.getRouteAuth();
                BasicAuth routeBasicAuth = this.getAuthByRoute(header, this.polarisSetting.getRoutes());
                if (routeBasicAuth != null) {
                    basicAuth = routeBasicAuth;
                }
            } else {
                basicAuth = this.getAuthByRoute(header, this.polarisSetting.getRoutes());
            }
        }
        return basicAuth;
    }

    @Override
    public void start() {
        this.logger.info("start Polaris hearbeat Holder thread.");
        this.thread = new Thread(() -> {
            while (!this.stop) {
                try {
                    this.logger.debug("Polaris hearbeat start working...");
                    this.polarisSetting.getRoutes().forEach(route -> {
                        try {
                            PolarisService polarisService = new PolarisService(this.polarisSetting, this.polarisSetting.getServiceUrl(), this.polarisSetting.getJwtCookie(), (PolarisRoute)route);
                            Object instanceOptional = polarisService.call();
                            if (((Optional)instanceOptional).isPresent()) {
                                this.routeMap.put(route.pkId(), new SwaggerRoute((PolarisRoute)route, (PolarisInstance)((Optional)instanceOptional).get()));
                            } else {
                                this.routeMap.remove(route.pkId());
                            }
                        }
                        catch (Exception e) {
                            this.routeMap.remove(route.pkId());
                            this.logger.debug(e.getMessage(), (Throwable)e);
                        }
                    });
                    List<String> settingRouteIds = this.polarisSetting.getRoutes().stream().map(CommonRoute::pkId).collect(Collectors.toList());
                    this.heartRepeatClear(settingRouteIds);
                }
                catch (Exception e) {
                    this.logger.debug(e.getMessage(), (Throwable)e);
                }
                ThreadUtil.sleep((Number)HEART_BEAT_DURATION);
            }
        });
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @Override
    public void close() {
        this.logger.info("stop Polaris heartbeat Holder thread.");
        this.stop = true;
        if (this.thread != null) {
            ThreadUtil.interrupt((Thread)this.thread, (boolean)true);
        }
    }
}

