/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.gateway.discover.router;

import com.github.xiaoymin.knife4j.spring.gateway.Knife4jGatewayProperties;
import com.github.xiaoymin.knife4j.spring.gateway.discover.ServiceRouterConvert;
import com.github.xiaoymin.knife4j.spring.gateway.discover.ServiceRouterHolder;
import com.github.xiaoymin.knife4j.spring.gateway.enums.OpenApiVersion;
import com.github.xiaoymin.knife4j.spring.gateway.spec.v2.OpenAPI2Resource;
import com.github.xiaoymin.knife4j.spring.gateway.utils.PathUtils;
import com.github.xiaoymin.knife4j.spring.gateway.utils.ServiceUtils;
import com.github.xiaoymin.knife4j.spring.gateway.utils.StrUtil;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.handler.predicate.PredicateDefinition;
import org.springframework.util.CollectionUtils;

public abstract class AbstactServiceRouterConvert
implements ServiceRouterConvert {
    private static final Logger log = LoggerFactory.getLogger(AbstactServiceRouterConvert.class);

    abstract String convertPathPrefix(Map<String, String> var1);

    protected void parseRouteDefinition(ServiceRouterHolder routerHolder, Knife4jGatewayProperties.Discover discover, List<PredicateDefinition> predicateDefinitions, String id, String serviceName) {
        predicateDefinitions.stream().filter(predicateDefinition -> "Path".equalsIgnoreCase(predicateDefinition.getName())).findFirst().ifPresent(predicateDefinition -> {
            log.debug("serviceId:{},serviceName:{}", (Object)id, (Object)serviceName);
            Map<String, Knife4jGatewayProperties.ServiceConfigInfo> configInfoMap = discover.getServiceConfig();
            String pathPrefix = this.convertPathPrefix(predicateDefinition.getArgs());
            log.debug("pathPrefix:{}", (Object)pathPrefix);
            String contextPath = "";
            String groupName = id;
            int order = 0;
            String targetUrl = ServiceUtils.getOpenAPIURL(discover, pathPrefix, null);
            Knife4jGatewayProperties.ServiceConfigInfo configInfo = configInfoMap.get(serviceName);
            if (configInfo != null) {
                order = configInfo.getOrder();
                if (discover.getVersion() == OpenApiVersion.OpenAPI3) {
                    contextPath = PathUtils.append(pathPrefix, configInfo.getContextPath());
                } else if (discover.getVersion() == OpenApiVersion.Swagger2 && StrUtil.isNotBlank(configInfo.getContextPath()) && !"/".equals(configInfo.getContextPath())) {
                    contextPath = configInfo.getContextPath();
                }
                targetUrl = PathUtils.append(contextPath, ServiceUtils.getOpenAPIURL(discover, "/", null));
                List<String> groupNames = configInfo.getGroupNames();
                if (!CollectionUtils.isEmpty(groupNames)) {
                    int sort = order;
                    String ctx = contextPath;
                    String url = targetUrl;
                    groupNames.forEach(_groupName -> routerHolder.add(new OpenAPI2Resource(PathUtils.append(url, _groupName), sort, true, (String)_groupName, ctx, serviceName)));
                    return;
                }
                groupName = configInfo.getGroupName();
            } else if (discover.getVersion() == OpenApiVersion.OpenAPI3) {
                contextPath = PathUtils.processContextPath(pathPrefix);
            }
            routerHolder.add(new OpenAPI2Resource(targetUrl, order, true, groupName, contextPath, serviceName));
        });
    }
}

