/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.common.insight;

import com.github.xiaoymin.knife4j.core.util.StrUtil;
import com.github.xiaoymin.knife4j.insight.config.Knife4jInsightCommonInfo;
import com.github.xiaoymin.knife4j.insight.upload.Knife4jInsightUploadRunner;
import com.github.xiaoymin.knife4j.spring.configuration.insight.Knife4jInsightProperties;
import com.github.xiaoymin.knife4j.spring.util.EnvironmentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public class Knife4jInsightDiscoveryBootstrapper
implements CommandLineRunner,
EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(Knife4jInsightDiscoveryBootstrapper.class);
    final Knife4jInsightProperties insightProperties;
    private Environment environment;

    public Knife4jInsightDiscoveryBootstrapper(Knife4jInsightProperties insightProperties) {
        this.insightProperties = insightProperties;
    }

    public void run(String ... args) throws Exception {
        String serviceName = this.insightProperties.getServiceName();
        if (StrUtil.isBlank((CharSequence)serviceName)) {
            serviceName = EnvironmentUtils.resolveString(this.environment, "spring.application.name", "");
        }
        if (StrUtil.isBlank((CharSequence)serviceName)) {
            log.warn("service-name must set one,upload refused.");
            return;
        }
        Knife4jInsightCommonInfo commonInfo = new Knife4jInsightCommonInfo();
        commonInfo.setContextPath(EnvironmentUtils.resolveContextPath(this.environment));
        commonInfo.setSpec("OpenAPI3");
        commonInfo.setServiceName(serviceName);
        commonInfo.setSecret(this.insightProperties.getSecret());
        commonInfo.setNamespace(this.insightProperties.getNamespace());
        commonInfo.setPort(EnvironmentUtils.resolveString(this.environment, "server.port", "8080"));
        commonInfo.setServer(this.insightProperties.getServer());
        Knife4jInsightUploadRunner uploadRunner = new Knife4jInsightUploadRunner(commonInfo);
        new Thread((Runnable)uploadRunner).start();
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

