/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.swaggerbootstrapui.model;

import com.google.common.collect.Lists;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiOperationSort;
import io.swagger.models.SwaggerBootstrapUiPath;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class SwaggerBootstrapUiPathInstance {
    private String parent;
    private Method target;

    public SwaggerBootstrapUiPathInstance(String parent, Method target) {
        this.parent = parent;
        this.target = target;
    }

    public SwaggerBootstrapUiPath createMethod(RequestMethod method, String path) {
        SwaggerBootstrapUiPath defaultPath = this.createDefaultPath();
        defaultPath.setMethod(method.name().toUpperCase());
        defaultPath.setPath(this.buildPath(path));
        return defaultPath;
    }

    public List<SwaggerBootstrapUiPath> match() {
        ArrayList pathList = Lists.newArrayList();
        RequestMapping requestMapping = this.target.getAnnotation(RequestMapping.class);
        if (requestMapping != null) {
            RequestMethod[] requestMethods = requestMapping.method();
            String path = requestMapping.value()[0];
            for (RequestMethod requestMethod : requestMethods) {
                pathList.add(this.createMethod(requestMethod, path));
            }
        } else if (this.target.getAnnotation(GetMapping.class) != null) {
            GetMapping getMapping = this.target.getAnnotation(GetMapping.class);
            SwaggerBootstrapUiPath defaultPath = this.createDefaultPath();
            defaultPath.setMethod(RequestMethod.GET.name().toUpperCase());
            defaultPath.setPath(this.buildPath(getMapping.value()[0]));
            pathList.add(defaultPath);
        } else if (this.target.getAnnotation(PostMapping.class) != null) {
            PostMapping getMapping = this.target.getAnnotation(PostMapping.class);
            SwaggerBootstrapUiPath defaultPath = this.createDefaultPath();
            defaultPath.setMethod(RequestMethod.POST.name().toUpperCase());
            defaultPath.setPath(this.buildPath(getMapping.value()[0]));
            pathList.add(defaultPath);
        } else if (this.target.getAnnotation(DeleteMapping.class) != null) {
            DeleteMapping getMapping = this.target.getAnnotation(DeleteMapping.class);
            SwaggerBootstrapUiPath defaultPath = this.createDefaultPath();
            defaultPath.setMethod(RequestMethod.DELETE.name().toUpperCase());
            defaultPath.setPath(this.buildPath(getMapping.value()[0]));
            pathList.add(defaultPath);
        } else if (this.target.getAnnotation(PutMapping.class) != null) {
            PutMapping getMapping = this.target.getAnnotation(PutMapping.class);
            SwaggerBootstrapUiPath defaultPath = this.createDefaultPath();
            defaultPath.setMethod(RequestMethod.POST.name().toUpperCase());
            defaultPath.setPath(this.buildPath(getMapping.value()[0]));
            pathList.add(defaultPath);
        } else if (this.target.getAnnotation(PatchMapping.class) != null) {
            PatchMapping getMapping = this.target.getAnnotation(PatchMapping.class);
            SwaggerBootstrapUiPath defaultPath = this.createDefaultPath();
            defaultPath.setMethod(RequestMethod.PATCH.name().toUpperCase());
            defaultPath.setPath(this.buildPath(getMapping.value()[0]));
            pathList.add(defaultPath);
        }
        return pathList;
    }

    private String buildPath(String path) {
        StringBuffer pathStr = new StringBuffer();
        if (!"".equals(this.parent)) {
            if (!this.parent.startsWith("/")) {
                pathStr.append("/");
            }
            if (this.parent.endsWith("/")) {
                pathStr.append(this.parent.substring(0, this.parent.lastIndexOf("/")));
            } else {
                pathStr.append(this.parent);
            }
        }
        if (!path.startsWith("/")) {
            pathStr.append("/");
        }
        pathStr.append(path);
        return pathStr.toString();
    }

    private SwaggerBootstrapUiPath createDefaultPath() {
        SwaggerBootstrapUiPath defaultPath = new SwaggerBootstrapUiPath();
        int pathOrder = Integer.MAX_VALUE;
        ApiOperation apiOperation = this.target.getAnnotation(ApiOperation.class);
        if (apiOperation != null) {
            if (apiOperation.position() != 0) {
                pathOrder = apiOperation.position();
            } else {
                ApiOperationSort apiOperationSort = this.target.getAnnotation(ApiOperationSort.class);
                if (apiOperationSort != null) {
                    pathOrder = apiOperationSort.value();
                }
            }
        } else {
            ApiOperationSort apiOperationSort = this.target.getAnnotation(ApiOperationSort.class);
            if (apiOperationSort != null) {
                pathOrder = apiOperationSort.value();
            }
        }
        defaultPath.setOrder(pathOrder);
        return defaultPath;
    }
}

