/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.swaggerbootstrapui.web;

import com.github.xiaoymin.swaggerbootstrapui.model.SwaggerBootstrapUiPathInstance;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiSort;
import io.swagger.models.Swagger;
import io.swagger.models.SwaggerBootstrapUi;
import io.swagger.models.SwaggerBootstrapUiPath;
import io.swagger.models.SwaggerBootstrapUiTag;
import io.swagger.models.SwaggerExt;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.util.UriComponents;
import springfox.documentation.annotations.ApiIgnore;
import springfox.documentation.service.Documentation;
import springfox.documentation.service.Tag;
import springfox.documentation.spring.web.DocumentationCache;
import springfox.documentation.spring.web.json.Json;
import springfox.documentation.spring.web.json.JsonSerializer;
import springfox.documentation.swagger.common.HostNameProvider;
import springfox.documentation.swagger2.mappers.ServiceModelToSwagger2Mapper;

@Controller
@ApiIgnore
public class SwaggerBootstrapUiController {
    public static final String DEFAULT_SORT_URL = "/v2/api-docs-ext";
    private static final String HAL_MEDIA_TYPE = "application/hal+json";
    private static final Logger LOGGER = LoggerFactory.getLogger(SwaggerBootstrapUiController.class);
    private final ServiceModelToSwagger2Mapper mapper;
    private final DocumentationCache documentationCache;
    private final JsonSerializer jsonSerializer;
    private final String hostNameOverride;

    @Autowired
    public SwaggerBootstrapUiController(Environment environment, ServiceModelToSwagger2Mapper mapper, DocumentationCache documentationCache, JsonSerializer jsonSerializer) {
        this.mapper = mapper;
        this.documentationCache = documentationCache;
        this.jsonSerializer = jsonSerializer;
        this.hostNameOverride = environment.getProperty("springfox.documentation.swagger.v2.host", "DEFAULT");
    }

    @RequestMapping(value={"/v2/api-docs-ext"}, method={RequestMethod.GET}, produces={"application/json", "application/hal+json"})
    @ResponseBody
    public ResponseEntity<Json> apiSorts(@RequestParam(value="group", required=false) String swaggerGroup, HttpServletRequest request) {
        Swagger swagger;
        String groupName = (String)Optional.fromNullable((Object)swaggerGroup).or((Object)"default");
        Documentation documentation = this.documentationCache.documentationByGroup(groupName);
        if (documentation == null) {
            LOGGER.warn("Unable to find specification for grouRp {}", (Object)groupName);
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        UriComponents uriComponents = HostNameProvider.componentsFrom((HttpServletRequest)request, (String)(swagger = this.mapper.mapDocumentation(documentation)).getBasePath());
        swagger.basePath(Strings.isNullOrEmpty((String)uriComponents.getPath()) ? "/" : uriComponents.getPath());
        if (Strings.isNullOrEmpty((String)swagger.getHost())) {
            swagger.host(this.hostName(uriComponents));
        }
        SwaggerExt swaggerExt = new SwaggerExt(swagger);
        swaggerExt.setSwaggerBootstrapUi(this.initSwaggerBootstrapUi(request, documentation, swaggerExt));
        return new ResponseEntity((Object)this.jsonSerializer.toJson((Object)swaggerExt), HttpStatus.OK);
    }

    private SwaggerBootstrapUi initSwaggerBootstrapUi(HttpServletRequest request, Documentation documentation, SwaggerExt swaggerExt) {
        SwaggerBootstrapUi swaggerBootstrapUi = new SwaggerBootstrapUi();
        WebApplicationContext wc = WebApplicationContextUtils.getWebApplicationContext((ServletContext)request.getServletContext());
        Iterator tags = documentation.getTags().iterator();
        ArrayList targetTagLists = Lists.newArrayList();
        Map beansWithAnnotation = wc.getBeansWithAnnotation(Controller.class);
        ArrayList targetPathLists = Lists.newArrayList();
        while (tags.hasNext()) {
            Tag sourceTag = (Tag)tags.next();
            String tagName = sourceTag.getName();
            boolean exists = false;
            Class<?> aClass = null;
            Api api = null;
            for (Map.Entry entry : beansWithAnnotation.entrySet()) {
                aClass = entry.getValue().getClass();
                api = aClass.getAnnotation(Api.class);
                if (api == null || !Lists.newArrayList((Object[])api.tags()).contains(tagName)) continue;
                exists = true;
                break;
            }
            int order = Integer.MAX_VALUE;
            SwaggerBootstrapUiTag tag = new SwaggerBootstrapUiTag(order);
            tag.name(sourceTag.getName()).description(sourceTag.getDescription());
            if (exists) {
                Method[] methods;
                String tmp;
                RequestMapping parent;
                int post = api.position();
                if (post == 0) {
                    ApiSort annotation = ClassUtils.getUserClass(aClass).getAnnotation(ApiSort.class);
                    if (annotation != null) {
                        order = annotation.value();
                    }
                } else {
                    order = post;
                }
                tag.setOrder(order);
                String parentPath = "";
                Class userClass = ClassUtils.getUserClass(aClass);
                if (!StringUtils.isEmpty((Object)swaggerExt.getBasePath()) && !"/".equals(swaggerExt.getBasePath())) {
                    parentPath = parentPath + swaggerExt.getBasePath();
                }
                if ((parent = userClass.getAnnotation(RequestMapping.class)) != null && !StringUtils.isEmpty((Object)(tmp = parent.value()[0]))) {
                    if (!tmp.startsWith("/")) {
                        parentPath = parentPath + "/";
                    }
                    parentPath = parentPath + tmp;
                }
                for (Method method : methods = userClass.getDeclaredMethods()) {
                    List<SwaggerBootstrapUiPath> paths = new SwaggerBootstrapUiPathInstance(parentPath, ClassUtils.getMostSpecificMethod((Method)method, (Class)userClass)).match();
                    if (paths == null || paths.size() <= 0) continue;
                    targetPathLists.addAll(paths);
                }
            }
            targetTagLists.add(tag);
        }
        Collections.sort(targetTagLists, new Comparator<SwaggerBootstrapUiTag>(){

            @Override
            public int compare(SwaggerBootstrapUiTag o1, SwaggerBootstrapUiTag o2) {
                return o1.getOrder().compareTo(o2.getOrder());
            }
        });
        Collections.sort(targetPathLists, new Comparator<SwaggerBootstrapUiPath>(){

            @Override
            public int compare(SwaggerBootstrapUiPath o1, SwaggerBootstrapUiPath o2) {
                return o1.getOrder().compareTo(o2.getOrder());
            }
        });
        swaggerBootstrapUi.setTagSortLists(targetTagLists);
        swaggerBootstrapUi.setPathSortLists(targetPathLists);
        return swaggerBootstrapUi;
    }

    private String hostName(UriComponents uriComponents) {
        if ("DEFAULT".equals(this.hostNameOverride)) {
            String host = uriComponents.getHost();
            int port = uriComponents.getPort();
            if (port > -1) {
                return String.format("%s:%d", host, port);
            }
            return host;
        }
        return this.hostNameOverride;
    }
}

