/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.xinge;

import com.tencent.xinge.api.RESTAPIV3;
import com.tencent.xinge.device.account.AccountBindRequest;
import com.tencent.xinge.device.account.AccountQueryRequest;
import com.tencent.xinge.device.tag.DeviceTagRequest;
import com.tencent.xinge.push.app.PushAppRequest;
import com.tencent.xinge.push.app.UploadPushFileResponse;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.json.JSONObject;

public class XingeApp {
    public static MediaType JSON_MEDIA_TYPE = MediaType.parse((String)"application/json");
    private String authString = null;
    private String authStringEnc = null;
    private String accessId = null;
    private String secretKey = null;
    private boolean isSignAuth = false;
    private RESTAPIV3 restapiV3 = new RESTAPIV3();
    private OkHttpClient client;

    private XingeApp(String accessid, String secretKey) {
        this.accessId = accessid;
        this.secretKey = secretKey;
        byte[] authEncBytes = Base64.encodeBase64((byte[])this.authString.getBytes());
        this.authStringEnc = new String(authEncBytes);
        this.client = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).build();
    }

    private XingeApp(Builder builder) {
        if (builder.domainUrl != null) {
            this.restapiV3.setDomainUrl(builder.domainUrl);
        }
        this.accessId = builder.appId;
        this.secretKey = builder.secretKey;
        this.isSignAuth = builder.useSignAuth;
        this.client = new OkHttpClient.Builder().proxy(builder.proxy).connectTimeout((long)builder.connectTimeOut, TimeUnit.SECONDS).readTimeout((long)builder.readTimeOut, TimeUnit.SECONDS).build();
    }

    private Map<String, String> makeBasicAuthHeader() {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (this.authStringEnc == null) {
            this.authString = this.accessId + ":" + this.secretKey;
            byte[] authEncBytes = Base64.encodeBase64((byte[])this.authString.getBytes());
            this.authStringEnc = new String(authEncBytes);
        }
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Basic " + this.authStringEnc);
        return headers;
    }

    private Map<String, String> makeSignAuthHeader(String requestBody) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        long timeStamp = System.currentTimeMillis() / 1000L;
        String timeStampStr = String.valueOf(timeStamp);
        String sign = this.GenSign(timeStampStr, requestBody);
        headers.put("TimeStamp", timeStampStr);
        headers.put("AccessId", this.accessId);
        headers.put("Sign", sign);
        headers.put("Content-Type", "application/json");
        return headers;
    }

    private String GenSign(String timeStampStr, String requestBody) throws Exception {
        String sign = "";
        String signResouce = timeStampStr + this.accessId + requestBody;
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(new SecretKeySpec(this.secretKey.getBytes("UTF-8"), "HmacSHA256"));
        byte[] signatureBytes = mac.doFinal(signResouce.getBytes("UTF-8"));
        String hexStr = Hex.encodeHexString((byte[])signatureBytes);
        sign = Base64.encodeBase64String((byte[])hexStr.getBytes());
        return sign;
    }

    public void setDomainUrl(String url) {
        this.restapiV3.setDomainUrl(url);
    }

    public JSONObject pushApp(String jsonRequest) {
        JSONObject ret = this.callRestful(this.restapiV3.restApiPushUrl, jsonRequest);
        return ret;
    }

    public JSONObject pushApp(PushAppRequest pushAppRequest) {
        String jsonRequest = pushAppRequest.toString();
        return this.pushApp(jsonRequest);
    }

    public JSONObject tagBind(String jsonRequest) {
        return this.callRestful(this.restapiV3.restApiTagBindUrl, jsonRequest);
    }

    public JSONObject tagBind(DeviceTagRequest tagBindRequest) {
        String jsonRequest = tagBindRequest.toString();
        return this.tagBind(jsonRequest);
    }

    public JSONObject accountBind(String jsonRequest) {
        return this.callRestful(this.restapiV3.restApiAccountBindUrl, jsonRequest);
    }

    public JSONObject accountBind(AccountBindRequest accountBindRequest) {
        String jsonRequest = accountBindRequest.toString();
        System.out.println(jsonRequest);
        return this.accountBind(jsonRequest);
    }

    public JSONObject accountQuery(String jsonRequest) {
        return this.callRestful(this.restapiV3.restApiAccountQueryUrl, jsonRequest);
    }

    public JSONObject accountQuery(AccountQueryRequest accountQueryRequest) {
        String jsonRequest = accountQueryRequest.toString();
        return this.accountQuery(jsonRequest);
    }

    public UploadPushFileResponse Upload(String filePath) {
        UploadPushFileResponse response = new UploadPushFileResponse();
        JSONObject jsonObject = this.SendFile(this.restapiV3.restApiUploadPackageFileUrl, filePath);
        response.FromJsonObject(jsonObject);
        return response;
    }

    private JSONObject callRestful(String apiAddress, String jsonRequestString) {
        RequestBody requestBody = RequestBody.create((MediaType)JSON_MEDIA_TYPE, (String)jsonRequestString);
        Map<String, String> headers = this.makeBasicAuthHeader();
        if (this.isSignAuth) {
            try {
                headers = this.makeSignAuthHeader(jsonRequestString);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Request.Builder builder = new Request.Builder().url(apiAddress).post(requestBody);
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            builder.addHeader(entry.getKey(), entry.getValue());
        }
        Request request = builder.build();
        return this.SendHttpAndHandlerResponse(request);
    }

    public JSONObject CallRestful(String apiAddress, String jsonRequestString) {
        return this.callRestful(apiAddress, jsonRequestString);
    }

    private JSONObject SendFile(String apiAddress, String filePath) {
        File file = new File(filePath);
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", file.getName(), RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)file)).build();
        Request.Builder builder = new Request.Builder().url(apiAddress).post((RequestBody)requestBody);
        Map<String, String> headers = this.makeBasicAuthHeader();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            builder.addHeader(entry.getKey(), entry.getValue());
        }
        Request request = builder.build();
        return this.SendHttpAndHandlerResponse(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject SendHttpAndHandlerResponse(Request request) {
        JSONObject jsonRet = null;
        Response response = null;
        try {
            response = this.client.newCall(request).execute();
            if (response.code() == 200) {
                String retMsg = response.body().string();
                jsonRet = new JSONObject(retMsg);
            } else {
                jsonRet = new JSONObject();
                jsonRet.put("ret_code", 10101);
                jsonRet.put("err_msg", (Object)("CallApiError,HttpStatus Code:" + response.code()));
            }
        }
        catch (IOException e) {
            jsonRet = new JSONObject();
            jsonRet.put("ret_code", 10100);
            jsonRet.put("err_msg", (Object)XingeApp.stringifyError(e));
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        return jsonRet;
    }

    public static String stringifyError(Throwable error) {
        StringWriter result = new StringWriter();
        PrintWriter printer = new PrintWriter(result);
        error.printStackTrace(printer);
        printer.close();
        return result.toString();
    }

    public static class Builder {
        private String appId;
        private String secretKey;
        private Proxy proxy = Proxy.NO_PROXY;
        private int connectTimeOut = 10;
        private int readTimeOut = 10;
        private String domainUrl;
        private boolean useSignAuth = false;

        public Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public Builder domainUrl(String domainUrl) {
            this.domainUrl = domainUrl;
            return this;
        }

        public Builder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder connectTimeOut(int connectTimeOut) {
            this.connectTimeOut = connectTimeOut;
            return this;
        }

        public Builder readTimeOut(int readTimeOut) {
            this.readTimeOut = readTimeOut;
            return this;
        }

        public Builder useSignAuth(boolean useSignAuth) {
            this.useSignAuth = useSignAuth;
            return this;
        }

        public XingeApp build() {
            if (this.appId == null || this.secretKey == null) {
                throw new IllegalArgumentException("Please set appId and secret key.");
            }
            return new XingeApp(this);
        }
    }
}

