/*
 * Decompiled with CFR 0.152.
 */
package com.xkzhangsan.time;

import com.xkzhangsan.time.calculator.DateTimeCalculatorUtil;
import com.xkzhangsan.time.converter.DateTimeConverterUtil;
import com.xkzhangsan.time.holiday.Holiday;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.util.Date;

public final class LunarDate
implements Temporal,
Serializable {
    private static final long serialVersionUID = 7999322619343295974L;
    private static final long[] lunarInfo = new long[]{19416L, 19168L, 42352L, 21717L, 53856L, 55632L, 91476L, 22176L, 39632L, 21970L, 19168L, 42422L, 42192L, 53840L, 119381L, 46400L, 54944L, 44450L, 38320L, 84343L, 18800L, 42160L, 46261L, 27216L, 27968L, 109396L, 11104L, 38256L, 21234L, 18800L, 25958L, 54432L, 59984L, 92821L, 23248L, 11104L, 100067L, 37600L, 116951L, 51536L, 54432L, 120998L, 46416L, 22176L, 107956L, 9680L, 37584L, 53938L, 43344L, 46423L, 27808L, 46416L, 86869L, 19872L, 42416L, 83315L, 21168L, 43432L, 59728L, 27296L, 44710L, 43856L, 19296L, 43748L, 42352L, 21088L, 62051L, 55632L, 23383L, 22176L, 38608L, 19925L, 19152L, 42192L, 54484L, 53840L, 54616L, 46400L, 46752L, 103846L, 38320L, 18864L, 43380L, 42160L, 45690L, 27216L, 27968L, 44870L, 43872L, 38256L, 19189L, 18800L, 25776L, 29859L, 59984L, 27480L, 23232L, 43872L, 38613L, 37600L, 51552L, 55636L, 54432L, 55888L, 30034L, 22176L, 43959L, 9680L, 37584L, 51893L, 43344L, 46240L, 47780L, 44368L, 21977L, 19360L, 42416L, 86390L, 21168L, 43312L, 31060L, 27296L, 44368L, 23378L, 19296L, 42726L, 42208L, 53856L, 60005L, 54576L, 23200L, 30371L, 38608L, 19195L, 19152L, 42192L, 118966L, 53840L, 54560L, 56645L, 46496L, 22224L, 21938L, 18864L, 42359L, 42160L, 43600L, 111189L, 27936L, 44448L, 84835L, 37744L, 18936L, 18800L, 25776L, 92326L, 59984L, 27424L, 108228L, 43744L, 37600L, 53987L, 51552L, 54615L, 54432L, 55888L, 23893L, 22176L, 42704L, 21972L, 21200L, 43448L, 43344L, 46240L, 46758L, 44368L, 21920L, 43940L, 42416L, 21168L, 45683L, 26928L, 29495L, 27296L, 44368L, 84821L, 19296L, 42352L, 21732L, 53600L, 59752L, 54560L, 55968L, 92838L, 22224L, 19168L, 43476L, 41680L, 53584L, 62034L, 54560L};
    public static final String[] lunarMonth = new String[]{"", "\u6b63", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u51ac", "\u814a"};
    private static final String[] tianGan = new String[]{"\u7532", "\u4e59", "\u4e19", "\u4e01", "\u620a", "\u5df1", "\u5e9a", "\u8f9b", "\u58ec", "\u7678"};
    private static final String[] diZhi = new String[]{"\u5b50", "\u4e11", "\u5bc5", "\u536f", "\u8fb0", "\u5df3", "\u5348", "\u672a", "\u7533", "\u9149", "\u620c", "\u4ea5"};
    private static final String[] animals = new String[]{"\u9f20", "\u725b", "\u864e", "\u5154", "\u9f99", "\u86c7", "\u9a6c", "\u7f8a", "\u7334", "\u9e21", "\u72d7", "\u732a"};
    public static final String[] numStr = new String[]{"\u3007", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
    public static final String[] solarTerms = new String[]{"\u5c0f\u5bd2", "\u5927\u5bd2", "\u7acb\u6625", "\u96e8\u6c34", "\u60ca\u86f0", "\u6625\u5206", "\u6e05\u660e", "\u8c37\u96e8", "\u7acb\u590f", "\u5c0f\u6ee1", "\u8292\u79cd", "\u590f\u81f3", "\u5c0f\u6691", "\u5927\u6691", "\u7acb\u79cb", "\u5904\u6691", "\u767d\u9732", "\u79cb\u5206", "\u5bd2\u9732", "\u971c\u964d", "\u7acb\u51ac", "\u5c0f\u96ea", "\u5927\u96ea", "\u51ac\u81f3"};
    private static final long[] solarTermInfo = new long[]{0L, 21208L, 42467L, 63836L, 85337L, 107014L, 128867L, 150921L, 173149L, 195551L, 218072L, 240693L, 263343L, 285989L, 308563L, 331033L, 353350L, 375494L, 397447L, 419210L, 440795L, 462224L, 483532L, 504758L};
    private final LocalDate localDate;
    private String lDateCn;
    private String lDate;
    private String gDate;
    private String suiCi;
    private String lAnimal;
    private int lYear;
    private int lMonth;
    private int lDay;
    private String lYearCn;
    private String lMonthCn;
    private String lDayCn;
    private String weekCn;
    private String solarTerm;
    private String leapMonthCn;

    private LunarDate(LocalDate localDate) {
        this.localDate = localDate;
        try {
            this.initialize();
        }
        catch (Exception e) {
            System.err.println("new LunarDate has error: " + e.getMessage());
        }
    }

    public void initialize() {
        int year = this.localDate.getYear();
        int month = this.localDate.getMonthValue();
        int day = this.localDate.getDayOfMonth();
        long[] l = LunarDate.calElement(year, month, day);
        this.lYear = (int)l[0];
        this.lMonth = (int)l[1];
        this.lDay = (int)l[2];
        this.suiCi = LunarDate.cyclical(this.lYear);
        this.lAnimal = LunarDate.animalsYear(this.lYear);
        this.lYearCn = LunarDate.getChinaYear(this.lYear);
        this.lMonthCn = lunarMonth[this.lMonth];
        this.lDayCn = LunarDate.getChinaDay(this.lDay);
        this.weekCn = LunarDate.getWeekCn(this.localDate.getDayOfWeek().getValue());
        this.solarTerm = l[7] != -1L ? solarTerms[(int)l[7]] : "";
        this.leapMonthCn = l[6] == 1L ? "\u95f0" : "";
        this.lDateCn = this.lYearCn + "\u5e74" + this.leapMonthCn + this.lMonthCn + "\u6708" + this.lDayCn;
        this.lDate = String.format("%04d", this.lYear) + "-" + String.format("%02d", this.lMonth) + "-" + String.format("%02d", this.lDay);
        this.gDate = this.localDate.toString();
    }

    public static LunarDate from(LocalDateTime localDateTime) {
        return new LunarDate(DateTimeConverterUtil.toLocalDate(localDateTime));
    }

    public static LunarDate from(LocalDate localDate) {
        return new LunarDate(localDate);
    }

    public static LunarDate from(Instant instant) {
        return new LunarDate(DateTimeConverterUtil.toLocalDate(instant));
    }

    public static LunarDate from(Date date) {
        return new LunarDate(DateTimeConverterUtil.toLocalDate(date));
    }

    public static LunarDate from(Temporal temporal) {
        return new LunarDate(DateTimeConverterUtil.toLocalDate(temporal));
    }

    private static final int lunarYearDays(int year) {
        int sum = 348;
        for (int i = 32768; i > 8; i >>= 1) {
            if ((lunarInfo[year - 1900] & (long)i) == 0L) continue;
            ++sum;
        }
        return sum + LunarDate.leapMonthDays(year);
    }

    private static final int leapMonthDays(int year) {
        if (LunarDate.leapMonth(year) != 0) {
            if ((lunarInfo[year - 1900] & 0x10000L) != 0L) {
                return 30;
            }
            return 29;
        }
        return 0;
    }

    private static final int leapMonth(int year) {
        return (int)(lunarInfo[year - 1900] & 0xFL);
    }

    private static final int monthDays(int year, int month) {
        if ((lunarInfo[year - 1900] & (long)(65536 >> month)) == 0L) {
            return 29;
        }
        return 30;
    }

    public static final String animalsYear(int year) {
        return animals[(year - 4) % 12];
    }

    private static final String cyclicalm(int num) {
        return tianGan[num % 10] + diZhi[num % 12];
    }

    public static final String cyclical(int year) {
        int num = year - 1900 + 36;
        return LunarDate.cyclicalm(num);
    }

    public static final int solarTerm(int year, int n) {
        LocalDateTime startLocalDateTime = LocalDateTime.of(1900, 1, 6, 2, 5);
        long millis = (long)(3.15569259747E10 * (double)(year - 1900) + (double)(solarTermInfo[n] * 60000L));
        LocalDateTime tempLocalDateTime = DateTimeCalculatorUtil.plusMillis(startLocalDateTime, millis);
        return tempLocalDateTime.getDayOfMonth();
    }

    public static final long[] calElement(int year, int month, int day) {
        long[] nongDate = new long[8];
        int i = 0;
        int temp = 0;
        int leap = 0;
        LocalDateTime baseDate = LocalDate.of(1900, 1, 31).atStartOfDay();
        LocalDateTime objDate = LocalDate.of(year, month, day).atStartOfDay();
        long offset = DateTimeCalculatorUtil.betweenTotalDays(baseDate, objDate);
        nongDate[5] = offset + 40L;
        nongDate[4] = 14L;
        for (i = 1900; i <= 2100 && offset > 0L; offset -= (long)temp, ++i) {
            temp = LunarDate.lunarYearDays(i);
            nongDate[4] = nongDate[4] + 12L;
        }
        if (offset < 0L) {
            offset += (long)temp;
            --i;
            nongDate[4] = nongDate[4] - 12L;
        }
        nongDate[0] = i;
        nongDate[3] = i - 1864;
        leap = LunarDate.leapMonth(i);
        nongDate[6] = 0L;
        for (i = 1; i < 13 && offset > 0L; ++i) {
            if (leap > 0 && i == leap + 1 && nongDate[6] == 0L) {
                --i;
                nongDate[6] = 1L;
                temp = LunarDate.leapMonthDays((int)nongDate[0]);
            } else {
                temp = LunarDate.monthDays((int)nongDate[0], i);
            }
            if (nongDate[6] == 1L && i == leap + 1) {
                nongDate[6] = 0L;
            }
            offset -= (long)temp;
            if (nongDate[6] != 0L) continue;
            nongDate[4] = nongDate[4] + 1L;
        }
        if (offset == 0L && leap > 0 && i == leap + 1) {
            if (nongDate[6] == 1L) {
                nongDate[6] = 0L;
            } else {
                nongDate[6] = 1L;
                --i;
                nongDate[4] = nongDate[4] - 1L;
            }
        }
        if (offset < 0L) {
            offset += (long)temp;
            --i;
            nongDate[4] = nongDate[4] - 1L;
        }
        nongDate[1] = i;
        nongDate[2] = offset + 1L;
        int solarTermIndex = -1;
        int tempMonth = month - 1;
        int firstSolarTermOfMonth = LunarDate.solarTerm(year, tempMonth * 2);
        int secondSolarTermOfMonth = LunarDate.solarTerm(year, tempMonth * 2 + 1);
        if (day == firstSolarTermOfMonth) {
            solarTermIndex = tempMonth * 2;
        } else if (day == secondSolarTermOfMonth) {
            solarTermIndex = tempMonth * 2 + 1;
        }
        nongDate[7] = solarTermIndex;
        return nongDate;
    }

    public static final String getChinaYear(int year) {
        String ge = numStr[year % 10];
        String shi = numStr[year / 10 % 10];
        String bai = numStr[year / 100 % 10];
        String qian = numStr[year / 1000 % 10];
        return qian + bai + shi + ge;
    }

    public static final String getChinaDay(int day) {
        String a = "";
        if (day == 10) {
            return "\u521d\u5341";
        }
        if (day == 20) {
            return "\u4e8c\u5341";
        }
        if (day == 30) {
            return "\u4e09\u5341";
        }
        int two = day / 10;
        if (two == 0) {
            a = "\u521d";
        }
        if (two == 1) {
            a = "\u5341";
        }
        if (two == 2) {
            a = "\u5eff";
        }
        if (two == 3) {
            a = "\u4e09";
        }
        int one = day % 10;
        switch (one) {
            case 1: {
                a = a + "\u4e00";
                break;
            }
            case 2: {
                a = a + "\u4e8c";
                break;
            }
            case 3: {
                a = a + "\u4e09";
                break;
            }
            case 4: {
                a = a + "\u56db";
                break;
            }
            case 5: {
                a = a + "\u4e94";
                break;
            }
            case 6: {
                a = a + "\u516d";
                break;
            }
            case 7: {
                a = a + "\u4e03";
                break;
            }
            case 8: {
                a = a + "\u516b";
                break;
            }
            case 9: {
                a = a + "\u4e5d";
                break;
            }
            default: {
                a = a + "";
            }
        }
        return a;
    }

    public static final String getWeekCn(int week) {
        String weekCn = "";
        switch (week) {
            case 1: {
                weekCn = "\u661f\u671f\u4e00";
                break;
            }
            case 2: {
                weekCn = "\u661f\u671f\u4e8c";
                break;
            }
            case 3: {
                weekCn = "\u661f\u671f\u4e09";
                break;
            }
            case 4: {
                weekCn = "\u661f\u671f\u56db";
                break;
            }
            case 5: {
                weekCn = "\u661f\u671f\u4e94";
                break;
            }
            case 6: {
                weekCn = "\u661f\u671f\u516d";
                break;
            }
            case 7: {
                weekCn = "\u661f\u671f\u65e5";
                break;
            }
            default: {
                weekCn = "";
            }
        }
        return weekCn;
    }

    public static LunarDate now() {
        LocalDate today = LocalDate.now();
        return new LunarDate(today);
    }

    public LocalDate getLocalDate() {
        return this.localDate;
    }

    public String getlDateCn() {
        return this.lDateCn;
    }

    public String getSuiCi() {
        return this.suiCi;
    }

    public String getlAnimal() {
        return this.lAnimal;
    }

    public int getlYear() {
        return this.lYear;
    }

    public int getlMonth() {
        return this.lMonth;
    }

    public int getlDay() {
        return this.lDay;
    }

    public String getlYearCn() {
        return this.lYearCn;
    }

    public String getlMonthCn() {
        return this.lMonthCn;
    }

    public String getlDayCn() {
        return this.lDayCn;
    }

    public String getWeekCn() {
        return this.weekCn;
    }

    public String getSolarTerm() {
        return this.solarTerm;
    }

    public String getLeapMonthCn() {
        return this.leapMonthCn;
    }

    public String getlDate() {
        return this.lDate;
    }

    public void setlDate(String lDate) {
        this.lDate = lDate;
    }

    public String getgDate() {
        return this.gDate;
    }

    public void setgDate(String gDate) {
        this.gDate = gDate;
    }

    public String toString() {
        return "LunarDate [localDate=" + this.localDate + ",lDateCn=" + this.lDateCn + ", suiCi=" + this.suiCi + ", lAnimal=" + this.lAnimal + ", lYear=" + this.lYear + ", lMonth=" + this.lMonth + ", lDay=" + this.lDay + ", lYearCn=" + this.lYearCn + ", lMonthCn=" + this.lMonthCn + ", lDayCn=" + this.lDayCn + ", weekCn=" + this.weekCn + ", solarTerm=" + this.solarTerm + ", leapMonthCn=" + this.leapMonthCn + "]";
    }

    public String formatLongCnWithChineseHoliday() {
        String chineseHoliday = Holiday.getChineseHoliday(this.localDate);
        if (this.solarTerm != "") {
            chineseHoliday = chineseHoliday + " " + this.solarTerm;
        }
        return this.suiCi + this.lAnimal + "\u5e74 " + this.lDateCn + " " + this.weekCn + " " + chineseHoliday;
    }

    public String formatLongCn() {
        return this.suiCi + this.lAnimal + "\u5e74 " + this.lDateCn + " " + this.weekCn;
    }

    public String formatShort() {
        return String.format("%02d", this.lMonth) + String.format("%02d", this.lDay);
    }

    @Override
    public boolean isSupported(TemporalField field) {
        return this.localDate.isSupported(field);
    }

    @Override
    public long getLong(TemporalField field) {
        return this.localDate.getLong(field);
    }

    @Override
    public boolean isSupported(TemporalUnit unit) {
        return this.localDate.isSupported(unit);
    }

    @Override
    public Temporal with(TemporalField field, long newValue) {
        return this.localDate.with(field, newValue);
    }

    @Override
    public Temporal plus(long amountToAdd, TemporalUnit unit) {
        return this.localDate.plus(amountToAdd, unit);
    }

    @Override
    public long until(Temporal endExclusive, TemporalUnit unit) {
        return this.localDate.until(endExclusive, unit);
    }

    public static void main(String[] args) {
        LunarDate now = LunarDate.now();
        System.out.println(now.toString());
        System.out.println(now.formatLongCnWithChineseHoliday());
        System.out.println(now.getlDateCn());
        System.out.println(now.getlDate());
        System.out.println(now.getgDate());
    }
}

