/*
 * Decompiled with CFR 0.152.
 */
package com.xkzhangsan.time.calculator;

import com.xkzhangsan.time.TemporalAdjusterExtension;
import com.xkzhangsan.time.converter.DateTimeConverterUtil;
import com.xkzhangsan.time.enums.ConstellationNameEnum;
import com.xkzhangsan.time.enums.MonthNameEnum;
import com.xkzhangsan.time.enums.TwelveTwoEnum;
import com.xkzhangsan.time.enums.WeekNameEnum;
import com.xkzhangsan.time.enums.ZoneIdEnum;
import com.xkzhangsan.time.formatter.DateTimeFormatterUtil;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;

public class DateTimeCalculatorUtil {
    private DateTimeCalculatorUtil() {
    }

    public static int getYear(Date date) {
        return DateTimeConverterUtil.toLocalDateTime(date).getYear();
    }

    public static int getYear(Instant instant) {
        return DateTimeConverterUtil.toLocalDateTime(instant).getYear();
    }

    public static int getYear(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.getYear();
    }

    public static int getMonth(Date date) {
        return DateTimeConverterUtil.toLocalDateTime(date).getMonthValue();
    }

    public static int getMonth(Instant instant) {
        return DateTimeConverterUtil.toLocalDateTime(instant).getMonthValue();
    }

    public static int getMonth(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.getMonthValue();
    }

    public static int getMonth(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return localDate.getMonthValue();
    }

    public static String getMonthEnLong(Date date) {
        return MonthNameEnum.getFullNameEnByCode(DateTimeCalculatorUtil.getMonth(date));
    }

    public static String getMonthEnLong(Instant instant) {
        return MonthNameEnum.getFullNameEnByCode(DateTimeCalculatorUtil.getMonth(instant));
    }

    public static String getMonthEnLong(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return MonthNameEnum.getFullNameEnByCode(DateTimeCalculatorUtil.getMonth(localDateTime));
    }

    public static String getMonthEnLong(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return MonthNameEnum.getFullNameEnByCode(DateTimeCalculatorUtil.getMonth(localDate));
    }

    public static String getMonthEnShort(Date date) {
        return MonthNameEnum.getShortNameEnByCode(DateTimeCalculatorUtil.getMonth(date));
    }

    public static String getMonthEnShort(Instant instant) {
        return MonthNameEnum.getShortNameEnByCode(DateTimeCalculatorUtil.getMonth(instant));
    }

    public static String getMonthEnShort(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return MonthNameEnum.getShortNameEnByCode(DateTimeCalculatorUtil.getMonth(localDateTime));
    }

    public static String getMonthEnShort(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return MonthNameEnum.getShortNameEnByCode(localDate.getMonthValue());
    }

    public static String getMonthEnShortUpper(Date date) {
        return MonthNameEnum.getShortNameEnByCode(DateTimeCalculatorUtil.getMonth(date)).toUpperCase();
    }

    public static String getMonthEnShortUpper(Instant instant) {
        return MonthNameEnum.getShortNameEnByCode(DateTimeCalculatorUtil.getMonth(instant)).toUpperCase();
    }

    public static String getMonthEnShortUpper(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return MonthNameEnum.getShortNameEnByCode(DateTimeCalculatorUtil.getMonth(localDateTime)).toUpperCase();
    }

    public static String getMonthEnShortUpper(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return MonthNameEnum.getShortNameEnByCode(localDate.getMonthValue()).toUpperCase();
    }

    public static String getMonthCnLong(Date date) {
        return MonthNameEnum.getFullNameCnByCode(DateTimeCalculatorUtil.getMonth(date));
    }

    public static String getMonthCnLong(Instant instant) {
        return MonthNameEnum.getFullNameCnByCode(DateTimeCalculatorUtil.getMonth(instant));
    }

    public static String getMonthCnLong(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return MonthNameEnum.getFullNameCnByCode(DateTimeCalculatorUtil.getMonth(localDateTime));
    }

    public static String getMonthCnLong(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return MonthNameEnum.getFullNameCnByCode(localDate.getMonthValue());
    }

    public static String getMonthCnShort(Date date) {
        return MonthNameEnum.getShortNameCnByCode(DateTimeCalculatorUtil.getMonth(date));
    }

    public static String getMonthCnShort(Instant instant) {
        return MonthNameEnum.getShortNameCnByCode(DateTimeCalculatorUtil.getMonth(instant));
    }

    public static String getMonthCnShort(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return MonthNameEnum.getShortNameCnByCode(DateTimeCalculatorUtil.getMonth(localDateTime));
    }

    public static String getMonthCnShort(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return MonthNameEnum.getShortNameCnByCode(localDate.getMonthValue());
    }

    public static int getDayOfMonth(Date date) {
        return DateTimeConverterUtil.toLocalDateTime(date).getDayOfMonth();
    }

    public static int getDayOfMonth(Instant instant) {
        return DateTimeConverterUtil.toLocalDateTime(instant).getDayOfMonth();
    }

    public static int getDayOfMonth(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.getDayOfMonth();
    }

    public static int getDayOfYear(Date date) {
        return DateTimeConverterUtil.toLocalDateTime(date).getDayOfYear();
    }

    public static int getDayOfYear(Instant instant) {
        return DateTimeConverterUtil.toLocalDateTime(instant).getDayOfYear();
    }

    public static int getDayOfYear(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.getDayOfYear();
    }

    public static int getLengthOfYear(int year) {
        return Year.of(year).length();
    }

    public static int getDayOfYear() {
        return DateTimeCalculatorUtil.getDayOfYear(new Date());
    }

    public static int getHour(Date date) {
        return DateTimeConverterUtil.toLocalDateTime(date).getHour();
    }

    public static int getHour(Instant instant) {
        return DateTimeConverterUtil.toLocalDateTime(instant).getHour();
    }

    public static int getHour(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.getHour();
    }

    public static int getMinute(Date date) {
        return DateTimeConverterUtil.toLocalDateTime(date).getMinute();
    }

    public static int getMinute(Instant instant) {
        return DateTimeConverterUtil.toLocalDateTime(instant).getMinute();
    }

    public static int getMinute(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.getMinute();
    }

    public static int getSecond(Date date) {
        return DateTimeConverterUtil.toLocalDateTime(date).getSecond();
    }

    public static int getSecond(Instant instant) {
        return DateTimeConverterUtil.toLocalDateTime(instant).getSecond();
    }

    public static int getSecond(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.getSecond();
    }

    public static int getMillisecond(Date date) {
        return DateTimeConverterUtil.toLocalDateTime(date).getNano() / 1000000;
    }

    public static int getMillisecond(Instant instant) {
        return DateTimeConverterUtil.toLocalDateTime(instant).getNano() / 1000000;
    }

    public static int getMillisecond(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.getNano() / 1000000;
    }

    public static long getEpochMilli() {
        return System.currentTimeMillis();
    }

    public static long getEpochSecond() {
        return System.currentTimeMillis() / 1000L;
    }

    public static String getEpochMilliFormat() {
        return DateTimeFormatterUtil.formatToDateTimeStr(new Date());
    }

    public static String getEpochMilliFormatFull() {
        return DateTimeFormatterUtil.format(new Date(), DateTimeFormatterUtil.YYYY_MM_DD_HH_MM_SS_SSS_FMT);
    }

    public static String getEpochMilliIsoFormat() {
        return DateTimeFormatterUtil.format(new Date(), DateTimeFormatterUtil.YYYY_MM_DD_T_HH_MM_SS_XXX_FMT);
    }

    public static String getEpochMilliIsoFormatFull() {
        return DateTimeFormatterUtil.format(new Date(), DateTimeFormatterUtil.YYYY_MM_DD_T_HH_MM_SS_SSS_XXX_FMT);
    }

    public static String getEpochMilliIsoNotFormatNoColon() {
        return DateTimeFormatterUtil.format(new Date(), DateTimeFormatterUtil.YYYY_MM_DD_T_HH_MM_SS_Z_FMT);
    }

    public static String getEpochMilliIsoFormatFullNoColon() {
        return DateTimeFormatterUtil.format(new Date(), DateTimeFormatterUtil.YYYY_MM_DD_T_HH_MM_SS_SSS_Z_FMT);
    }

    public static Date getDate(int year, int month, int dayOfMonth) {
        return DateTimeConverterUtil.toDate(LocalDate.of(year, month, dayOfMonth));
    }

    public static Date getDate(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        return DateTimeConverterUtil.toDate(LocalDateTime.of(year, month, dayOfMonth, hour, minute, second));
    }

    public static Date getDateStartOfMonth(int year, int month) {
        return DateTimeConverterUtil.toDateStartOfMonth(YearMonth.of(year, month));
    }

    public static Date getDateEndOfMonth(int year, int month) {
        return DateTimeConverterUtil.toDateEndOfMonth(YearMonth.of(year, month));
    }

    public static int getAge(LocalDate birthDay) {
        Objects.requireNonNull(birthDay, "birthDay");
        Period period = DateTimeCalculatorUtil.periodBetween(birthDay, LocalDate.now());
        if (period.getYears() < 0) {
            throw new DateTimeException("birthDay is after now!");
        }
        return period.getYears();
    }

    public static int getAge(Date birthDay) {
        return DateTimeCalculatorUtil.getAge(DateTimeConverterUtil.toLocalDate(birthDay));
    }

    public static int getAge(LocalDateTime birthDay) {
        return DateTimeCalculatorUtil.getAge(DateTimeConverterUtil.toLocalDate(birthDay));
    }

    public static Date plusYears(Date date, long amountToAdd) {
        return DateTimeCalculatorUtil.plus(date, (TemporalUnit)ChronoUnit.YEARS, amountToAdd);
    }

    public static LocalDateTime plusYears(LocalDateTime localDateTime, long amountToAdd) {
        return (LocalDateTime)DateTimeCalculatorUtil.plus(localDateTime, (TemporalUnit)ChronoUnit.YEARS, amountToAdd);
    }

    public static LocalDate plusYears(LocalDate localDate, long amountToAdd) {
        return (LocalDate)DateTimeCalculatorUtil.plus(localDate, (TemporalUnit)ChronoUnit.YEARS, amountToAdd);
    }

    public static Date plusMonths(Date date, long amountToAdd) {
        return DateTimeCalculatorUtil.plus(date, (TemporalUnit)ChronoUnit.MONTHS, amountToAdd);
    }

    public static LocalDateTime plusMonths(LocalDateTime localDateTime, long amountToAdd) {
        return (LocalDateTime)DateTimeCalculatorUtil.plus(localDateTime, (TemporalUnit)ChronoUnit.MONTHS, amountToAdd);
    }

    public static LocalDate plusMonths(LocalDate localDate, long amountToAdd) {
        return (LocalDate)DateTimeCalculatorUtil.plus(localDate, (TemporalUnit)ChronoUnit.MONTHS, amountToAdd);
    }

    public static Date plusWeeks(Date date, long amountToAdd) {
        return DateTimeCalculatorUtil.plus(date, (TemporalUnit)ChronoUnit.WEEKS, amountToAdd);
    }

    public static LocalDateTime plusWeeks(LocalDateTime localDateTime, long amountToAdd) {
        return (LocalDateTime)DateTimeCalculatorUtil.plus(localDateTime, (TemporalUnit)ChronoUnit.WEEKS, amountToAdd);
    }

    public static LocalDate plusWeeks(LocalDate localDate, long amountToAdd) {
        return (LocalDate)DateTimeCalculatorUtil.plus(localDate, (TemporalUnit)ChronoUnit.WEEKS, amountToAdd);
    }

    public static Date plusDays(Date date, long amountToAdd) {
        return DateTimeCalculatorUtil.plus(date, (TemporalUnit)ChronoUnit.DAYS, amountToAdd);
    }

    public static LocalDateTime plusDays(LocalDateTime localDateTime, long amountToAdd) {
        return (LocalDateTime)DateTimeCalculatorUtil.plus(localDateTime, (TemporalUnit)ChronoUnit.DAYS, amountToAdd);
    }

    public static LocalDate plusDays(LocalDate localDate, long amountToAdd) {
        return (LocalDate)DateTimeCalculatorUtil.plus(localDate, (TemporalUnit)ChronoUnit.DAYS, amountToAdd);
    }

    public static Date plusHours(Date date, long amountToAdd) {
        return DateTimeCalculatorUtil.plus(date, (TemporalUnit)ChronoUnit.HOURS, amountToAdd);
    }

    public static LocalDateTime plusHours(LocalDateTime localDateTime, long amountToAdd) {
        return (LocalDateTime)DateTimeCalculatorUtil.plus(localDateTime, (TemporalUnit)ChronoUnit.HOURS, amountToAdd);
    }

    public static LocalTime plusHours(LocalTime localTime, long amountToAdd) {
        return (LocalTime)DateTimeCalculatorUtil.plus(localTime, (TemporalUnit)ChronoUnit.HOURS, amountToAdd);
    }

    public static Date plusMinutes(Date date, long amountToAdd) {
        return DateTimeCalculatorUtil.plus(date, (TemporalUnit)ChronoUnit.MINUTES, amountToAdd);
    }

    public static LocalDateTime plusMinutes(LocalDateTime localDateTime, long amountToAdd) {
        return (LocalDateTime)DateTimeCalculatorUtil.plus(localDateTime, (TemporalUnit)ChronoUnit.MINUTES, amountToAdd);
    }

    public static LocalTime plusMinutes(LocalTime localTime, long amountToAdd) {
        return (LocalTime)DateTimeCalculatorUtil.plus(localTime, (TemporalUnit)ChronoUnit.MINUTES, amountToAdd);
    }

    public static Date plusSeconds(Date date, long amountToAdd) {
        return DateTimeCalculatorUtil.plus(date, (TemporalUnit)ChronoUnit.SECONDS, amountToAdd);
    }

    public static LocalDateTime plusSeconds(LocalDateTime localDateTime, long amountToAdd) {
        return (LocalDateTime)DateTimeCalculatorUtil.plus(localDateTime, (TemporalUnit)ChronoUnit.SECONDS, amountToAdd);
    }

    public static LocalTime plusSeconds(LocalTime localTime, long amountToAdd) {
        return (LocalTime)DateTimeCalculatorUtil.plus(localTime, (TemporalUnit)ChronoUnit.SECONDS, amountToAdd);
    }

    public static Date plusMillis(Date date, long amountToAdd) {
        return DateTimeCalculatorUtil.plus(date, (TemporalUnit)ChronoUnit.MILLIS, amountToAdd);
    }

    public static LocalDateTime plusMillis(LocalDateTime localDateTime, long amountToAdd) {
        return (LocalDateTime)DateTimeCalculatorUtil.plus(localDateTime, (TemporalUnit)ChronoUnit.MILLIS, amountToAdd);
    }

    public static LocalTime plusMillis(LocalTime localTime, long amountToAdd) {
        return (LocalTime)DateTimeCalculatorUtil.plus(localTime, (TemporalUnit)ChronoUnit.MILLIS, amountToAdd);
    }

    public static Date minusYears(Date date, long amountToSubtract) {
        return DateTimeCalculatorUtil.minus(date, (TemporalUnit)ChronoUnit.YEARS, amountToSubtract);
    }

    public static LocalDateTime minusYears(LocalDateTime localDateTime, long amountToSubtract) {
        return (LocalDateTime)DateTimeCalculatorUtil.minus(localDateTime, (TemporalUnit)ChronoUnit.YEARS, amountToSubtract);
    }

    public static LocalDate minusYears(LocalDate localDate, long amountToSubtract) {
        return (LocalDate)DateTimeCalculatorUtil.minus(localDate, (TemporalUnit)ChronoUnit.YEARS, amountToSubtract);
    }

    public static Date minusMonths(Date date, long amountToSubtract) {
        return DateTimeCalculatorUtil.minus(date, (TemporalUnit)ChronoUnit.MONTHS, amountToSubtract);
    }

    public static LocalDateTime minusMonths(LocalDateTime localDateTime, long amountToAdd) {
        return (LocalDateTime)DateTimeCalculatorUtil.minus(localDateTime, (TemporalUnit)ChronoUnit.MONTHS, amountToAdd);
    }

    public static LocalDate minusMonths(LocalDate localDate, long amountToSubtract) {
        return (LocalDate)DateTimeCalculatorUtil.minus(localDate, (TemporalUnit)ChronoUnit.MONTHS, amountToSubtract);
    }

    public static Date minusWeeks(Date date, long amountToSubtract) {
        return DateTimeCalculatorUtil.minus(date, (TemporalUnit)ChronoUnit.WEEKS, amountToSubtract);
    }

    public static LocalDateTime minusWeeks(LocalDateTime localDateTime, long amountToSubtract) {
        return (LocalDateTime)DateTimeCalculatorUtil.minus(localDateTime, (TemporalUnit)ChronoUnit.WEEKS, amountToSubtract);
    }

    public static LocalDate minusWeeks(LocalDate localDate, long amountToSubtract) {
        return (LocalDate)DateTimeCalculatorUtil.minus(localDate, (TemporalUnit)ChronoUnit.WEEKS, amountToSubtract);
    }

    public static Date minusDays(Date date, long amountToSubtract) {
        return DateTimeCalculatorUtil.minus(date, (TemporalUnit)ChronoUnit.DAYS, amountToSubtract);
    }

    public static LocalDateTime minusDays(LocalDateTime localDateTime, long amountToSubtract) {
        return (LocalDateTime)DateTimeCalculatorUtil.minus(localDateTime, (TemporalUnit)ChronoUnit.DAYS, amountToSubtract);
    }

    public static LocalDate minusDays(LocalDate localDate, long amountToSubtract) {
        return (LocalDate)DateTimeCalculatorUtil.minus(localDate, (TemporalUnit)ChronoUnit.DAYS, amountToSubtract);
    }

    public static Date minusHours(Date date, long amountToSubtract) {
        return DateTimeCalculatorUtil.minus(date, (TemporalUnit)ChronoUnit.HOURS, amountToSubtract);
    }

    public static LocalDateTime minusHours(LocalDateTime localDateTime, long amountToSubtract) {
        return (LocalDateTime)DateTimeCalculatorUtil.minus(localDateTime, (TemporalUnit)ChronoUnit.HOURS, amountToSubtract);
    }

    public static LocalTime minusHours(LocalTime localTime, long amountToSubtract) {
        return (LocalTime)DateTimeCalculatorUtil.minus(localTime, (TemporalUnit)ChronoUnit.HOURS, amountToSubtract);
    }

    public static Date minusMinutes(Date date, long amountToSubtract) {
        return DateTimeCalculatorUtil.minus(date, (TemporalUnit)ChronoUnit.MINUTES, amountToSubtract);
    }

    public static LocalDateTime minusMinutes(LocalDateTime localDateTime, long amountToSubtract) {
        return (LocalDateTime)DateTimeCalculatorUtil.minus(localDateTime, (TemporalUnit)ChronoUnit.MINUTES, amountToSubtract);
    }

    public static LocalTime minusMinutes(LocalTime localTime, long amountToSubtract) {
        return (LocalTime)DateTimeCalculatorUtil.minus(localTime, (TemporalUnit)ChronoUnit.MINUTES, amountToSubtract);
    }

    public static Date minusSeconds(Date date, long amountToSubtract) {
        return DateTimeCalculatorUtil.minus(date, (TemporalUnit)ChronoUnit.SECONDS, amountToSubtract);
    }

    public static LocalDateTime minusSeconds(LocalDateTime localDateTime, long amountToSubtract) {
        return (LocalDateTime)DateTimeCalculatorUtil.minus(localDateTime, (TemporalUnit)ChronoUnit.SECONDS, amountToSubtract);
    }

    public static LocalTime minusSeconds(LocalTime localTime, long amountToSubtract) {
        return (LocalTime)DateTimeCalculatorUtil.minus(localTime, (TemporalUnit)ChronoUnit.SECONDS, amountToSubtract);
    }

    public static Date minusMillis(Date date, long amountToSubtract) {
        return DateTimeCalculatorUtil.minus(date, (TemporalUnit)ChronoUnit.MILLIS, amountToSubtract);
    }

    public static LocalDateTime minusMillis(LocalDateTime localDateTime, long amountToSubtract) {
        return (LocalDateTime)DateTimeCalculatorUtil.minus(localDateTime, (TemporalUnit)ChronoUnit.MILLIS, amountToSubtract);
    }

    public static LocalTime minusMillis(LocalTime localTime, long amountToSubtract) {
        return (LocalTime)DateTimeCalculatorUtil.minus(localTime, (TemporalUnit)ChronoUnit.MILLIS, amountToSubtract);
    }

    public static Date withYear(Date date, long newValue) {
        return DateTimeCalculatorUtil.with(date, (TemporalField)ChronoField.YEAR, newValue);
    }

    public static LocalDateTime withYear(LocalDateTime localDateTime, long newValue) {
        return (LocalDateTime)DateTimeCalculatorUtil.with(localDateTime, (TemporalField)ChronoField.YEAR, newValue);
    }

    public static LocalDate withYear(LocalDate localDate, long newValue) {
        return (LocalDate)DateTimeCalculatorUtil.with(localDate, (TemporalField)ChronoField.YEAR, newValue);
    }

    public static Date withMonth(Date date, long newValue) {
        return DateTimeCalculatorUtil.with(date, (TemporalField)ChronoField.MONTH_OF_YEAR, newValue);
    }

    public static LocalDateTime withMonth(LocalDateTime localDateTime, long newValue) {
        return (LocalDateTime)DateTimeCalculatorUtil.with(localDateTime, (TemporalField)ChronoField.MONTH_OF_YEAR, newValue);
    }

    public static LocalDate withMonth(LocalDate localDate, long newValue) {
        return (LocalDate)DateTimeCalculatorUtil.with(localDate, (TemporalField)ChronoField.MONTH_OF_YEAR, newValue);
    }

    public static Date withDayOfMonth(Date date, long newValue) {
        return DateTimeCalculatorUtil.with(date, (TemporalField)ChronoField.DAY_OF_MONTH, newValue);
    }

    public static LocalDateTime withDayOfMonth(LocalDateTime localDateTime, long newValue) {
        return (LocalDateTime)DateTimeCalculatorUtil.with(localDateTime, (TemporalField)ChronoField.DAY_OF_MONTH, newValue);
    }

    public static LocalDate withDayOfMonth(LocalDate localDate, long newValue) {
        return (LocalDate)DateTimeCalculatorUtil.with(localDate, (TemporalField)ChronoField.DAY_OF_MONTH, newValue);
    }

    public static Date withDayOfYear(Date date, long newValue) {
        return DateTimeCalculatorUtil.with(date, (TemporalField)ChronoField.DAY_OF_YEAR, newValue);
    }

    public static LocalDateTime withDayOfYear(LocalDateTime localDateTime, long newValue) {
        return (LocalDateTime)DateTimeCalculatorUtil.with(localDateTime, (TemporalField)ChronoField.DAY_OF_YEAR, newValue);
    }

    public static LocalDate withDayOfYear(LocalDate localDate, long newValue) {
        return (LocalDate)DateTimeCalculatorUtil.with(localDate, (TemporalField)ChronoField.DAY_OF_YEAR, newValue);
    }

    public static Date withHour(Date date, long newValue) {
        return DateTimeCalculatorUtil.with(date, (TemporalField)ChronoField.HOUR_OF_DAY, newValue);
    }

    public static LocalDateTime withHour(LocalDateTime localDateTime, long newValue) {
        return (LocalDateTime)DateTimeCalculatorUtil.with(localDateTime, (TemporalField)ChronoField.HOUR_OF_DAY, newValue);
    }

    public static LocalTime withHour(LocalTime localTime, long newValue) {
        return (LocalTime)DateTimeCalculatorUtil.with(localTime, (TemporalField)ChronoField.HOUR_OF_DAY, newValue);
    }

    public static Date withMinute(Date date, long newValue) {
        return DateTimeCalculatorUtil.with(date, (TemporalField)ChronoField.MINUTE_OF_HOUR, newValue);
    }

    public static LocalDateTime withMinute(LocalDateTime localDateTime, long newValue) {
        return (LocalDateTime)DateTimeCalculatorUtil.with(localDateTime, (TemporalField)ChronoField.MINUTE_OF_HOUR, newValue);
    }

    public static LocalTime withMinute(LocalTime localTime, long newValue) {
        return (LocalTime)DateTimeCalculatorUtil.with(localTime, (TemporalField)ChronoField.MINUTE_OF_HOUR, newValue);
    }

    public static Date withSecond(Date date, long newValue) {
        return DateTimeCalculatorUtil.with(date, (TemporalField)ChronoField.SECOND_OF_MINUTE, newValue);
    }

    public static LocalDateTime withSecond(LocalDateTime localDateTime, long newValue) {
        return (LocalDateTime)DateTimeCalculatorUtil.with(localDateTime, (TemporalField)ChronoField.SECOND_OF_MINUTE, newValue);
    }

    public static LocalTime withSecond(LocalTime localTime, long newValue) {
        return (LocalTime)DateTimeCalculatorUtil.with(localTime, (TemporalField)ChronoField.SECOND_OF_MINUTE, newValue);
    }

    public static long betweenYears(LocalDateTime startInclusive, LocalDateTime endExclusive) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endExclusive, "endExclusive");
        return Period.between(DateTimeConverterUtil.toLocalDate(startInclusive), DateTimeConverterUtil.toLocalDate(endExclusive)).getYears();
    }

    public static long betweenYears(Date startInclusive, Date endExclusive) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endExclusive, "endExclusive");
        return Period.between(DateTimeConverterUtil.toLocalDate(startInclusive), DateTimeConverterUtil.toLocalDate(endExclusive)).getYears();
    }

    public static long betweenYears(LocalDate startInclusive, LocalDate endExclusive) {
        return Period.between(startInclusive, endExclusive).getYears();
    }

    public static long betweenMonths(LocalDateTime startInclusive, LocalDateTime endExclusive) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endExclusive, "endExclusive");
        return Period.between(DateTimeConverterUtil.toLocalDate(startInclusive), DateTimeConverterUtil.toLocalDate(endExclusive)).getMonths();
    }

    public static long betweenMonths(Date startInclusive, Date endExclusive) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endExclusive, "endExclusive");
        return Period.between(DateTimeConverterUtil.toLocalDate(startInclusive), DateTimeConverterUtil.toLocalDate(endExclusive)).getMonths();
    }

    public static long betweenMonths(LocalDate startInclusive, LocalDate endExclusive) {
        return Period.between(startInclusive, endExclusive).getMonths();
    }

    public static long betweenDays(LocalDateTime startInclusive, LocalDateTime endExclusive) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endExclusive, "endExclusive");
        return Period.between(DateTimeConverterUtil.toLocalDate(startInclusive), DateTimeConverterUtil.toLocalDate(endExclusive)).getDays();
    }

    public static long betweenDays(Date startInclusive, Date endExclusive) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endExclusive, "endExclusive");
        return Period.between(DateTimeConverterUtil.toLocalDate(startInclusive), DateTimeConverterUtil.toLocalDate(endExclusive)).getDays();
    }

    public static long betweenDays(LocalDate startInclusive, LocalDate endExclusive) {
        return Period.between(startInclusive, endExclusive).getDays();
    }

    public static long betweenTotalDays(LocalDateTime startInclusive, LocalDateTime endExclusive) {
        return Duration.between(startInclusive, endExclusive).toDays();
    }

    public static long betweenTotalDays(Date startInclusive, Date endExclusive) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endExclusive, "endExclusive");
        return DateTimeCalculatorUtil.durationBetween(DateTimeConverterUtil.toLocalDateTime(startInclusive), DateTimeConverterUtil.toLocalDateTime(endExclusive)).toDays();
    }

    public static long betweenTotalHours(LocalDateTime startInclusive, LocalDateTime endExclusive) {
        return Duration.between(startInclusive, endExclusive).toHours();
    }

    public static long betweenTotalHours(LocalTime startInclusive, LocalTime endExclusive) {
        return Duration.between(startInclusive, endExclusive).toHours();
    }

    public static long betweenTotalHours(Date startInclusive, Date endExclusive) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endExclusive, "endExclusive");
        return DateTimeCalculatorUtil.durationBetween(DateTimeConverterUtil.toLocalDateTime(startInclusive), DateTimeConverterUtil.toLocalDateTime(endExclusive)).toHours();
    }

    public static long betweenTotalMinutes(LocalDateTime startInclusive, LocalDateTime endExclusive) {
        return Duration.between(startInclusive, endExclusive).toMinutes();
    }

    public static long betweenTotalMinutes(LocalTime startInclusive, LocalTime endExclusive) {
        return Duration.between(startInclusive, endExclusive).toMinutes();
    }

    public static long betweenTotalMinutes(Date startInclusive, Date endExclusive) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endExclusive, "endExclusive");
        return DateTimeCalculatorUtil.durationBetween(DateTimeConverterUtil.toLocalDateTime(startInclusive), DateTimeConverterUtil.toLocalDateTime(endExclusive)).toMinutes();
    }

    public static long betweenTotalSeconds(LocalDateTime startInclusive, LocalDateTime endExclusive) {
        return Duration.between(startInclusive, endExclusive).getSeconds();
    }

    public static long betweenTotalSeconds(LocalTime startInclusive, LocalTime endExclusive) {
        return Duration.between(startInclusive, endExclusive).getSeconds();
    }

    public static long betweenTotalSeconds(Date startInclusive, Date endExclusive) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endExclusive, "endExclusive");
        return DateTimeCalculatorUtil.durationBetween(DateTimeConverterUtil.toLocalDateTime(startInclusive), DateTimeConverterUtil.toLocalDateTime(endExclusive)).getSeconds();
    }

    public static long betweenTotalMillis(LocalDateTime startInclusive, LocalDateTime endExclusive) {
        return Duration.between(startInclusive, endExclusive).toMillis();
    }

    public static long betweenTotalMillis(LocalTime startInclusive, LocalTime endExclusive) {
        return Duration.between(startInclusive, endExclusive).toMillis();
    }

    public static long betweenTotalMillis(Date startInclusive, Date endExclusive) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endExclusive, "endExclusive");
        return DateTimeCalculatorUtil.durationBetween(DateTimeConverterUtil.toLocalDateTime(startInclusive), DateTimeConverterUtil.toLocalDateTime(endExclusive)).toMillis();
    }

    public static long betweenTotalNanos(LocalDateTime startInclusive, LocalDateTime endExclusive) {
        return Duration.between(startInclusive, endExclusive).toNanos();
    }

    public static long betweenTotalNanos(LocalTime startInclusive, LocalTime endExclusive) {
        return Duration.between(startInclusive, endExclusive).toNanos();
    }

    public static long betweenTotalNanos(Date startInclusive, Date endExclusive) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endExclusive, "endExclusive");
        return DateTimeCalculatorUtil.durationBetween(DateTimeConverterUtil.toLocalDateTime(startInclusive), DateTimeConverterUtil.toLocalDateTime(endExclusive)).toNanos();
    }

    public static int getDayOfWeek(Date date) {
        return DateTimeConverterUtil.toLocalDateTime(date).getDayOfWeek().getValue();
    }

    public static int getDayOfWeek(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.getDayOfWeek().getValue();
    }

    public static int getDayOfWeek(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return localDate.getDayOfWeek().getValue();
    }

    public static int getDayOfWeek(Instant instant) {
        return DateTimeConverterUtil.toLocalDateTime(instant).getDayOfWeek().getValue();
    }

    public static String getDayOfWeekEnLong(Date date) {
        return WeekNameEnum.getFullNameEnByCode(DateTimeCalculatorUtil.getDayOfWeek(date));
    }

    public static String getDayOfWeekEnLong(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return WeekNameEnum.getFullNameEnByCode(DateTimeCalculatorUtil.getDayOfWeek(localDateTime));
    }

    public static String getDayOfWeekEnLong(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return WeekNameEnum.getFullNameEnByCode(DateTimeCalculatorUtil.getDayOfWeek(localDate));
    }

    public static String getDayOfWeekEnLong(Instant instant) {
        return WeekNameEnum.getFullNameEnByCode(DateTimeCalculatorUtil.getDayOfWeek(instant));
    }

    public static String getDayOfWeekEnShort(Date date) {
        return WeekNameEnum.getShortNameEnByCode(DateTimeCalculatorUtil.getDayOfWeek(date));
    }

    public static String getDayOfWeekEnShort(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return WeekNameEnum.getShortNameEnByCode(DateTimeCalculatorUtil.getDayOfWeek(localDateTime));
    }

    public static String getDayOfWeekEnShort(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return WeekNameEnum.getShortNameEnByCode(DateTimeCalculatorUtil.getDayOfWeek(localDate));
    }

    public static String getDayOfWeekEnShort(Instant instant) {
        return WeekNameEnum.getShortNameEnByCode(DateTimeCalculatorUtil.getDayOfWeek(instant));
    }

    public static String getDayOfWeekEnShortUpper(Date date) {
        return WeekNameEnum.getShortNameEnByCode(DateTimeCalculatorUtil.getDayOfWeek(date)).toUpperCase();
    }

    public static String getDayOfWeekEnShortUpper(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return WeekNameEnum.getShortNameEnByCode(DateTimeCalculatorUtil.getDayOfWeek(localDateTime)).toUpperCase();
    }

    public static String getDayOfWeekEnShortUpper(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return WeekNameEnum.getShortNameEnByCode(DateTimeCalculatorUtil.getDayOfWeek(localDate)).toUpperCase();
    }

    public static String getDayOfWeekEnShortUpper(Instant instant) {
        return WeekNameEnum.getShortNameEnByCode(DateTimeCalculatorUtil.getDayOfWeek(instant)).toUpperCase();
    }

    public static String getDayOfWeekCn(Date date) {
        return WeekNameEnum.getNameCnByCode(DateTimeCalculatorUtil.getDayOfWeek(date));
    }

    public static String getDayOfWeekCn(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return WeekNameEnum.getNameCnByCode(DateTimeCalculatorUtil.getDayOfWeek(localDateTime));
    }

    public static String getDayOfWeekCn(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return WeekNameEnum.getNameCnByCode(DateTimeCalculatorUtil.getDayOfWeek(localDate));
    }

    public static String getDayOfWeekCn(Instant instant) {
        return WeekNameEnum.getNameCnByCode(DateTimeCalculatorUtil.getDayOfWeek(instant));
    }

    public static String getDayOfWeekCnShort(Date date) {
        return WeekNameEnum.getNameCnByCode(DateTimeCalculatorUtil.getDayOfWeek(date)).substring(2);
    }

    public static String getDayOfWeekCnShort(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return WeekNameEnum.getNameCnByCode(DateTimeCalculatorUtil.getDayOfWeek(localDateTime)).substring(2);
    }

    public static String getDayOfWeekCnShort(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return WeekNameEnum.getNameCnByCode(DateTimeCalculatorUtil.getDayOfWeek(localDate)).substring(2);
    }

    public static String getDayOfWeekCnShort(Instant instant) {
        return WeekNameEnum.getNameCnByCode(DateTimeCalculatorUtil.getDayOfWeek(instant)).substring(2);
    }

    public static LocalDate firstDayOfMonth(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return localDate.with(TemporalAdjusters.firstDayOfMonth());
    }

    public static LocalDateTime firstDayOfMonth(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.with(TemporalAdjusters.firstDayOfMonth());
    }

    public static Date firstDayOfMonth(Date date) {
        return DateTimeConverterUtil.toDate(DateTimeConverterUtil.toLocalDateTime(date).with(TemporalAdjusters.firstDayOfMonth()));
    }

    public static LocalDate lastDayOfMonth(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return localDate.with(TemporalAdjusters.lastDayOfMonth());
    }

    public static LocalDateTime lastDayOfMonth(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.with(TemporalAdjusters.lastDayOfMonth());
    }

    public static Date lastDayOfMonth(Date date) {
        return DateTimeConverterUtil.toDate(DateTimeConverterUtil.toLocalDateTime(date).with(TemporalAdjusters.lastDayOfMonth()));
    }

    public static boolean isLeapYear(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return localDate.isLeapYear();
    }

    public static boolean isLeapYear(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.toLocalDate().isLeapYear();
    }

    public static boolean isLeapYear(Date date) {
        return DateTimeConverterUtil.toLocalDateTime(date).toLocalDate().isLeapYear();
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    public static int nextLeapYear(int year) {
        for (int i = 0; i < 8; ++i) {
            if (!DateTimeCalculatorUtil.isLeapYear(++year)) continue;
            return year;
        }
        return -1;
    }

    public static LocalDateTime nextLeapYear(LocalDateTime localDateTime) {
        return localDateTime.withYear(DateTimeCalculatorUtil.nextLeapYear(localDateTime.getYear()));
    }

    public static LocalDate nextLeapYear(LocalDate localDate) {
        return localDate.withYear(DateTimeCalculatorUtil.nextLeapYear(localDate.getYear()));
    }

    public static Date nextLeapYear(Date date) {
        return DateTimeConverterUtil.toDate(DateTimeCalculatorUtil.nextLeapYear(DateTimeConverterUtil.toLocalDateTime(date)));
    }

    public static boolean isWorkDay(Date date) {
        int dayOfWeek = DateTimeCalculatorUtil.getDayOfWeek(date);
        return dayOfWeek != 6 && dayOfWeek != 7;
    }

    public static boolean isWorkDay(LocalDateTime localDateTime) {
        int dayOfWeek = DateTimeCalculatorUtil.getDayOfWeek(localDateTime);
        return dayOfWeek != 6 && dayOfWeek != 7;
    }

    public static boolean isWorkDay(LocalDate localDate) {
        int dayOfWeek = DateTimeCalculatorUtil.getDayOfWeek(localDate);
        return dayOfWeek != 6 && dayOfWeek != 7;
    }

    public static boolean isWeekend(Date date) {
        return !DateTimeCalculatorUtil.isWorkDay(date);
    }

    public static boolean isWeekend(LocalDateTime localDateTime) {
        return !DateTimeCalculatorUtil.isWorkDay(localDateTime);
    }

    public static boolean isWeekend(LocalDate localDate) {
        return !DateTimeCalculatorUtil.isWorkDay(localDate);
    }

    public static int lengthOfMonth(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return localDate.lengthOfMonth();
    }

    public static int lengthOfMonth(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.toLocalDate().lengthOfMonth();
    }

    public static int lengthOfMonth(Date date) {
        return DateTimeConverterUtil.toLocalDateTime(date).toLocalDate().lengthOfMonth();
    }

    public static int lengthOfYear(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return localDate.lengthOfYear();
    }

    public static int lengthOfYear(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.toLocalDate().lengthOfYear();
    }

    public static int lengthOfYear(Date date) {
        return DateTimeConverterUtil.toLocalDateTime(date).toLocalDate().lengthOfYear();
    }

    public static LocalDate next(LocalDate localDate, DayOfWeek dayOfWeek) {
        Objects.requireNonNull(localDate, "localDate");
        return localDate.with(TemporalAdjusters.next(dayOfWeek));
    }

    public static LocalDateTime next(LocalDateTime localDateTime, DayOfWeek dayOfWeek) {
        return localDateTime.with(TemporalAdjusters.next(dayOfWeek));
    }

    public static Date next(Date date, DayOfWeek dayOfWeek) {
        return DateTimeConverterUtil.toDate(DateTimeConverterUtil.toLocalDateTime(date).with(TemporalAdjusters.next(dayOfWeek)));
    }

    public static LocalDate previous(LocalDate localDate, DayOfWeek dayOfWeek) {
        Objects.requireNonNull(localDate, "localDate");
        return localDate.with(TemporalAdjusters.previous(dayOfWeek));
    }

    public static LocalDateTime previous(LocalDateTime localDateTime, DayOfWeek dayOfWeek) {
        return localDateTime.with(TemporalAdjusters.previous(dayOfWeek));
    }

    public static Date previous(Date date, DayOfWeek dayOfWeek) {
        return DateTimeConverterUtil.toDate(DateTimeConverterUtil.toLocalDateTime(date).with(TemporalAdjusters.previous(dayOfWeek)));
    }

    public static LocalDate nextWorkDay(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return localDate.with(TemporalAdjusterExtension.nextWorkDay());
    }

    public static LocalDateTime nextWorkDay(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.with(TemporalAdjusterExtension.nextWorkDay());
    }

    public static Date nextWorkDay(Date date) {
        return DateTimeConverterUtil.toDate(DateTimeConverterUtil.toLocalDateTime(date).with(TemporalAdjusterExtension.nextWorkDay()));
    }

    public static ZonedDateTime getZonedDateTimeNowOfDefault() {
        return ZonedDateTime.now(ZoneId.systemDefault());
    }

    public static ZonedDateTime getZonedDateTimeNowOfShanghai() {
        return ZonedDateTime.now(ZoneId.of(ZoneIdEnum.CTT.getZoneIdName()));
    }

    public static ZonedDateTime getZonedDateTimeNowOfParis() {
        return ZonedDateTime.now(ZoneId.of(ZoneIdEnum.ECT.getZoneIdName()));
    }

    public static ZonedDateTime getZonedDateTimeNowOfEST() {
        return ZonedDateTime.now(ZoneId.of(ZoneIdEnum.EST.getZoneIdName()));
    }

    public static ZonedDateTime getZonedDateTimeNowOfTokyo() {
        return ZonedDateTime.now(ZoneId.of(ZoneIdEnum.JST.getZoneIdName()));
    }

    public static Temporal plus(Temporal temporal, TemporalUnit unit, long amountToAdd) {
        Objects.requireNonNull(temporal, "temporal");
        return temporal.plus(amountToAdd, unit);
    }

    public static Date plus(Date date, TemporalUnit unit, long amountToAdd) {
        return DateTimeConverterUtil.toDate(DateTimeConverterUtil.toLocalDateTime(date).plus(amountToAdd, unit));
    }

    public static Temporal minus(Temporal temporal, TemporalUnit unit, long amountToSubtract) {
        Objects.requireNonNull(temporal, "temporal");
        return temporal.minus(amountToSubtract, unit);
    }

    public static Date minus(Date date, TemporalUnit unit, long amountToSubtract) {
        return DateTimeConverterUtil.toDate(DateTimeConverterUtil.toLocalDateTime(date).minus(amountToSubtract, unit));
    }

    public static Temporal with(Temporal temporal, TemporalField field, long newValue) {
        Objects.requireNonNull(temporal, "temporal");
        return temporal.with(field, newValue);
    }

    public static Date with(Date date, TemporalField field, long newValue) {
        return DateTimeConverterUtil.toDate(DateTimeConverterUtil.toLocalDateTime(date).with(field, newValue));
    }

    public static Duration durationBetween(Temporal startInclusive, Temporal endExclusive) {
        return Duration.between(startInclusive, endExclusive);
    }

    public static Period periodBetween(LocalDate startDateInclusive, LocalDate endDateExclusive) {
        return Period.between(startDateInclusive, endDateExclusive);
    }

    public static ZonedDateTime getZonedDateTimeNow(String zoneId) {
        Objects.requireNonNull(zoneId, "zoneId");
        return ZonedDateTime.now(ZoneId.of(zoneId));
    }

    public static ZonedDateTime transform(ZonedDateTime zonedDateTime, String zoneId) {
        Objects.requireNonNull(zoneId, "zoneId");
        return DateTimeCalculatorUtil.transform(zonedDateTime, ZoneId.of(zoneId));
    }

    public static ZonedDateTime transform(ZonedDateTime zonedDateTime, ZoneId zone) {
        Objects.requireNonNull(zonedDateTime, "zonedDateTime");
        Objects.requireNonNull(zone, "zone");
        return zonedDateTime.withZoneSameInstant(zone);
    }

    public static String transform(Date date, String zoneId) {
        Objects.requireNonNull(zoneId, "zoneId");
        return DateTimeCalculatorUtil.transform(date, ZoneId.of(zoneId));
    }

    public static String transform(Date date, ZoneId zone) {
        Objects.requireNonNull(zone, "zone");
        return DateTimeFormatterUtil.formatToDateTimeStr(date, zone.toString());
    }

    public static int compare(Date date1, Date date2) {
        return DateTimeCalculatorUtil.compare(DateTimeConverterUtil.toLocalDateTime(date1), DateTimeConverterUtil.toLocalDateTime(date2));
    }

    public static int compare(Temporal temporal1, Temporal temporal2) {
        Objects.requireNonNull(temporal1, "temporal1");
        Objects.requireNonNull(temporal2, "temporal2");
        if (temporal1 instanceof LocalDateTime && temporal2 instanceof LocalDateTime) {
            LocalDateTime localDateTimeA = (LocalDateTime)temporal1;
            LocalDateTime localDateTimeB = (LocalDateTime)temporal2;
            return localDateTimeA.compareTo(localDateTimeB);
        }
        if (temporal1 instanceof LocalDate && temporal2 instanceof LocalDate) {
            LocalDate localDateA = (LocalDate)temporal1;
            LocalDate localDateB = (LocalDate)temporal2;
            return localDateA.compareTo(localDateB);
        }
        if (temporal1 instanceof LocalTime && temporal2 instanceof LocalTime) {
            LocalTime localTimeA = (LocalTime)temporal1;
            LocalTime localTimeB = (LocalTime)temporal2;
            return localTimeA.compareTo(localTimeB);
        }
        if (temporal1 instanceof Instant && temporal2 instanceof Instant) {
            Instant instantA = (Instant)temporal1;
            Instant instantB = (Instant)temporal2;
            return instantA.compareTo(instantB);
        }
        throw new DateTimeException("Unsupported Temporal, must be LocalDateTime,LocalDate,LocalTime,Instant");
    }

    public static LocalTime startTimeOfDay() {
        return LocalTime.of(0, 0, 0);
    }

    public static LocalTime endTimeOfDay() {
        return LocalTime.of(23, 59, 59);
    }

    public static Date startTimeOfYesterday() {
        return DateTimeConverterUtil.toDate(LocalDate.now().minusDays(1L).atTime(DateTimeCalculatorUtil.startTimeOfDay()));
    }

    public static Date endTimeOfYesterday() {
        return DateTimeConverterUtil.toDate(LocalDate.now().minusDays(1L).atTime(DateTimeCalculatorUtil.endTimeOfDay()));
    }

    public static Date startTimeOfTomorrow() {
        return DateTimeConverterUtil.toDate(LocalDate.now().plusDays(1L).atTime(DateTimeCalculatorUtil.startTimeOfDay()));
    }

    public static Date endTimeOfTomorrow() {
        return DateTimeConverterUtil.toDate(LocalDate.now().plusDays(1L).atTime(DateTimeCalculatorUtil.endTimeOfDay()));
    }

    public static Date startTimeOfToday() {
        return DateTimeConverterUtil.toDate(LocalDate.now().atTime(DateTimeCalculatorUtil.startTimeOfDay()));
    }

    public static Date endTimeOfToday() {
        return DateTimeConverterUtil.toDate(LocalDate.now().atTime(DateTimeCalculatorUtil.endTimeOfDay()));
    }

    public static Date startTimeOfLastMonth() {
        return DateTimeConverterUtil.toDate(DateTimeCalculatorUtil.firstDayOfMonth(LocalDate.now().minusMonths(1L)).atTime(DateTimeCalculatorUtil.startTimeOfDay()));
    }

    public static Date endTimeOfLastMonth() {
        return DateTimeConverterUtil.toDate(DateTimeCalculatorUtil.lastDayOfMonth(LocalDate.now().minusMonths(1L)).atTime(DateTimeCalculatorUtil.endTimeOfDay()));
    }

    public static Date startTimeOfMonth() {
        return DateTimeConverterUtil.toDate(DateTimeCalculatorUtil.firstDayOfMonth(LocalDate.now()).atTime(DateTimeCalculatorUtil.startTimeOfDay()));
    }

    public static Date endTimeOfMonth() {
        return DateTimeConverterUtil.toDate(DateTimeCalculatorUtil.lastDayOfMonth(LocalDate.now()).atTime(DateTimeCalculatorUtil.endTimeOfDay()));
    }

    public static Date startTimeOfDate(Date date) {
        return DateTimeConverterUtil.toDate(DateTimeConverterUtil.toLocalDate(date).atTime(DateTimeCalculatorUtil.startTimeOfDay()));
    }

    public static Date endTimeOfDate(Date date) {
        return DateTimeConverterUtil.toDate(DateTimeConverterUtil.toLocalDate(date).atTime(DateTimeCalculatorUtil.endTimeOfDay()));
    }

    public static Date startTimeOfSpecialMonth(int year, int month) {
        return DateTimeConverterUtil.toDate(LocalDate.of(year, month, 1).atTime(DateTimeCalculatorUtil.startTimeOfDay()));
    }

    public static Date endTimeOfSpecialMonth(int year, int month) {
        return DateTimeConverterUtil.toDate(DateTimeCalculatorUtil.lastDayOfMonth(LocalDate.of(year, month, 1)).atTime(DateTimeCalculatorUtil.endTimeOfDay()));
    }

    public static Date startTimeOfDate(int year, int month, int dayOfMonth) {
        return DateTimeConverterUtil.toDate(LocalDate.of(year, month, dayOfMonth).atTime(DateTimeCalculatorUtil.startTimeOfDay()));
    }

    public static Date endTimeOfDate(int year, int month, int dayOfMonth) {
        return DateTimeConverterUtil.toDate(LocalDate.of(year, month, dayOfMonth).atTime(DateTimeCalculatorUtil.endTimeOfDay()));
    }

    public static boolean isSameMonthDay(LocalDate localDate1, MonthDay monthDay) {
        Objects.requireNonNull(localDate1, "localDate1");
        Objects.requireNonNull(monthDay, "monthDay");
        return MonthDay.of(localDate1.getMonthValue(), localDate1.getDayOfMonth()).equals(monthDay);
    }

    public static boolean isSameMonthDay(LocalDate localDate1, String monthDayStr) {
        Objects.requireNonNull(monthDayStr, "monthDayStr");
        return DateTimeCalculatorUtil.isSameMonthDay(localDate1, MonthDay.parse("--" + monthDayStr));
    }

    public static boolean isSameMonthDay(LocalDate localDate1, LocalDate localDate2) {
        Objects.requireNonNull(localDate2, "localDate2");
        return DateTimeCalculatorUtil.isSameMonthDay(localDate1, MonthDay.of(localDate2.getMonthValue(), localDate2.getDayOfMonth()));
    }

    public static boolean isSameMonthDay(Date date, String monthDayStr) {
        return DateTimeCalculatorUtil.isSameMonthDay(DateTimeConverterUtil.toLocalDate(date), monthDayStr);
    }

    public static boolean isSameMonthDay(Date date1, Date date2) {
        Objects.requireNonNull(date1, "date1");
        Objects.requireNonNull(date2, "date2");
        return DateTimeCalculatorUtil.isSameMonthDay(DateTimeConverterUtil.toLocalDate(date1), DateTimeConverterUtil.toLocalDate(date2));
    }

    public static boolean isSameMonthDayOfNow(String monthDayStr) {
        return DateTimeCalculatorUtil.isSameMonthDay(LocalDate.now(), monthDayStr);
    }

    public static long betweenNextSameMonthDay(LocalDate localDate1, int month, int dayOfMonth) {
        Objects.requireNonNull(localDate1, "localDate1");
        MonthDay monthDay1 = MonthDay.of(localDate1.getMonthValue(), localDate1.getDayOfMonth());
        MonthDay monthDay2 = MonthDay.of(month, dayOfMonth);
        if (monthDay1.compareTo(monthDay2) == -1) {
            return DateTimeCalculatorUtil.betweenTotalDays(localDate1.atStartOfDay(), localDate1.withMonth(month).withDayOfMonth(dayOfMonth).atStartOfDay());
        }
        MonthDay leapMonthDay = MonthDay.of(2, 29);
        if (leapMonthDay.equals(monthDay2)) {
            LocalDate nextLeapYear = DateTimeCalculatorUtil.nextLeapYear(localDate1);
            return DateTimeCalculatorUtil.betweenTotalDays(localDate1.atStartOfDay(), nextLeapYear.withMonth(month).withDayOfMonth(dayOfMonth).atStartOfDay());
        }
        LocalDate next = localDate1.plusYears(1L);
        return DateTimeCalculatorUtil.betweenTotalDays(localDate1.atStartOfDay(), next.withMonth(month).withDayOfMonth(dayOfMonth).atStartOfDay());
    }

    public static long betweenNextSameMonthDay(LocalDate localDate, String monthDayStr) {
        Objects.requireNonNull(monthDayStr, "monthDayStr");
        MonthDay monthDay2 = MonthDay.parse("--" + monthDayStr);
        return DateTimeCalculatorUtil.betweenNextSameMonthDay(localDate, monthDay2.getMonthValue(), monthDay2.getDayOfMonth());
    }

    public static long betweenNextSameMonthDay(Date date, String monthDayStr) {
        Objects.requireNonNull(monthDayStr, "monthDayStr");
        MonthDay monthDay2 = MonthDay.parse("--" + monthDayStr);
        return DateTimeCalculatorUtil.betweenNextSameMonthDay(DateTimeConverterUtil.toLocalDate(date), monthDay2.getMonthValue(), monthDay2.getDayOfMonth());
    }

    public static long betweenNextSameMonthDayOfNow(String monthDayStr) {
        Objects.requireNonNull(monthDayStr, "monthDayStr");
        MonthDay monthDay2 = MonthDay.parse("--" + monthDayStr);
        return DateTimeCalculatorUtil.betweenNextSameMonthDay(LocalDate.now(), monthDay2.getMonthValue(), monthDay2.getDayOfMonth());
    }

    public static LocalDate nextSameMonthDay(LocalDate localDate, String monthDayStr) {
        return localDate.plusDays(DateTimeCalculatorUtil.betweenNextSameMonthDay(localDate, monthDayStr));
    }

    public static Date nextSameMonthDay(Date date, String monthDayStr) {
        return DateTimeConverterUtil.toDate(DateTimeCalculatorUtil.nextSameMonthDay(DateTimeConverterUtil.toLocalDate(date), monthDayStr));
    }

    public static Date nextSameMonthDayOfNow(String monthDayStr) {
        return DateTimeCalculatorUtil.nextSameMonthDay(new Date(), monthDayStr);
    }

    public static String getConstellationNameCn(String monthDayStr) {
        return ConstellationNameEnum.getNameCnByMonthDay(monthDayStr);
    }

    public static String getConstellationNameCn(Date date) {
        String monthDayStr = DateTimeFormatterUtil.format(date, DateTimeFormatterUtil.MM_DD_FMT);
        return ConstellationNameEnum.getNameCnByMonthDay(monthDayStr);
    }

    public static String getConstellationNameEn(String monthDayStr) {
        return ConstellationNameEnum.getNameEnByMonthDay(monthDayStr);
    }

    public static List<LocalDateTime> getLocalDateTimeList(LocalDateTime startInclusive, LocalDateTime endInclusive) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endInclusive, "endInclusive");
        if (startInclusive.isAfter(endInclusive)) {
            throw new DateTimeException("startInclusive must before or equal endInclusive!");
        }
        ArrayList<LocalDateTime> localDateTimeList = new ArrayList<LocalDateTime>();
        long days = DateTimeCalculatorUtil.betweenTotalDays(startInclusive, endInclusive) + 1L;
        for (long i = 0L; i < days; ++i) {
            localDateTimeList.add(startInclusive.plusDays(i));
        }
        return localDateTimeList;
    }

    public static List<LocalDate> getLocalDateList(LocalDate startInclusive, LocalDate endInclusive) {
        return DateTimeCalculatorUtil.getLocalDateTimeList(DateTimeConverterUtil.toLocalDateTime(startInclusive), DateTimeConverterUtil.toLocalDateTime(endInclusive)).stream().map(localDateTime -> localDateTime.toLocalDate()).collect(Collectors.toList());
    }

    public static List<Date> getDateList(Date startInclusive, Date endInclusive) {
        return DateTimeCalculatorUtil.getLocalDateTimeList(DateTimeConverterUtil.toLocalDateTime(startInclusive), DateTimeConverterUtil.toLocalDateTime(endInclusive)).stream().map(localDateTime -> DateTimeConverterUtil.toDate(localDateTime)).collect(Collectors.toList());
    }

    public static List<LocalDate> getLocalDateList(YearMonth yearMonth) {
        Objects.requireNonNull(yearMonth, "yearMonth");
        ArrayList<LocalDate> localDateList = new ArrayList<LocalDate>();
        long days = yearMonth.lengthOfMonth();
        LocalDate localDate = DateTimeConverterUtil.toLocalDateStartOfMonth(yearMonth);
        for (long i = 0L; i < days; ++i) {
            localDateList.add(DateTimeCalculatorUtil.plusDays(localDate, i));
        }
        return localDateList;
    }

    public static List<LocalDate> getLocalDateList(String yearMonthStr) {
        Objects.requireNonNull(yearMonthStr, "yearMonthStr");
        YearMonth yearMonth = YearMonth.parse(yearMonthStr);
        return DateTimeCalculatorUtil.getLocalDateList(yearMonth);
    }

    public static List<LocalDate> getLocalDateList(int year, int month) {
        YearMonth yearMonth = YearMonth.of(year, month);
        return DateTimeCalculatorUtil.getLocalDateList(yearMonth);
    }

    public static List<LocalDateTime> getLocalDateTimeList(YearMonth yearMonth) {
        return DateTimeCalculatorUtil.getLocalDateList(yearMonth).stream().map(localDate -> DateTimeConverterUtil.toLocalDateTime(localDate)).collect(Collectors.toList());
    }

    public static List<LocalDateTime> getLocalDateTimeList(String yearMonthStr) {
        return DateTimeCalculatorUtil.getLocalDateList(yearMonthStr).stream().map(localDate -> DateTimeConverterUtil.toLocalDateTime(localDate)).collect(Collectors.toList());
    }

    public static List<LocalDateTime> getLocalDateTimeList(int year, int month) {
        return DateTimeCalculatorUtil.getLocalDateList(YearMonth.of(year, month)).stream().map(localDate -> DateTimeConverterUtil.toLocalDateTime(localDate)).collect(Collectors.toList());
    }

    public static List<Date> getDateList(String yearMonthStr) {
        return DateTimeCalculatorUtil.getLocalDateList(yearMonthStr).stream().map(localDate -> DateTimeConverterUtil.toDate(localDate)).collect(Collectors.toList());
    }

    public static List<Date> getDateList(int year, int month) {
        return DateTimeCalculatorUtil.getLocalDateList(YearMonth.of(year, month)).stream().map(localDate -> DateTimeConverterUtil.toDate(localDate)).collect(Collectors.toList());
    }

    public static boolean isExpiry(YearMonth yearMonth) {
        Objects.requireNonNull(yearMonth, "yearMonth");
        return yearMonth.isBefore(YearMonth.now());
    }

    public static boolean isExpiry(String yearMonthStr) {
        Objects.requireNonNull(yearMonthStr, "yearMonthStr");
        YearMonth yearMonth = YearMonth.parse(yearMonthStr);
        return DateTimeCalculatorUtil.isExpiry(yearMonth);
    }

    public static boolean isBirthDay(LocalDate birthDay) {
        Objects.requireNonNull(birthDay, "birthDay");
        return DateTimeCalculatorUtil.isSameMonthDay(birthDay, LocalDate.now());
    }

    public static boolean isBirthDay(Date birthDay) {
        Objects.requireNonNull(birthDay, "birthDay");
        return DateTimeCalculatorUtil.isBirthDay(DateTimeConverterUtil.toLocalDate(birthDay));
    }

    public static boolean isBirthDay(LocalDateTime birthDay) {
        Objects.requireNonNull(birthDay, "birthDay");
        return DateTimeCalculatorUtil.isBirthDay(DateTimeConverterUtil.toLocalDate(birthDay));
    }

    public static LocalDateTime reduceAccuracyToSecond(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return LocalDateTime.of(localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond());
    }

    public static Date reduceAccuracyToSecond(Date date) {
        Objects.requireNonNull(date, "date");
        return DateTimeConverterUtil.toDate(DateTimeCalculatorUtil.reduceAccuracyToSecond(DateTimeConverterUtil.toLocalDateTime(date)));
    }

    public static LocalDateTime reduceAccuracyToMinute(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return LocalDateTime.of(localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), 0);
    }

    public static Date reduceAccuracyToMinute(Date date) {
        Objects.requireNonNull(date, "date");
        return DateTimeConverterUtil.toDate(DateTimeCalculatorUtil.reduceAccuracyToMinute(DateTimeConverterUtil.toLocalDateTime(date)));
    }

    public static LocalDateTime reduceAccuracyToHour(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return LocalDateTime.of(localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth(), localDateTime.getHour(), 0, 0);
    }

    public static Date reduceAccuracyToHour(Date date) {
        Objects.requireNonNull(date, "date");
        return DateTimeConverterUtil.toDate(DateTimeCalculatorUtil.reduceAccuracyToHour(DateTimeConverterUtil.toLocalDateTime(date)));
    }

    public static LocalDateTime reduceAccuracyToDay(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return LocalDateTime.of(localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth(), 0, 0, 0);
    }

    public static Date reduceAccuracyToDay(Date date) {
        Objects.requireNonNull(date, "date");
        return DateTimeConverterUtil.toDate(DateTimeCalculatorUtil.reduceAccuracyToDay(DateTimeConverterUtil.toLocalDateTime(date)));
    }

    public static int weekOfMonth(LocalDate localDate, Locale locale) {
        Objects.requireNonNull(localDate, "localDate");
        WeekFields weekFields = locale == null ? WeekFields.of(Locale.getDefault()) : WeekFields.of(locale);
        return (int)weekFields.weekOfMonth().getFrom(localDate);
    }

    public static int weekOfMonth(LocalDate localDate) {
        return DateTimeCalculatorUtil.weekOfMonth(localDate, null);
    }

    public static int weekOfMonth(LocalDateTime localDateTime) {
        return DateTimeCalculatorUtil.weekOfMonth(DateTimeConverterUtil.toLocalDate(localDateTime), null);
    }

    public static int weekOfMonth(Date date) {
        return DateTimeCalculatorUtil.weekOfMonth(DateTimeConverterUtil.toLocalDate(date), null);
    }

    public static int weekOfMonth() {
        return DateTimeCalculatorUtil.weekOfMonth(LocalDate.now());
    }

    public static int weekOfYear(LocalDate localDate, Locale locale) {
        Objects.requireNonNull(localDate, "localDate");
        WeekFields weekFields = locale == null ? WeekFields.of(Locale.getDefault()) : WeekFields.of(locale);
        return (int)weekFields.weekOfYear().getFrom(localDate);
    }

    public static int weekOfYear(LocalDate localDate) {
        return DateTimeCalculatorUtil.weekOfYear(localDate, null);
    }

    public static int weekOfYear(LocalDateTime localDateTime) {
        return DateTimeCalculatorUtil.weekOfYear(DateTimeConverterUtil.toLocalDate(localDateTime), null);
    }

    public static int weekOfYear(Date date) {
        return DateTimeCalculatorUtil.weekOfYear(DateTimeConverterUtil.toLocalDate(date), null);
    }

    public static int weekOfYear() {
        return DateTimeCalculatorUtil.weekOfYear(LocalDate.now());
    }

    public static boolean isMonday(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return WeekNameEnum.Mon.getCode() == localDate.getDayOfWeek().getValue();
    }

    public static boolean isMonday(Date date) {
        return DateTimeCalculatorUtil.isMonday(DateTimeConverterUtil.toLocalDate(date));
    }

    public static boolean isZhouYi(LocalDate localDate) {
        return DateTimeCalculatorUtil.isMonday(localDate);
    }

    public static boolean isZhouYi(Date date) {
        return DateTimeCalculatorUtil.isMonday(DateTimeConverterUtil.toLocalDate(date));
    }

    public static boolean isFriday(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return WeekNameEnum.Fri.getCode() == localDate.getDayOfWeek().getValue();
    }

    public static boolean isFriday(Date date) {
        return DateTimeCalculatorUtil.isFriday(DateTimeConverterUtil.toLocalDate(date));
    }

    public static boolean isZhouWu(LocalDate localDate) {
        return DateTimeCalculatorUtil.isFriday(localDate);
    }

    public static boolean isZhouWu(Date date) {
        return DateTimeCalculatorUtil.isFriday(DateTimeConverterUtil.toLocalDate(date));
    }

    public static String getTwelveTwo(LocalTime localTime) {
        return TwelveTwoEnum.getNameCn(localTime);
    }

    public static String getTwelveTwo(LocalDateTime localDateTime) {
        return TwelveTwoEnum.getNameCn(DateTimeConverterUtil.toLocalTime(localDateTime));
    }

    public static String getTwelveTwo(Date date) {
        return TwelveTwoEnum.getNameCn(date);
    }

    public static String getTwelveTwo() {
        return TwelveTwoEnum.getNameCn(LocalTime.now());
    }
}

