/*
 * Decompiled with CFR 0.152.
 */
package com.xkzhangsan.time.nlp;

import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextPreprocess {
    private TextPreprocess() {
    }

    public static String preprocess(String text) {
        text = text.trim();
        text = TextPreprocess.delKeyword(text, "[\u7684]+");
        text = TextPreprocess.delDecimalStr(text);
        text = TextPreprocess.numberTranslator(text);
        return text;
    }

    public static String delKeyword(String target, String rules) {
        Pattern p = Pattern.compile(rules);
        Matcher m = p.matcher(target);
        StringBuffer sb = new StringBuffer();
        boolean result = m.find();
        while (result) {
            m.appendReplacement(sb, "");
            result = m.find();
        }
        m.appendTail(sb);
        String s = sb.toString();
        return s;
    }

    public static String numberTranslator(String target) {
        int num;
        String[] s;
        String group;
        Pattern p = Pattern.compile("[\u4e00\u4e8c\u4e24\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d123456789]\u4e07[\u4e00\u4e8c\u4e24\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d123456789](?!(\u5343|\u767e|\u5341))");
        Matcher m = p.matcher(target);
        StringBuffer sb = new StringBuffer();
        boolean result = m.find();
        while (result) {
            group = m.group();
            s = group.split("\u4e07");
            num = 0;
            if (s.length == 2) {
                num += TextPreprocess.wordToNumber(s[0]) * 10000 + TextPreprocess.wordToNumber(s[1]) * 1000;
            }
            m.appendReplacement(sb, Integer.toString(num));
            result = m.find();
        }
        m.appendTail(sb);
        target = sb.toString();
        p = Pattern.compile("[\u4e00\u4e8c\u4e24\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d123456789]\u5343[\u4e00\u4e8c\u4e24\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d123456789](?!(\u767e|\u5341))");
        m = p.matcher(target);
        sb = new StringBuffer();
        result = m.find();
        while (result) {
            group = m.group();
            s = group.split("\u5343");
            num = 0;
            if (s.length == 2) {
                num += TextPreprocess.wordToNumber(s[0]) * 1000 + TextPreprocess.wordToNumber(s[1]) * 100;
            }
            m.appendReplacement(sb, Integer.toString(num));
            result = m.find();
        }
        m.appendTail(sb);
        target = sb.toString();
        p = Pattern.compile("[\u4e00\u4e8c\u4e24\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d123456789]\u767e[\u4e00\u4e8c\u4e24\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d123456789](?!\u5341)");
        m = p.matcher(target);
        sb = new StringBuffer();
        result = m.find();
        while (result) {
            group = m.group();
            s = group.split("\u767e");
            num = 0;
            if (s.length == 2) {
                num += TextPreprocess.wordToNumber(s[0]) * 100 + TextPreprocess.wordToNumber(s[1]) * 10;
            }
            m.appendReplacement(sb, Integer.toString(num));
            result = m.find();
        }
        m.appendTail(sb);
        target = sb.toString();
        p = Pattern.compile("[\u96f6\u4e00\u4e8c\u4e24\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d]");
        m = p.matcher(target);
        sb = new StringBuffer();
        result = m.find();
        while (result) {
            m.appendReplacement(sb, Integer.toString(TextPreprocess.wordToNumber(m.group())));
            result = m.find();
        }
        m.appendTail(sb);
        target = sb.toString();
        p = Pattern.compile("(?<=(\u5468|\u661f\u671f))[\u672b\u5929\u65e5]");
        m = p.matcher(target);
        sb = new StringBuffer();
        result = m.find();
        while (result) {
            m.appendReplacement(sb, Integer.toString(TextPreprocess.wordToNumber(m.group())));
            result = m.find();
        }
        m.appendTail(sb);
        target = sb.toString();
        p = Pattern.compile("(?<!(\u5468|\u661f\u671f))0?[0-9]?\u5341[0-9]?");
        m = p.matcher(target);
        sb = new StringBuffer();
        result = m.find();
        while (result) {
            int ten;
            group = m.group();
            s = group.split("\u5341");
            num = 0;
            if (s.length == 0) {
                num += 10;
            } else if (s.length == 1) {
                ten = Integer.parseInt(s[0]);
                num = ten == 0 ? (num += 10) : (num += ten * 10);
            } else if (s.length == 2) {
                num = s[0].equals("") ? (num += 10) : ((ten = Integer.parseInt(s[0])) == 0 ? (num += 10) : (num += ten * 10));
                num += Integer.parseInt(s[1]);
            }
            m.appendReplacement(sb, Integer.toString(num));
            result = m.find();
        }
        m.appendTail(sb);
        target = sb.toString();
        p = Pattern.compile("0?[1-9]\u767e[0-9]?[0-9]?");
        m = p.matcher(target);
        sb = new StringBuffer();
        result = m.find();
        while (result) {
            int hundred;
            group = m.group();
            s = group.split("\u767e");
            num = 0;
            if (s.length == 1) {
                hundred = Integer.parseInt(s[0]);
                num += hundred * 100;
            } else if (s.length == 2) {
                hundred = Integer.parseInt(s[0]);
                num += hundred * 100;
                num += Integer.parseInt(s[1]);
            }
            m.appendReplacement(sb, Integer.toString(num));
            result = m.find();
        }
        m.appendTail(sb);
        target = sb.toString();
        p = Pattern.compile("0?[1-9]\u5343[0-9]?[0-9]?[0-9]?");
        m = p.matcher(target);
        sb = new StringBuffer();
        result = m.find();
        while (result) {
            int thousand;
            group = m.group();
            s = group.split("\u5343");
            num = 0;
            if (s.length == 1) {
                thousand = Integer.parseInt(s[0]);
                num += thousand * 1000;
            } else if (s.length == 2) {
                thousand = Integer.parseInt(s[0]);
                num += thousand * 1000;
                num += Integer.parseInt(s[1]);
            }
            m.appendReplacement(sb, Integer.toString(num));
            result = m.find();
        }
        m.appendTail(sb);
        target = sb.toString();
        p = Pattern.compile("[0-9]+\u4e07[0-9]?[0-9]?[0-9]?[0-9]?");
        m = p.matcher(target);
        sb = new StringBuffer();
        result = m.find();
        while (result) {
            int tenthousand;
            group = m.group();
            s = group.split("\u4e07");
            num = 0;
            if (s.length == 1) {
                tenthousand = Integer.parseInt(s[0]);
                num += tenthousand * 10000;
            } else if (s.length == 2) {
                tenthousand = Integer.parseInt(s[0]);
                num += tenthousand * 10000;
                num += Integer.parseInt(s[1]);
            }
            m.appendReplacement(sb, Integer.toString(num));
            result = m.find();
        }
        m.appendTail(sb);
        target = sb.toString();
        return target;
    }

    private static int wordToNumber(String s) {
        if (s.equals("\u96f6") || s.equals("0")) {
            return 0;
        }
        if (s.equals("\u4e00") || s.equals("1")) {
            return 1;
        }
        if (s.equals("\u4e8c") || s.equals("\u4e24") || s.equals("2")) {
            return 2;
        }
        if (s.equals("\u4e09") || s.equals("3")) {
            return 3;
        }
        if (s.equals("\u56db") || s.equals("4")) {
            return 4;
        }
        if (s.equals("\u4e94") || s.equals("5")) {
            return 5;
        }
        if (s.equals("\u516d") || s.equals("6")) {
            return 6;
        }
        if (s.equals("\u4e03") || s.equals("\u5929") || s.equals("\u65e5") || s.equals("\u672b") || s.equals("7")) {
            return 7;
        }
        if (s.equals("\u516b") || s.equals("8")) {
            return 8;
        }
        if (s.equals("\u4e5d") || s.equals("9")) {
            return 9;
        }
        return -1;
    }

    private static String delDecimalStr(String target) {
        String dateFlagRule = "[\u65e5\u53f7]";
        Pattern dateFlagPattern = Pattern.compile(dateFlagRule);
        Matcher dateFlagMatcher = dateFlagPattern.matcher(target);
        HashSet<Integer> dateFlagSet = new HashSet<Integer>();
        while (dateFlagMatcher.find()) {
            dateFlagSet.add(dateFlagMatcher.start());
        }
        String rule = "{0,1}\\d+\\.\\d*|{0,1}\\d*\\.\\d+";
        Pattern p = Pattern.compile(rule);
        Matcher m = p.matcher(target);
        StringBuffer sb = new StringBuffer();
        boolean result = m.find();
        while (result) {
            if (!dateFlagSet.contains(m.end())) {
                m.appendReplacement(sb, "");
            }
            result = m.find();
        }
        m.appendTail(sb);
        return sb.toString();
    }
}

