/*
 * Decompiled with CFR 0.152.
 */
package com.xkzhangsan.time.formatter;

import com.xkzhangsan.time.calculator.DateTimeCalculatorUtil;
import com.xkzhangsan.time.converter.DateTimeConverterUtil;
import com.xkzhangsan.time.enums.CommonTimeEnum;
import com.xkzhangsan.time.enums.ZoneIdEnum;
import com.xkzhangsan.time.formatter.DateFormatPattern;
import com.xkzhangsan.time.utils.ArrayUtil;
import com.xkzhangsan.time.utils.CollectionUtil;
import com.xkzhangsan.time.utils.StringUtil;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class DateTimeFormatterUtil {
    private static final ZoneId ZONE = ZoneId.systemDefault();
    public static final String SHANGHAI_ZONE_ID = ZoneIdEnum.CTT.getZoneIdName();
    public static final ZoneId SHANGHAI_ZONE = ZoneId.of(SHANGHAI_ZONE_ID);
    public static final DateTimeFormatter YYYY_MM_DD_FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd").withZone(ZONE);
    public static final DateTimeFormatter YYYY_M_D_FMT = DateTimeFormatter.ofPattern("yyyy-M-d").withZone(ZONE);
    public static final DateTimeFormatter YYYYMMDD_FMT = DateTimeFormatter.ofPattern("yyyyMMdd").withZone(ZONE);
    public static final DateTimeFormatter YYYY_MM_DD_EN_FMT = DateTimeFormatter.ofPattern("yyyy/MM/dd").withZone(ZONE);
    public static final DateTimeFormatter YYYY_M_D_EN_FMT = DateTimeFormatter.ofPattern("yyyy/M/d").withZone(ZONE);
    public static final DateTimeFormatter YYYY_MM_DD_CN_FMT = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5").withZone(ZONE);
    public static final DateTimeFormatter YYYY_M_D_CN_FMT = DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708d\u65e5").withZone(ZONE);
    public static final DateTimeFormatter YYYY_MM_DD_POINT_FMT = DateTimeFormatter.ofPattern("yyyy.MM.dd").withZone(ZONE);
    public static final DateTimeFormatter YYYY_M_D_POINT_FMT = DateTimeFormatter.ofPattern("yyyy.M.d").withZone(ZONE);
    public static final DateTimeFormatter YY_MM_DD_EN_FMT = DateTimeFormatter.ofPattern("yy/MM/dd").withZone(ZONE);
    public static final DateTimeFormatter YY_M_D_EN_FMT = DateTimeFormatter.ofPattern("yy/M/d").withZone(ZONE);
    public static final DateTimeFormatter MM_DD_YY_EN_FMT = DateTimeFormatter.ofPattern("MM/dd/yy").withZone(ZONE);
    public static final DateTimeFormatter M_D_YY_EN_FMT = DateTimeFormatter.ofPattern("M/d/yy").withZone(ZONE);
    public static final DateTimeFormatter YYYY_MM_DD_E_FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd E").withZone(ZONE);
    public static final DateTimeFormatter YY_FMT = DateTimeFormatter.ofPattern("yy").withZone(ZONE);
    public static final DateTimeFormatter YYYY_FMT = DateTimeFormatter.ofPattern("yyyy").withZone(ZONE);
    public static final DateTimeFormatter YYYY_MM_FMT = DateTimeFormatter.ofPattern("yyyy-MM").withZone(ZONE);
    public static final DateTimeFormatter YYYYMM_FMT = DateTimeFormatter.ofPattern("yyyyMM").withZone(ZONE);
    public static final DateTimeFormatter YYYY_MM_EN_FMT = DateTimeFormatter.ofPattern("yyyy/MM").withZone(ZONE);
    public static final DateTimeFormatter YYYY_MM_CN_FMT = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708").withZone(ZONE);
    public static final DateTimeFormatter YYYY_M_CN_FMT = DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708").withZone(ZONE);
    public static final DateTimeFormatter MM_DD_FMT = DateTimeFormatter.ofPattern("MM-dd").withZone(ZONE);
    public static final DateTimeFormatter MMDD_FMT = DateTimeFormatter.ofPattern("MMdd").withZone(ZONE);
    public static final DateTimeFormatter MM_DD_EN_FMT = DateTimeFormatter.ofPattern("MM/dd").withZone(ZONE);
    public static final DateTimeFormatter M_D_EN_FMT = DateTimeFormatter.ofPattern("M/d").withZone(ZONE);
    public static final DateTimeFormatter MM_DD_CN_FMT = DateTimeFormatter.ofPattern("MM\u6708dd\u65e5").withZone(ZONE);
    public static final DateTimeFormatter M_D_CN_FMT = DateTimeFormatter.ofPattern("M\u6708d\u65e5").withZone(ZONE);
    public static final DateTimeFormatter HH_MM_SS_FMT = DateTimeFormatter.ofPattern(DateFormatPattern.HH_MM_SS).withZone(ZONE);
    public static DateTimeFormatter H_M_S_FMT = DateTimeFormatter.ofPattern(DateFormatPattern.H_M_S).withZone(ZONE);
    public static final DateTimeFormatter HHMMSS_FMT = DateTimeFormatter.ofPattern(DateFormatPattern.HHMMSS).withZone(ZONE);
    public static DateTimeFormatter HH_MM_SS_CN_FMT = DateTimeFormatter.ofPattern(DateFormatPattern.HH_MM_SS_CN).withZone(ZONE);
    public static DateTimeFormatter HH_MM_FMT = DateTimeFormatter.ofPattern(DateFormatPattern.HH_MM).withZone(ZONE);
    public static DateTimeFormatter H_M_FMT = DateTimeFormatter.ofPattern(DateFormatPattern.H_M).withZone(ZONE);
    public static DateTimeFormatter HH_MM_CN_FMT = DateTimeFormatter.ofPattern(DateFormatPattern.HH_MM_CN).withZone(ZONE);
    public static DateTimeFormatter HH_MM_A_FMT = DateTimeFormatter.ofPattern(DateFormatPattern.HH_MM_A).withZone(ZONE);
    public static DateTimeFormatter HH_MM_A_AM_PM_FMT = DateTimeFormatter.ofPattern(DateFormatPattern.HH_MM_A, Locale.ENGLISH).withZone(ZONE);
    public static DateTimeFormatter HH_MM_SS_SSS_FMT = DateTimeFormatter.ofPattern(DateFormatPattern.HH_MM_SS_SSS).withZone(ZONE);
    public static DateTimeFormatter HH_MM_SS_SSSSSS_FMT = DateTimeFormatter.ofPattern(DateFormatPattern.HH_MM_SS_SSSSSS).withZone(ZONE);
    public static DateTimeFormatter HH_MM_SS_SSSSSSSSS_FMT = DateTimeFormatter.ofPattern(DateFormatPattern.HH_MM_SS_SSSSSSSSS).withZone(ZONE);
    public static final DateTimeFormatter YYYY_MM_DD_HH_MM_SS_FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZONE);
    public static final DateTimeFormatter YYYY_M_D_H_M_S_FMT = DateTimeFormatter.ofPattern("yyyy-M-d H:m:s").withZone(ZONE);
    public static final DateTimeFormatter YYYYMMDDHHMMSS_FMT = DateTimeFormatter.ofPattern("yyyyMMddHHmmss").withZone(ZONE);
    public static final DateTimeFormatter YYYY_MM_DD_HH_MM_SS_EN_FMT = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss").withZone(ZONE);
    public static final DateTimeFormatter YYYY_M_D_H_M_S_EN_FMT = DateTimeFormatter.ofPattern("yyyy/M/d H:m:s").withZone(ZONE);
    public static final DateTimeFormatter YYYY_MM_DD_HH_MM_SS_CN_FMT = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss").withZone(ZONE);
    public static final DateTimeFormatter YYYY_MM_DD_HH_MM_SS_CN_ALL_FMT = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2").withZone(ZONE);
    public static final DateTimeFormatter YYYY_MM_DD_HH_MM_FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm").withZone(ZONE);
    public static final DateTimeFormatter YYYY_M_D_H_M_FMT = DateTimeFormatter.ofPattern("yyyy-M-d H:m").withZone(ZONE);
    public static final DateTimeFormatter YYYYMMDDHHMM_FMT = DateTimeFormatter.ofPattern("yyyyMMddHHmm").withZone(ZONE);
    public static final DateTimeFormatter YYYY_MM_DD_HH_MM_EN_FMT = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm").withZone(ZONE);
    public static final DateTimeFormatter YYYY_M_D_H_M_EN_FMT = DateTimeFormatter.ofPattern("yyyy/M/d H:m").withZone(ZONE);
    public static final DateTimeFormatter YYYY_M_D_H_M_A_EN_FMT = DateTimeFormatter.ofPattern("yyyy/M/d h:m a").withZone(ZONE);
    public static final DateTimeFormatter YYYY_M_D_H_M_A_AM_PM_EN_FMT = DateTimeFormatter.ofPattern("yyyy/M/d h:m a", Locale.ENGLISH).withZone(ZONE);
    public static final DateTimeFormatter MM_DD_HH_MM_FMT = DateTimeFormatter.ofPattern("MM-dd HH:mm").withZone(ZONE);
    public static final DateTimeFormatter MM_DD_HH_MM_CN_FMT = DateTimeFormatter.ofPattern("MM\u6708dd\u65e5 HH:mm").withZone(ZONE);
    public static final DateTimeFormatter MM_DD_HH_MM_SS_FMT = DateTimeFormatter.ofPattern("MM-dd HH:mm:ss").withZone(ZONE);
    public static final DateTimeFormatter MM_DD_HH_MM_SS_CN_FMT = DateTimeFormatter.ofPattern("MM\u6708dd\u65e5 HH:mm:ss").withZone(ZONE);
    public static final DateTimeFormatter YYYY_MM_DD_HH_MM_SS_A_CN_FMT = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5 hh:mm:ss a").withZone(ZONE);
    public static final DateTimeFormatter YYYY_MM_DD_HH_MM_SS_A_AM_PM_CN_FMT = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5 hh:mm:ss a", Locale.ENGLISH).withZone(ZONE);
    public static final DateTimeFormatter YYYY_MM_DD_HH_MM_SS_A_CN_ALL_FMT = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5 hh\u65f6mm\u5206ss\u79d2 a").withZone(ZONE);
    public static final DateTimeFormatter YYYY_MM_DD_HH_MM_SS_A_AM_PM_CN_ALL_FMT = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5 hh\u65f6mm\u5206ss\u79d2 a", Locale.ENGLISH).withZone(ZONE);
    public static final DateTimeFormatter YYYY_MM_DD_HH_MM_SS_SSS_FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS").withZone(ZONE);
    public static final DateTimeFormatter YYYY_MM_DD_HH_MM_SS_SSS_COMMA_FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss,SSS").withZone(ZONE);
    public static final DateTimeFormatter YYYYMMDDHHMMSSSSS_FMT = new DateTimeFormatterBuilder().appendPattern("yyyyMMddHHmmss").appendValue(ChronoField.MILLI_OF_SECOND, 3).toFormatter().withZone(ZONE);
    public static final DateTimeFormatter YYYY_M_D_H_M_S_SSS_FMT = DateTimeFormatter.ofPattern("yyyy-M-d H:m:s.SSS").withZone(ZONE);
    public static final DateTimeFormatter YYYY_M_D_H_M_S_SSS_EN_FMT = DateTimeFormatter.ofPattern("yyyy/M/d H:m:s.SSS").withZone(ZONE);
    public static final DateTimeFormatter YYYY_M_D_H_M_S_SSS_COMMA_FMT = DateTimeFormatter.ofPattern("yyyy-M-d H:m:s,SSS").withZone(ZONE);
    public static final DateTimeFormatter YYYY_MM_DD_HH_MM_SS_SSSSSS_FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSS").withZone(ZONE);
    public static final DateTimeFormatter YYYY_MM_DD_HH_MM_SS_SSSSSSSSS_FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSSSSS").withZone(ZONE);
    public static final DateTimeFormatter YYYY_MM_DD_T_HH_MM_SS_Z_FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZ");
    public static final DateTimeFormatter YYYY_MM_DD_T_HH_MM_SS_XXX_FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssxxx");
    public static final DateTimeFormatter YYYY_MM_DD_T_HH_MM_SS_XXX_Z_FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssXXX");
    public static final DateTimeFormatter YYYY_MM_DD_T_HH_MM_SS_SSS_Z_FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    public static final DateTimeFormatter YYYY_MM_DD_T_HH_MM_SS_SSS_XXX_FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSxxx");
    public static final DateTimeFormatter YYYY_MM_DD_T_HH_MM_SS_SSS_XXX_Z_FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    public static final DateTimeFormatter YYYY_MM_DD_T_HH_MM_SS_SSSSSS_Z_FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSSZ");
    public static final DateTimeFormatter YYYY_MM_DD_T_HH_MM_SS_SSSSSS_XXX_FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSSxxx");
    public static final DateTimeFormatter YYYY_MM_DD_T_HH_MM_SS_SSSSSS_XXX_Z_FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSSXXX");
    public static final DateTimeFormatter YYYY_MM_DD_T_HH_MM_SS_SSSSSSSSS_Z_FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSSZ");
    public static final DateTimeFormatter YYYY_MM_DD_T_HH_MM_SS_SSSSSSSSS_XXX_FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSSxxx");
    public static final DateTimeFormatter YYYY_MM_DD_T_HH_MM_SS_SSSSSSSSS_XXX_Z_FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSSXXX");
    public static final DateTimeFormatter ISO_DATE_FMT = DateTimeFormatter.ISO_DATE;
    public static final DateTimeFormatter ISO_DATE_TIME_FMT = DateTimeFormatter.ISO_DATE_TIME;
    public static final DateTimeFormatter ISO_INSTANT_FMT = DateTimeFormatter.ISO_INSTANT;
    public static final DateTimeFormatter ISO_LOCAL_DATE_FMT = DateTimeFormatter.ISO_LOCAL_DATE;
    public static final DateTimeFormatter ISO_LOCAL_DATE_TIME_FMT = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
    public static final DateTimeFormatter ISO_LOCAL_TIME_FMT = DateTimeFormatter.ISO_LOCAL_TIME;
    public static final DateTimeFormatter ISO_TIME_FMT = DateTimeFormatter.ISO_TIME;
    public static final DateTimeFormatter ISO_WEEK_DATE_FMT = DateTimeFormatter.ISO_WEEK_DATE;
    public static final DateTimeFormatter ISO_ZONED_DATE_TIME_FMT = DateTimeFormatter.ISO_ZONED_DATE_TIME;
    public static final DateTimeFormatter BASIC_ISO_DATE_FMT = DateTimeFormatter.BASIC_ISO_DATE;
    public static final DateTimeFormatter EEE_MMM_DD_HH_MM_SS_ZZZ_YYYY_FMT = DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss zzz yyyy", Locale.ENGLISH);

    private DateTimeFormatterUtil() {
    }

    public static DateTimeFormatter getDateTimeFormatter(String dateFormatPattern) {
        return DateTimeFormatter.ofPattern(dateFormatPattern).withZone(ZONE);
    }

    public static String formatToDateStr(Date date) {
        return DateTimeConverterUtil.toLocalDateTime(date).format(YYYY_MM_DD_FMT);
    }

    public static String formatToDateStr(Date date, String zoneId) {
        return StringUtil.isNotEmpty(zoneId) ? DateTimeConverterUtil.toZonedDateTime(date).format(YYYY_MM_DD_FMT.withZone(ZoneId.of(zoneId))) : DateTimeConverterUtil.toZonedDateTime(date).format(YYYY_MM_DD_FMT.withZone(null));
    }

    public static String formatToDateStr(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.format(YYYY_MM_DD_FMT);
    }

    public static String formatToDateStr(LocalDateTime localDateTime, String zoneId) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return StringUtil.isNotEmpty(zoneId) ? localDateTime.format(YYYY_MM_DD_FMT.withZone(ZoneId.of(zoneId))) : localDateTime.format(YYYY_MM_DD_FMT.withZone(null));
    }

    public static String formatToDateStr(ZonedDateTime zonedDateTime) {
        Objects.requireNonNull(zonedDateTime, "zonedDateTime");
        return zonedDateTime.format(YYYY_MM_DD_FMT);
    }

    public static String formatToDateStr(ZonedDateTime zonedDateTime, String zoneId) {
        Objects.requireNonNull(zonedDateTime, "zonedDateTime");
        return StringUtil.isNotEmpty(zoneId) ? zonedDateTime.format(YYYY_MM_DD_FMT.withZone(ZoneId.of(zoneId))) : zonedDateTime.format(YYYY_MM_DD_FMT.withZone(null));
    }

    public static String formatToDateTimeStr(Date date) {
        return DateTimeConverterUtil.toZonedDateTime(date).format(YYYY_MM_DD_HH_MM_SS_FMT);
    }

    public static String formatToDateTimeStr(Date date, String zoneId) {
        return StringUtil.isNotEmpty(zoneId) ? DateTimeConverterUtil.toZonedDateTime(date).format(YYYY_MM_DD_HH_MM_SS_FMT.withZone(ZoneId.of(zoneId))) : DateTimeConverterUtil.toZonedDateTime(date).format(YYYY_MM_DD_HH_MM_SS_FMT.withZone(null));
    }

    public static String formatToDateTimeStr(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.format(YYYY_MM_DD_HH_MM_SS_FMT);
    }

    public static String formatToDateTimeStr(LocalDateTime localDateTime, String zoneId) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return StringUtil.isNotEmpty(zoneId) ? localDateTime.format(YYYY_MM_DD_HH_MM_SS_FMT.withZone(ZoneId.of(zoneId))) : localDateTime.format(YYYY_MM_DD_HH_MM_SS_FMT.withZone(null));
    }

    public static String formatToDateTimeStr(ZonedDateTime zonedDateTime) {
        Objects.requireNonNull(zonedDateTime, "zonedDateTime");
        return zonedDateTime.format(YYYY_MM_DD_HH_MM_SS_FMT);
    }

    public static String formatToDateTimeStr(ZonedDateTime zonedDateTime, String zoneId) {
        Objects.requireNonNull(zonedDateTime, "zonedDateTime");
        return StringUtil.isNotEmpty(zoneId) ? zonedDateTime.format(YYYY_MM_DD_HH_MM_SS_FMT.withZone(ZoneId.of(zoneId))) : zonedDateTime.format(YYYY_MM_DD_HH_MM_SS_FMT.withZone(null));
    }

    public static String formatToTimeStr(Date date) {
        return DateTimeConverterUtil.toLocalDateTime(date).format(HH_MM_SS_FMT);
    }

    public static String formatToTimeStr(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.format(HH_MM_SS_FMT);
    }

    public static String format(Date date, DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return DateTimeConverterUtil.toZonedDateTime(date).format(formatter);
    }

    public static String format(Date date, String dateFormatPattern) {
        Objects.requireNonNull(dateFormatPattern, "dateFormatPattern");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(dateFormatPattern).withZone(ZONE);
        return DateTimeFormatterUtil.format(date, formatter);
    }

    public static String format(Date date, DateTimeFormatter formatter, String zoneId) {
        Objects.requireNonNull(formatter, "formatter");
        if (StringUtil.isNotEmpty(zoneId)) {
            formatter.withZone(ZoneId.of(zoneId));
        } else {
            formatter.withZone(null);
        }
        return StringUtil.isNotEmpty(zoneId) ? DateTimeConverterUtil.toZonedDateTime(date).format(formatter.withZone(ZoneId.of(zoneId))) : DateTimeConverterUtil.toZonedDateTime(date).format(formatter.withZone(null));
    }

    public static String format(LocalDateTime localDateTime, DateTimeFormatter formatter) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        Objects.requireNonNull(formatter, "formatter");
        return DateTimeConverterUtil.toZonedDateTime(localDateTime).format(formatter);
    }

    public static String format(LocalDateTime localDateTime, String dateFormatPattern) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        Objects.requireNonNull(dateFormatPattern, "dateFormatPattern");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(dateFormatPattern).withZone(ZONE);
        return DateTimeFormatterUtil.format(localDateTime, formatter);
    }

    public static String format(LocalDateTime localDateTime, DateTimeFormatter formatter, String zoneId) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        Objects.requireNonNull(formatter, "formatter");
        return StringUtil.isNotEmpty(zoneId) ? DateTimeConverterUtil.toZonedDateTime(localDateTime).format(formatter.withZone(ZoneId.of(zoneId))) : DateTimeConverterUtil.toZonedDateTime(localDateTime).format(formatter.withZone(ZoneId.of(null)));
    }

    public static String format(LocalDate localDate, DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return DateTimeConverterUtil.toZonedDateTime(localDate).format(formatter);
    }

    public static String format(LocalTime localTime, DateTimeFormatter formatter) {
        Objects.requireNonNull(localTime, "localTime");
        Objects.requireNonNull(formatter, "formatter");
        return DateTimeConverterUtil.toZonedDateTime(localTime).format(formatter);
    }

    public static String format(Instant instant, DateTimeFormatter formatter) {
        Objects.requireNonNull(instant, "instant");
        Objects.requireNonNull(formatter, "formatter");
        return formatter.format(instant);
    }

    public static String format(ZonedDateTime zonedDateTime, DateTimeFormatter formatter) {
        Objects.requireNonNull(zonedDateTime, "zonedDateTime");
        Objects.requireNonNull(formatter, "formatter");
        return zonedDateTime.format(formatter);
    }

    public static String format(ZonedDateTime zonedDateTime, DateTimeFormatter formatter, String zoneId) {
        Objects.requireNonNull(zonedDateTime, "zonedDateTime");
        Objects.requireNonNull(formatter, "formatter");
        return StringUtil.isNotEmpty(zoneId) ? zonedDateTime.format(formatter.withZone(ZoneId.of(zoneId))) : zonedDateTime.format(formatter.withZone(null));
    }

    public static String formatTimestampStyle(Date date) {
        Objects.requireNonNull(date, "date");
        return DateTimeConverterUtil.toTimestamp(date).toString();
    }

    public static String formatTimestampStyle(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return DateTimeConverterUtil.toTimestamp(localDateTime).toString();
    }

    public static String format(TemporalAccessor temporal, DateTimeFormatter formatter) {
        Objects.requireNonNull(temporal, "temporal");
        Objects.requireNonNull(formatter, "formatter");
        return formatter.format(temporal);
    }

    public static String format(TemporalAccessor temporal, DateTimeFormatter formatter, String zoneId) {
        Objects.requireNonNull(temporal, "temporal");
        Objects.requireNonNull(formatter, "formatter");
        if (StringUtil.isNotEmpty(zoneId)) {
            formatter.withZone(ZoneId.of(zoneId));
        } else {
            formatter.withZone(null);
        }
        return StringUtil.isNotEmpty(zoneId) ? formatter.withZone(ZoneId.of(zoneId)).format(temporal) : formatter.withZone(null).format(temporal);
    }

    public static Date parseDateStrToDate(String text) {
        return DateTimeConverterUtil.toDate(LocalDate.parse(text, YYYY_MM_DD_FMT));
    }

    public static LocalDateTime parseDateStrToLocalDateTime(String text) {
        return DateTimeConverterUtil.toLocalDateTime(LocalDate.parse(text, YYYY_MM_DD_FMT));
    }

    public static Instant parseDateStrToInstant(String text) {
        return DateTimeConverterUtil.toInstant(LocalDate.parse(text, YYYY_MM_DD_FMT));
    }

    public static Date parseDateTimeStrToDate(String text) {
        return DateTimeConverterUtil.toDate(DateTimeConverterUtil.toLocalDateTime(YYYY_MM_DD_HH_MM_SS_FMT.parse(text)));
    }

    public static LocalDateTime parseDateTimeStrToLocalDateTime(String text) {
        return DateTimeConverterUtil.toLocalDateTime(YYYY_MM_DD_HH_MM_SS_FMT.parse(text));
    }

    public static Instant parseDateTimeStrToInstant(String text) {
        return DateTimeConverterUtil.toInstant(YYYY_MM_DD_HH_MM_SS_FMT.parse(text));
    }

    public static Date parseToDate(String text, DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        Date date = null;
        try {
            date = DateTimeConverterUtil.toDate(DateTimeConverterUtil.toLocalDateTime(formatter.parse(text)));
        }
        catch (DateTimeException e) {
            if (e.getMessage().startsWith("Unable to obtain")) {
                date = DateTimeConverterUtil.toDate(LocalDate.parse(text, formatter));
            }
            throw e;
        }
        return date;
    }

    public static Date parseToDate(String text, String dateFormatPattern) {
        Objects.requireNonNull(dateFormatPattern, "dateFormatPattern");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(dateFormatPattern).withZone(ZONE);
        return DateTimeFormatterUtil.parseToDate(text, formatter);
    }

    public static Date parseToDate(String text, String[] dateFormatPatterns) {
        Date result = null;
        if (ArrayUtil.isEmpty(dateFormatPatterns)) {
            return result;
        }
        for (String dateFormatPattern : dateFormatPatterns) {
            if (!StringUtil.isNotEmpty(dateFormatPattern)) continue;
            try {
                result = DateTimeFormatterUtil.parseToDate(text, dateFormatPattern);
                if (result == null) continue;
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static LocalDateTime parseToLocalDateTime(String text, DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        LocalDateTime localDateTime = null;
        try {
            localDateTime = DateTimeConverterUtil.toLocalDateTime(formatter.parse(text));
        }
        catch (DateTimeException e) {
            if (e.getMessage().startsWith("Unable to obtain")) {
                localDateTime = DateTimeConverterUtil.toLocalDateTime(LocalDate.parse(text, formatter));
            }
            throw e;
        }
        return localDateTime;
    }

    public static LocalDateTime parseToLocalDateTime(String text, String dateFormatPattern) {
        Objects.requireNonNull(dateFormatPattern, "dateFormatPattern");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(dateFormatPattern).withZone(ZONE);
        return DateTimeFormatterUtil.parseToLocalDateTime(text, formatter);
    }

    public static LocalDateTime parseToLocalDateTime(String text, String[] dateFormatPatterns) {
        LocalDateTime result = null;
        if (ArrayUtil.isEmpty(dateFormatPatterns)) {
            return result;
        }
        for (String dateFormatPattern : dateFormatPatterns) {
            if (!StringUtil.isNotEmpty(dateFormatPattern)) continue;
            try {
                result = DateTimeFormatterUtil.parseToLocalDateTime(text, dateFormatPattern);
                if (result == null) continue;
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static Instant parseToInstant(String text, DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        Instant instant = null;
        try {
            instant = DateTimeConverterUtil.toInstant(formatter.parse(text));
        }
        catch (DateTimeException e) {
            if (e.getMessage().startsWith("Unable to obtain")) {
                instant = DateTimeConverterUtil.toInstant(LocalDate.parse(text, formatter));
            }
            throw e;
        }
        return instant;
    }

    public static ZonedDateTime parseToZonedDateTime(String text, DateTimeFormatter formatter) {
        return ZonedDateTime.parse(text, formatter);
    }

    public static Date smartParseToDate(String text) {
        return DateTimeConverterUtil.toDate(DateTimeFormatterUtil.smartParseToLocalDateTime(text));
    }

    public static LocalDateTime smartParseToLocalDateTime(String text) {
        if (StringUtil.isEmpty(text)) {
            throw new DateTimeException("text is null");
        }
        int len = (text = text.trim()).length();
        if (len < 8) {
            throw new DateTimeException("text is not supported! " + text);
        }
        if (StringUtil.isStartWithWord(text = DateTimeFormatterUtil.preprocessText(text))) {
            return DateTimeFormatterUtil.parseToLocalDateTime(text, EEE_MMM_DD_HH_MM_SS_ZZZ_YYYY_FMT);
        }
        if (StringUtil.isNumeric(text)) {
            if (len == 14) {
                return DateTimeFormatterUtil.parseToLocalDateTime(text, YYYYMMDDHHMMSS_FMT);
            }
            if (len == 17) {
                return DateTimeFormatterUtil.parseToLocalDateTime(text, YYYYMMDDHHMMSSSSS_FMT);
            }
            if (len == 8) {
                return DateTimeFormatterUtil.parseToLocalDateTime(text, YYYYMMDD_FMT);
            }
            if (len == 12) {
                return DateTimeFormatterUtil.parseToLocalDateTime(text, YYYYMMDDHHMM_FMT);
            }
        } else {
            int colonCount = StringUtil.countWord(text, ":");
            if (colonCount == 0) {
                return DateTimeFormatterUtil.parseToLocalDateTime(text, YYYY_M_D_FMT);
            }
            if (text.contains("T")) {
                return DateTimeFormatterUtil.parseIsoToLocalDateTime(text);
            }
            if (colonCount > 0 && text.contains(".")) {
                if (text.split("\\.")[1].length() == 3) {
                    return DateTimeFormatterUtil.parseToLocalDateTime(text, YYYY_M_D_H_M_S_SSS_FMT);
                }
                return DateTimeFormatterUtil.parseTimestampStyleToLocalDateTime(text);
            }
            if (colonCount > 0 && text.contains(",")) {
                return DateTimeFormatterUtil.parseToLocalDateTime(text, YYYY_M_D_H_M_S_SSS_COMMA_FMT);
            }
            if (colonCount > 0) {
                if (colonCount == 2) {
                    return DateTimeFormatterUtil.parseToLocalDateTime(text, YYYY_M_D_H_M_S_FMT);
                }
                if (colonCount == 1) {
                    return DateTimeFormatterUtil.parseToLocalDateTime(text, YYYY_M_D_H_M_FMT);
                }
            }
        }
        throw new DateTimeException("text is not supported! " + text);
    }

    public static LocalDateTime parseIsoToLocalDateTime(String text) {
        if (StringUtil.isEmpty(text)) {
            throw new DateTimeException("text is null");
        }
        if (!text.contains("T")) {
            throw new DateTimeException("text is not supported! " + text);
        }
        text = text.trim();
        int len = text.length();
        if (!text.contains("[")) {
            if (text.contains("Z")) {
                return DateTimeFormatterUtil.parseToLocalDateTime(text, ISO_DATE_TIME_FMT);
            }
            if (len == 24) {
                return DateTimeFormatterUtil.parseToLocalDateTime(text, YYYY_MM_DD_T_HH_MM_SS_Z_FMT);
            }
            if (len == 28) {
                return DateTimeFormatterUtil.parseToLocalDateTime(text, YYYY_MM_DD_T_HH_MM_SS_SSS_Z_FMT);
            }
            return DateTimeFormatterUtil.parseToLocalDateTime(text, ISO_DATE_TIME_FMT);
        }
        if (len == 24) {
            return DateTimeConverterUtil.toLocalDateTime(DateTimeFormatterUtil.parseToZonedDateTime(text, YYYY_MM_DD_T_HH_MM_SS_Z_FMT));
        }
        if (len == 28) {
            return DateTimeConverterUtil.toLocalDateTime(DateTimeFormatterUtil.parseToZonedDateTime(text, YYYY_MM_DD_T_HH_MM_SS_SSS_Z_FMT));
        }
        return DateTimeConverterUtil.toLocalDateTime(DateTimeFormatterUtil.parseToZonedDateTime(text, ISO_DATE_TIME_FMT));
    }

    public static Date parseIsoToDate(String text) {
        return DateTimeConverterUtil.toDate(DateTimeFormatterUtil.parseIsoToLocalDateTime(text));
    }

    public static Date parseEpochMilliToDate(String text) {
        if (StringUtil.isEmpty(text)) {
            throw new DateTimeException("text is null");
        }
        text = text.trim();
        return DateTimeConverterUtil.toDate(Long.parseLong(text));
    }

    public static LocalDateTime parseEpochMilliToLocalDateTime(String text) {
        if (StringUtil.isEmpty(text)) {
            throw new DateTimeException("text is null");
        }
        text = text.trim();
        return DateTimeConverterUtil.toLocalDateTime(Long.parseLong(text));
    }

    public static Date parseDateDefaultStrToDate(String text) {
        return DateTimeFormatterUtil.parseToDate(text, EEE_MMM_DD_HH_MM_SS_ZZZ_YYYY_FMT);
    }

    public static LocalDateTime parseDateDefaultStrToLocalDateTime(String text) {
        return DateTimeFormatterUtil.parseToLocalDateTime(text, EEE_MMM_DD_HH_MM_SS_ZZZ_YYYY_FMT);
    }

    public static Date parseTimestampStyleToDate(String text) {
        return DateTimeConverterUtil.toDate(DateTimeFormatterUtil.parseTimestampStyleToLocalDateTime(text));
    }

    public static LocalDateTime parseTimestampStyleToLocalDateTime(String text) {
        Objects.requireNonNull(text, "text");
        text = text.trim();
        if (!text.contains(".")) {
            throw new DateTimeException("text is not supported! " + text);
        }
        String[] textArr = text.split("\\.");
        String main = textArr[0];
        String nanoOfSecond = textArr[1];
        int mainLen = main.length();
        int len = nanoOfSecond.length();
        if (mainLen != "yyyy-MM-dd HH:mm:ss".length()) {
            throw new DateTimeException("text is not supported! " + text);
        }
        if (len > 9) {
            throw new DateTimeException("text is not supported! " + text);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 9 - len; ++i) {
            sb.append("0");
        }
        nanoOfSecond = nanoOfSecond + sb.toString();
        text = main + "." + nanoOfSecond;
        return DateTimeFormatterUtil.parseToLocalDateTime(text, YYYY_MM_DD_HH_MM_SS_SSSSSSSSS_FMT);
    }

    public static boolean isValidDate(String text) {
        try {
            DateTimeFormatterUtil.parseDateStrToDate(text);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isValidDateTime(String text) {
        try {
            DateTimeFormatterUtil.parseDateTimeStrToDate(text);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Date parseNaturalLanguageToDate(String text, Map<String, String> naturalLanguageMap) {
        if (StringUtil.isEmpty(text)) {
            return null;
        }
        text = text.trim();
        boolean isCommonTimeMap = false;
        if (CollectionUtil.isEmpty(naturalLanguageMap)) {
            naturalLanguageMap = CommonTimeEnum.convertToMap();
            isCommonTimeMap = true;
        }
        if (!naturalLanguageMap.containsKey(text) || StringUtil.isEmpty(naturalLanguageMap.get(text))) {
            return null;
        }
        String targetMethod = null;
        if (isCommonTimeMap) {
            targetMethod = naturalLanguageMap.get(text);
        } else {
            String code = naturalLanguageMap.get(text);
            Map<String, String> commonTimeMap = CommonTimeEnum.convertToMap();
            if (commonTimeMap.containsKey(code)) {
                targetMethod = commonTimeMap.get(code);
            }
        }
        if (targetMethod == null) {
            return null;
        }
        CommonTimeEnum targetCommonTime = CommonTimeEnum.getCommonTimeEnumByCode(targetMethod);
        if (targetCommonTime == null) {
            return null;
        }
        switch (targetCommonTime) {
            case TODAY: {
                return DateTimeCalculatorUtil.today();
            }
            case TOMORROW: {
                return DateTimeCalculatorUtil.tomorrow();
            }
            case NEXTWEEK: {
                return DateTimeCalculatorUtil.nextWeek();
            }
            case NEXTMONTH: {
                return DateTimeCalculatorUtil.nextMonth();
            }
            case NEXTYEAR: {
                return DateTimeCalculatorUtil.nextYear();
            }
            case YESTERDAY: {
                return DateTimeCalculatorUtil.yesterday();
            }
            case LASTWEEK: {
                return DateTimeCalculatorUtil.lastWeek();
            }
            case LASTMONTH: {
                return DateTimeCalculatorUtil.lastMonth();
            }
            case LASTYEAR: {
                return DateTimeCalculatorUtil.lastYear();
            }
        }
        return null;
    }

    public static Date parseNaturalLanguageToDate(String text) {
        return DateTimeFormatterUtil.parseNaturalLanguageToDate(text, null);
    }

    private static String preprocessText(String text) {
        text = DateTimeFormatterUtil.convertSlashToNormal(text);
        text = DateTimeFormatterUtil.convertPointToNormal(text);
        text = DateTimeFormatterUtil.convertCnToNormal(text);
        return text;
    }

    private static String convertSlashToNormal(String str) {
        if (!str.contains("[")) {
            return str.replace("/", "-");
        }
        return str;
    }

    private static String convertPointToNormal(String str) {
        if (StringUtil.countWord(str, ".") == 2) {
            return str.replace(".", "-");
        }
        return str;
    }

    private static String convertCnToNormal(String str) {
        if (StringUtil.hasChinese(str)) {
            return str.replace("\u5e74", "-").replace("\u6708", "-").replace("\u65e5", "").replace("\u65f6", ":").replace("\u5206", ":").replace("\u79d2", "");
        }
        return str;
    }
}

