/*
 * Decompiled with CFR 0.152.
 */
package com.xkzhangsan.time.utils;

import com.xkzhangsan.time.constants.Constant;
import com.xkzhangsan.time.utils.CollectionUtil;
import com.xkzhangsan.time.utils.CommonCache;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class StringUtil {
    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtil.isEmpty(str);
    }

    public static boolean isNumeric(String str) {
        if (str == null) {
            return false;
        }
        return Constant.NUMERIC_REGEX.matcher(str).matches();
    }

    public static boolean isStartWithWord(String str) {
        if (str == null) {
            return false;
        }
        return Constant.START_WITH_WORD_REGEX.matcher(str).matches();
    }

    public static int countWord(String str, String target) {
        if (str == null) {
            return 0;
        }
        int len1 = str.length();
        int len2 = str.replace(target, "").length();
        return len1 - len2;
    }

    public static boolean hasChinese(String str) {
        if (str == null) {
            return false;
        }
        return Constant.CHINESE_REGEX.matcher(str).find();
    }

    public static Map<String, Integer> convertHolidayDataToMap(String holidayData) {
        String[] dateTypeArr;
        HashMap<String, Integer> dateTypeMap = new HashMap<String, Integer>();
        if (StringUtil.isEmpty(holidayData)) {
            return dateTypeMap;
        }
        for (String dateType : dateTypeArr = holidayData.replace(" ", "").split(",")) {
            String[] arr = dateType.split(":");
            dateTypeMap.put(arr[0], Integer.valueOf(arr[1]));
        }
        return dateTypeMap;
    }

    public static Map<String, Integer> convertHolidayDataToMapUseCache(final String holidayData) {
        Map<String, Integer> dateTypeMap = new HashMap<String, Integer>();
        if (StringUtil.isEmpty(holidayData)) {
            return dateTypeMap;
        }
        dateTypeMap = (Map)CommonCache.get(holidayData);
        if (CollectionUtil.isNotEmpty(dateTypeMap)) {
            return dateTypeMap;
        }
        Supplier<Object> supplier = new Supplier<Object>(){

            @Override
            public Object get() {
                String[] dateTypeArr;
                HashMap<String, Integer> dateTypeMap = new HashMap<String, Integer>();
                for (String dateType : dateTypeArr = holidayData.replace(" ", "").split(",")) {
                    String[] arr = dateType.split(":");
                    dateTypeMap.put(arr[0], Integer.valueOf(arr[1]));
                }
                return dateTypeMap;
            }
        };
        return (Map)CommonCache.get(holidayData, supplier);
    }
}

