/*
 * Decompiled with CFR 0.152.
 */
package com.xkzhangsan.time.nlp;

import com.xkzhangsan.time.utils.RegexResourceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextAnalysis {
    private static volatile TextAnalysis instance;
    private static volatile Pattern pattern;
    private boolean isPreferFuture = true;

    private TextAnalysis() {
        try {
            pattern = RegexResourceUtil.readModel("TimeRegex.Gzip");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TextAnalysis getInstance() {
        if (instance != null) return instance;
        Class<TextAnalysis> clazz = TextAnalysis.class;
        synchronized (TextAnalysis.class) {
            if (instance != null) return instance;
            instance = new TextAnalysis();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public List<String> analysis(String text) {
        int startline = -1;
        int endline = -1;
        ArrayList<String> tempResult = new ArrayList<String>();
        tempResult.add("");
        int rpointer = 0;
        Matcher match = pattern.matcher(text);
        boolean startmark = true;
        while (match.find()) {
            startline = match.start();
            if (endline == startline) {
                tempResult.set(--rpointer, (String)tempResult.get(rpointer) + match.group());
            } else {
                if (!startmark) {
                    --rpointer;
                    ++rpointer;
                }
                startmark = false;
                tempResult.set(rpointer, match.group());
            }
            endline = match.end();
            if (tempResult.size() - 1 >= ++rpointer) continue;
            tempResult.add("");
        }
        if (rpointer > 0) {
            --rpointer;
            ++rpointer;
        }
        return tempResult;
    }

    public boolean isPreferFuture() {
        return this.isPreferFuture;
    }

    public void setPreferFuture(boolean isPreferFuture) {
        this.isPreferFuture = isPreferFuture;
    }
}

