/*
 * Decompiled with CFR 0.152.
 */
package htmlflow;

import htmlflow.Indentation;
import java.util.ArrayList;
import java.util.List;
import org.xmlet.htmlapifaster.Area;
import org.xmlet.htmlapifaster.Base;
import org.xmlet.htmlapifaster.Br;
import org.xmlet.htmlapifaster.Col;
import org.xmlet.htmlapifaster.Element;
import org.xmlet.htmlapifaster.ElementVisitor;
import org.xmlet.htmlapifaster.Embed;
import org.xmlet.htmlapifaster.Hr;
import org.xmlet.htmlapifaster.Img;
import org.xmlet.htmlapifaster.Input;
import org.xmlet.htmlapifaster.Link;
import org.xmlet.htmlapifaster.Meta;
import org.xmlet.htmlapifaster.Param;
import org.xmlet.htmlapifaster.Root;
import org.xmlet.htmlapifaster.Source;
import org.xmlet.htmlapifaster.Text;

public abstract class HtmlVisitorCache
extends ElementVisitor {
    private int staticBlockIndex = 0;
    int depth;
    private boolean isClosed = true;
    private boolean openDynamic = false;
    private boolean isCached = false;
    private final List<HtmlBlockInfo> cacheBlocksList = new ArrayList<HtmlBlockInfo>();
    private int cacheIndex = 0;
    final boolean isDynamic;
    final boolean isIndented;

    HtmlVisitorCache(boolean isDynamic, boolean isIndented) {
        this.isDynamic = isDynamic;
        this.isIndented = isIndented;
    }

    public final boolean isWriting() {
        return !this.isCached || this.openDynamic;
    }

    public final void visitElement(Element element) {
        this.newlineAndIndent();
        if (this.isWriting()) {
            this.beginTag(element.getName());
            this.isClosed = false;
        }
    }

    public final void visitParent(Element element) {
        if (this.isWriting()) {
            --this.depth;
            this.newlineAndIndent();
            this.endTag(element.getName());
        }
    }

    public final void visitAttribute(String attributeName, String attributeValue) {
        if (this.isWriting()) {
            this.addAttribute(attributeName, attributeValue);
        }
    }

    public final <R> void visitText(Text<? extends Element, R> text) {
        this.newlineAndIndent();
        if (this.isWriting()) {
            this.write(text.getValue());
        }
    }

    public final <R> void visitComment(Text<? extends Element, R> text) {
        this.newlineAndIndent();
        if (this.isWriting()) {
            this.addComment(text.getValue());
        }
    }

    public final void visitOpenDynamic() {
        if (!this.isDynamic) {
            throw new IllegalStateException("Wrong use of dynamic() in a static view!");
        }
        if (this.openDynamic) {
            throw new IllegalStateException("You are already in a dynamic block! Do not use dynamic() chained inside another dynamic!");
        }
        this.openDynamic = true;
        if (this.isCached) {
            HtmlBlockInfo block = this.cacheBlocksList.get(this.cacheIndex);
            this.write(block.html);
            this.depth = block.currentDepth;
            this.isClosed = block.isClosed;
            ++this.cacheIndex;
        } else {
            String staticBlock = this.substring(this.staticBlockIndex);
            this.cacheBlocksList.add(new HtmlBlockInfo(staticBlock, this.depth, this.isClosed));
        }
    }

    public final void visitCloseDynamic() {
        this.openDynamic = false;
        if (!this.isCached) {
            this.staticBlockIndex = this.size();
        }
    }

    private void visitParentOnVoidElements() {
        if (this.isWriting()) {
            if (!this.isClosed) {
                this.write('>');
            }
            this.isClosed = true;
        }
    }

    private void newlineAndIndent() {
        if (this.isWriting()) {
            if (this.isClosed) {
                if (this.isIndented) {
                    this.write(Indentation.tabs(this.depth));
                }
            } else {
                ++this.depth;
                if (this.isIndented) {
                    this.write(Indentation.closedTabs(this.depth));
                } else {
                    this.write('>');
                }
                this.isClosed = true;
            }
        }
    }

    final void closeBeginTag() {
        if (!this.isClosed) {
            this.write('>');
            this.isClosed = true;
            ++this.depth;
        }
    }

    final String finished() {
        if (this.isCached && this.cacheIndex <= this.cacheBlocksList.size()) {
            HtmlBlockInfo block = this.cacheBlocksList.get(this.cacheIndex);
            this.write(block.html);
            this.isClosed = block.isClosed;
            this.depth = block.currentDepth;
        }
        if (!this.isCached) {
            String staticBlock = this.substring(this.staticBlockIndex);
            this.cacheBlocksList.add(new HtmlBlockInfo(staticBlock, this.depth, this.isClosed));
            this.isCached = true;
        }
        String result = this.readAndReset();
        this.cacheIndex = 0;
        return result;
    }

    protected abstract void beginTag(String var1);

    protected abstract void endTag(String var1);

    protected abstract void addAttribute(String var1, String var2);

    protected abstract void addComment(String var1);

    protected abstract void write(String var1);

    protected abstract void write(char var1);

    protected abstract String substring(int var1);

    protected abstract int size();

    protected abstract String readAndReset();

    protected abstract HtmlVisitorCache clone(boolean var1);

    public final <Z extends Element> void visitElementRoot(Root<Z> var1) {
    }

    public final <Z extends Element> void visitParentRoot(Root<Z> var1) {
    }

    public final <Z extends Element> void visitParentHr(Hr<Z> element) {
        this.visitParentOnVoidElements();
    }

    public final <Z extends Element> void visitParentEmbed(Embed<Z> element) {
        this.visitParentOnVoidElements();
    }

    public final <Z extends Element> void visitParentInput(Input<Z> element) {
        this.visitParentOnVoidElements();
    }

    public final <Z extends Element> void visitParentMeta(Meta<Z> element) {
        this.visitParentOnVoidElements();
    }

    public final <Z extends Element> void visitParentBr(Br<Z> element) {
        this.visitParentOnVoidElements();
    }

    public final <Z extends Element> void visitParentCol(Col<Z> element) {
        this.visitParentOnVoidElements();
    }

    public final <Z extends Element> void visitParentSource(Source<Z> element) {
        this.visitParentOnVoidElements();
    }

    public final <Z extends Element> void visitParentImg(Img<Z> element) {
        this.visitParentOnVoidElements();
    }

    public final <Z extends Element> void visitParentArea(Area<Z> element) {
        this.visitParentOnVoidElements();
    }

    public final <Z extends Element> void visitParentLink(Link<Z> element) {
        this.visitParentOnVoidElements();
    }

    public final <Z extends Element> void visitParentParam(Param<Z> element) {
        this.visitParentOnVoidElements();
    }

    public final <Z extends Element> void visitParentBase(Base<Z> element) {
        this.visitParentOnVoidElements();
    }

    static class HtmlBlockInfo {
        final String html;
        final int currentDepth;
        final boolean isClosed;

        HtmlBlockInfo(String html, int currentDepth, boolean isClosed) {
            this.html = html;
            this.currentDepth = currentDepth;
            this.isClosed = isClosed;
        }
    }
}

