/*
 * Decompiled with CFR 0.152.
 */
package htmlflow;

import htmlflow.HtmlVisitorCache;
import htmlflow.Tags;
import htmlflow.util.PrintStringBuilder;
import java.io.PrintStream;

public class HtmlVisitorPrintStream
extends HtmlVisitorCache {
    private final PrintStream out;
    private PrintStream current;

    public HtmlVisitorPrintStream(PrintStream out, boolean isDynamic) {
        this(out, isDynamic, true);
    }

    public HtmlVisitorPrintStream(PrintStream out, boolean isDynamic, boolean isIndented) {
        super(isDynamic, isIndented);
        this.out = out;
        this.current = new PrintStringBuilder(out);
    }

    @Override
    protected void beginTag(String elementName) {
        Tags.printOpenTag(this.current, elementName);
    }

    @Override
    protected void endTag(String elementName) {
        Tags.printCloseTag(this.current, elementName);
    }

    @Override
    protected void addAttribute(String attributeName, String attributeValue) {
        Tags.printAttribute(this.current, attributeName, attributeValue);
    }

    @Override
    protected void addComment(String comment) {
        Tags.printComment(this.current, comment);
    }

    @Override
    protected void write(String text) {
        this.current.print(text);
    }

    @Override
    protected void write(char c) {
        this.current.print(c);
    }

    @Override
    protected String substring(int staticBlockIndex) {
        return ((PrintStringBuilder)this.current).substring(staticBlockIndex);
    }

    @Override
    protected int size() {
        return ((PrintStringBuilder)this.current).length();
    }

    @Override
    protected String readAndReset() {
        this.current = this.out;
        return null;
    }

    @Override
    protected HtmlVisitorCache clone(boolean isIndented) {
        return new HtmlVisitorPrintStream(this.out, this.isDynamic, isIndented);
    }
}

