/*
 * Decompiled with CFR 0.152.
 */
package htmlflow;

import htmlflow.HtmlVisitorCache;
import htmlflow.Tags;

public class HtmlVisitorStringBuilder
extends HtmlVisitorCache {
    private final StringBuilder sb = new StringBuilder();

    public HtmlVisitorStringBuilder(boolean isDynamic) {
        this(isDynamic, true);
    }

    public HtmlVisitorStringBuilder(boolean isDynamic, boolean isIndented) {
        super(isDynamic, isIndented);
    }

    @Override
    protected void beginTag(String elementName) {
        Tags.appendOpenTag(this.sb, elementName);
    }

    @Override
    protected void endTag(String elementName) {
        Tags.appendCloseTag(this.sb, elementName);
    }

    @Override
    protected void addAttribute(String attributeName, String attributeValue) {
        Tags.appendAttribute(this.sb, attributeName, attributeValue);
    }

    @Override
    protected void addComment(String comment) {
        Tags.appendComment(this.sb, comment);
    }

    @Override
    protected void write(String text) {
        this.sb.append(text);
    }

    @Override
    protected void write(char c) {
        this.sb.append(c);
    }

    @Override
    protected String substring(int staticBlockIndex) {
        return this.sb.substring(staticBlockIndex);
    }

    @Override
    protected int size() {
        return this.sb.length();
    }

    @Override
    protected String readAndReset() {
        String data = this.sb.toString();
        this.sb.setLength(0);
        return data;
    }

    @Override
    protected HtmlVisitorCache clone(boolean isIndented) {
        return new HtmlVisitorStringBuilder(this.isDynamic, isIndented);
    }
}

