/*
 * Decompiled with CFR 0.152.
 */
package htmlflow;

import htmlflow.HtmlTemplate;
import htmlflow.HtmlView;
import htmlflow.HtmlVisitorCache;
import htmlflow.HtmlVisitorPrintStream;
import htmlflow.HtmlVisitorStringBuilder;
import java.io.PrintStream;
import java.util.function.BiConsumer;
import java.util.function.Supplier;

public class DynamicHtml<T>
extends HtmlView<T> {
    private static final String WRONG_USE_OF_RENDER_WITHOUT_MODEL = "Wrong use of DynamicView! You should provide a model parameter or use a static view instead!";
    private final HtmlTemplate<T> template;
    private final BiConsumer<DynamicHtml<T>, T> binder;

    public static <U> DynamicHtml<U> view(PrintStream out, HtmlTemplate<U> template) {
        return new DynamicHtml<U>(out, template);
    }

    public static <U> DynamicHtml<U> view(PrintStream out, BiConsumer<DynamicHtml<U>, U> binder) {
        return new DynamicHtml<U>(out, binder);
    }

    public static <U> DynamicHtml<U> view(HtmlTemplate<U> template) {
        return new DynamicHtml<U>(template);
    }

    public static <U> DynamicHtml<U> view(BiConsumer<DynamicHtml<U>, U> binder) {
        return new DynamicHtml<U>(binder);
    }

    private DynamicHtml(Supplier<HtmlVisitorCache> visitorSupplier, boolean threadSafe, HtmlTemplate<T> template, BiConsumer<DynamicHtml<T>, T> binder) {
        super(visitorSupplier, threadSafe);
        this.template = template;
        this.binder = binder;
    }

    private DynamicHtml(PrintStream out, HtmlTemplate<T> template) {
        super(() -> new HtmlVisitorPrintStream(out, true), false);
        this.binder = null;
        this.template = template;
    }

    private DynamicHtml(PrintStream out, BiConsumer<DynamicHtml<T>, T> binder) {
        super(() -> new HtmlVisitorPrintStream(out, true), false);
        this.binder = binder;
        this.template = null;
    }

    private DynamicHtml(HtmlTemplate<T> template) {
        super(() -> new HtmlVisitorStringBuilder(true), false);
        this.binder = null;
        this.template = template;
    }

    private DynamicHtml(BiConsumer<DynamicHtml<T>, T> binder) {
        super(() -> new HtmlVisitorStringBuilder(true), false);
        this.binder = binder;
        this.template = null;
    }

    @Override
    public final String render() {
        throw new UnsupportedOperationException(WRONG_USE_OF_RENDER_WITHOUT_MODEL);
    }

    @Override
    public final String render(T model) {
        this.binder.accept(this, (DynamicHtml)model);
        return this.getVisitor().finished();
    }

    public final String render(T model, HtmlView ... partials) {
        this.template.resolve(this, model, partials);
        return this.getVisitor().finished();
    }

    @Override
    public final void write() {
        throw new UnsupportedOperationException(WRONG_USE_OF_RENDER_WITHOUT_MODEL);
    }

    @Override
    public final void write(T model) {
        this.render(model);
    }

    public final void write(T model, HtmlView ... partials) {
        this.render(model, partials);
    }

    @Override
    protected final HtmlView<T> clone(Supplier<HtmlVisitorCache> visitorSupplier, boolean threadSafe) {
        return new DynamicHtml<T>(visitorSupplier, threadSafe, this.template, this.binder);
    }

    @Override
    protected HtmlView<T> clone(HtmlVisitorCache visitor) {
        return new DynamicHtml<T>(() -> visitor, false, this.template, this.binder);
    }
}

