/*
 * Decompiled with CFR 0.152.
 */
package htmlflow;

import htmlflow.HtmlVisitorCache;
import htmlflow.HtmlVisitorPrintStream;
import htmlflow.HtmlVisitorStringBuilder;
import htmlflow.HtmlWriter;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.xmlet.htmlapifaster.Div;
import org.xmlet.htmlapifaster.Element;
import org.xmlet.htmlapifaster.Html;
import org.xmlet.htmlapifaster.Root;
import org.xmlet.htmlapifaster.Tr;

public abstract class HtmlView<T>
implements HtmlWriter<T>,
Element<HtmlView<T>, Element<?, ?>> {
    static final String WRONG_USE_OF_PRINTSTREAM_ON_THREADSAFE_VIEWS = "Cannot use PrintStream output for thread-safe views!";
    static final String WRONG_USE_OF_THREADSAFE_ON_VIEWS_WITH_PRINTSTREAM = "Cannot set thread-safety for views with PrintStream output!";
    private static final String HEADER;
    private static final String NEWLINE;
    private static final String HEADER_TEMPLATE = "templates/HtmlView-Header.txt";
    private final HtmlVisitorCache visitor;
    private final ThreadLocal<HtmlVisitorCache> threadLocalVisitor;
    private final Supplier<HtmlVisitorCache> visitorSupplier;
    private final boolean threadSafe;

    protected HtmlView(Supplier<HtmlVisitorCache> visitorSupplier, boolean threadSafe) {
        this.visitorSupplier = visitorSupplier;
        this.threadSafe = threadSafe;
        if (threadSafe) {
            this.visitor = null;
            this.threadLocalVisitor = ThreadLocal.withInitial(visitorSupplier);
        } else {
            this.visitor = visitorSupplier.get();
            this.threadLocalVisitor = null;
        }
    }

    public final Html<HtmlView<T>> html() {
        if (this.getVisitor().isWriting()) {
            this.getVisitor().write(HEADER);
        }
        return new Html((Element)this);
    }

    public final Div<HtmlView<T>> div() {
        return new Div((Element)this);
    }

    public final Tr<HtmlView<T>> tr() {
        return new Tr((Element)this);
    }

    public final Root<HtmlView<T>> defineRoot() {
        return new Root((Element)this);
    }

    @Override
    public final HtmlWriter<T> setPrintStream(PrintStream out) {
        if (this.threadSafe) {
            throw new IllegalArgumentException(WRONG_USE_OF_PRINTSTREAM_ON_THREADSAFE_VIEWS);
        }
        Supplier<HtmlVisitorCache> v = out == null ? () -> new HtmlVisitorStringBuilder(this.getVisitor().isDynamic) : () -> new HtmlVisitorPrintStream(out, this.getVisitor().isDynamic);
        return this.clone(v, false);
    }

    public final HtmlView<T> setIndented(boolean isIndented) {
        return this.clone(() -> this.getVisitor().clone(isIndented), false);
    }

    public final HtmlView<T> self() {
        return this;
    }

    public final HtmlView<T> threadSafe() {
        if (this.getVisitor() instanceof HtmlVisitorPrintStream) {
            throw new IllegalStateException(WRONG_USE_OF_THREADSAFE_ON_VIEWS_WITH_PRINTSTREAM);
        }
        return this.clone(this.visitorSupplier, true);
    }

    public final HtmlVisitorCache getVisitor() {
        return this.threadSafe ? this.threadLocalVisitor.get() : this.visitor;
    }

    public String getName() {
        return "HtmlView";
    }

    public Element __() {
        throw new IllegalStateException("HtmlView is the root of Html tree and it has not any parent.");
    }

    public Element getParent() {
        throw new IllegalStateException("HtmlView is the root of Html tree and it has not any parent.");
    }

    public final <U> void addPartial(HtmlView<U> partial, U model) {
        HtmlVisitorCache v;
        String p;
        this.getVisitor().closeBeginTag();
        partial.getVisitor().depth = this.getVisitor().depth;
        if (this.getVisitor().isWriting() && (p = partial.clone((v = this.getVisitor()).newbie()).render(model)) != null) {
            v.write(p);
        }
    }

    public final <U> void addPartial(HtmlView<U> partial) {
        String p;
        this.getVisitor().closeBeginTag();
        partial.getVisitor().depth = this.getVisitor().depth;
        if (this.getVisitor().isWriting() && (p = partial.render()) != null) {
            this.getVisitor().write(p);
        }
    }

    protected abstract HtmlView<T> clone(Supplier<HtmlVisitorCache> var1, boolean var2);

    protected abstract HtmlView<T> clone(HtmlVisitorCache var1);

    static {
        NEWLINE = System.getProperty("line.separator");
        try {
            URL headerUrl = HtmlView.class.getClassLoader().getResource(HEADER_TEMPLATE);
            if (headerUrl == null) {
                throw new FileNotFoundException(HEADER_TEMPLATE);
            }
            InputStream headerStream = headerUrl.openStream();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(headerStream));){
                HEADER = reader.lines().collect(Collectors.joining(NEWLINE));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

