/*
 * Decompiled with CFR 0.152.
 */
package htmlflow;

import htmlflow.HtmlDoc;
import htmlflow.HtmlTemplate;
import htmlflow.HtmlView;
import htmlflow.HtmlViewAsync;
import htmlflow.visitor.HtmlDocVisitor;
import htmlflow.visitor.HtmlViewVisitor;
import htmlflow.visitor.HtmlViewVisitorAsync;
import htmlflow.visitor.PreprocessingVisitor;
import htmlflow.visitor.PreprocessingVisitorAsync;

public class HtmlFlow {
    private HtmlFlow() {
    }

    private static PreprocessingVisitor preprocessing(HtmlTemplate template) {
        PreprocessingVisitor pre = new PreprocessingVisitor(true);
        HtmlView preView = new HtmlView(() -> pre, false);
        template.resolve(preView);
        preView.getVisitor().resolve(null);
        return pre;
    }

    private static PreprocessingVisitorAsync preprocessingAsync(HtmlTemplate template) {
        PreprocessingVisitorAsync pre = new PreprocessingVisitorAsync(true);
        HtmlView preView = new HtmlView(() -> pre, false);
        template.resolve(preView);
        preView.getVisitor().resolve(null);
        return pre;
    }

    public static HtmlDoc doc(Appendable out) {
        return new HtmlDoc(new HtmlDocVisitor(out, true));
    }

    public static HtmlView view(Appendable out, HtmlTemplate template) {
        PreprocessingVisitor pre = HtmlFlow.preprocessing(template);
        return new HtmlView(() -> new HtmlViewVisitor(out, true, pre.getFirst()), false);
    }

    public static HtmlView view(HtmlTemplate template) {
        PreprocessingVisitor pre = HtmlFlow.preprocessing(template);
        return new HtmlView(() -> new HtmlViewVisitor(new StringBuilder(), true, pre.getFirst()), false);
    }

    public static HtmlViewAsync viewAsync(HtmlTemplate template) {
        PreprocessingVisitorAsync pre = HtmlFlow.preprocessingAsync(template);
        return new HtmlViewAsync(new HtmlViewVisitorAsync(true, pre.getFirst()));
    }
}

