/*
 * Decompiled with CFR 0.152.
 */
package htmlflow;

import htmlflow.HtmlPage;
import htmlflow.visitor.HtmlVisitor;
import java.util.function.Supplier;
import org.xmlet.htmlapifaster.Element;
import org.xmlet.htmlapifaster.Html;

public class HtmlView
extends HtmlPage {
    private final HtmlVisitor visitor;
    private final ThreadLocal<HtmlVisitor> threadLocalVisitor;
    protected final Supplier<HtmlVisitor> visitorSupplier;
    private final boolean threadSafe;

    HtmlView(Supplier<HtmlVisitor> visitorSupplier, boolean threadSafe) {
        this.visitorSupplier = visitorSupplier;
        this.threadSafe = threadSafe;
        if (threadSafe) {
            this.visitor = null;
            this.threadLocalVisitor = ThreadLocal.withInitial(visitorSupplier);
        } else {
            this.visitor = visitorSupplier.get();
            this.threadLocalVisitor = null;
        }
    }

    @Override
    public final Html<HtmlPage> html() {
        this.getVisitor().write(HEADER);
        return new Html((Element)this);
    }

    @Override
    public HtmlView threadSafe() {
        return this.clone(this.visitorSupplier, true);
    }

    public HtmlVisitor getVisitor() {
        return this.threadSafe ? this.threadLocalVisitor.get() : this.visitor;
    }

    public HtmlView setOut(Appendable out) {
        this.getVisitor().setAppendable(out);
        return this;
    }

    public String getName() {
        return "HtmlView";
    }

    public String render() {
        return this.render(null);
    }

    public String render(Object model) {
        StringBuilder str = (StringBuilder)this.getVisitor().out();
        str.setLength(0);
        this.getVisitor().resolve(model);
        return str.toString();
    }

    public void write(Object model) {
        this.getVisitor().resolve(model);
    }

    public void write() {
        this.write(null);
    }

    protected final HtmlView clone(Supplier<HtmlVisitor> visitorSupplier, boolean threadSafe) {
        return new HtmlView(visitorSupplier, threadSafe);
    }

    @Override
    public final HtmlView setIndented(boolean isIndented) {
        return this.clone(() -> this.getVisitor().clone(isIndented), false);
    }
}

