/*
 * Decompiled with CFR 0.152.
 */
package htmlflow.continuations;

import htmlflow.continuations.HtmlContinuation;
import htmlflow.visitor.HtmlVisitor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.xmlet.htmlapifaster.Element;
import org.xmlet.htmlapifaster.ElementVisitor;
import org.xmlet.htmlapifaster.async.AwaitConsumer;

public class HtmlContinuationAsync<E extends Element, T>
extends HtmlContinuation {
    private final E element;
    private final AwaitConsumer<E, T> consumer;

    public HtmlContinuationAsync(int currentDepth, boolean isClosed, E element, AwaitConsumer<E, T> consumer, HtmlVisitor visitor, HtmlContinuation next) {
        super(currentDepth, isClosed, visitor, next);
        this.element = element;
        this.consumer = consumer;
    }

    @Override
    public final void execute(Object model) {
        if (this.currentDepth >= 0) {
            this.visitor.setIsClosed(this.isClosed);
            this.visitor.setDepth(this.currentDepth);
        }
        this.consumer.accept(this.element, model, () -> {
            if (this.next != null) {
                this.next.execute(model);
            }
        });
    }

    @Override
    public HtmlContinuation copy(HtmlVisitor v) {
        return new HtmlContinuationAsync<E, T>(this.currentDepth, this.isClosed, this.copyElement(v), this.consumer, v, this.next != null ? this.next.copy(v) : null);
    }

    public E copyElement(HtmlVisitor v) {
        try {
            Constructor<?> ctor = this.element.getClass().getDeclaredConstructor(Element.class, ElementVisitor.class, Boolean.TYPE);
            ctor.setAccessible(true);
            return (E)((Element)ctor.newInstance(new Object[]{this.element.getParent(), v, false}));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

