/*
 * Decompiled with CFR 0.152.
 */
package htmlflow.visitor;

class Indentation {
    private static final int MAX_TABS = 1000;
    private static final char NEWLINE = '\n';
    private static final char TAB = '\t';
    private static final String[] tabs = Indentation.createTabs(1000);
    private static final String[] closedTabs = Indentation.createClosedTabs(1000);

    private Indentation() {
    }

    private static String[] createTabs(int tabsMax) {
        String[] tabs = new String[tabsMax];
        for (int i = 0; i < tabsMax; ++i) {
            char[] newTab = new char[i + 1];
            newTab[0] = 10;
            tabs[i] = new String(newTab).replace('\u0000', '\t');
        }
        return tabs;
    }

    private static String[] createClosedTabs(int tabsMax) {
        String[] closedTabs = new String[tabsMax];
        for (int i = 0; i < tabsMax; ++i) {
            char[] newClosedTab = new char[i + 2];
            newClosedTab[0] = 62;
            newClosedTab[1] = 10;
            closedTabs[i] = new String(newClosedTab).replace('\u0000', '\t');
        }
        return closedTabs;
    }

    public static String tabs(int depth) {
        return tabs[depth];
    }

    public static String closedTabs(int depth) {
        return closedTabs[depth];
    }
}

