/*
 * Decompiled with CFR 0.152.
 */
package htmlflow;

import htmlflow.HtmlDoc;
import htmlflow.HtmlTemplate;
import htmlflow.HtmlView;
import htmlflow.HtmlViewAsync;
import htmlflow.visitor.HtmlDocVisitor;
import htmlflow.visitor.HtmlViewVisitor;
import htmlflow.visitor.HtmlViewVisitorAsync;
import htmlflow.visitor.PreprocessingVisitor;
import htmlflow.visitor.PreprocessingVisitorAsync;

public class HtmlFlow {
    private HtmlFlow() {
    }

    private static PreprocessingVisitor preprocessing(HtmlTemplate template, boolean isIndented) {
        PreprocessingVisitor pre = new PreprocessingVisitor(isIndented);
        HtmlView preView = new HtmlView(() -> pre, template, false);
        template.resolve(preView);
        preView.getVisitor().resolve(null);
        return pre;
    }

    private static PreprocessingVisitorAsync preprocessingAsync(HtmlTemplate template, boolean isIndented) {
        PreprocessingVisitorAsync pre = new PreprocessingVisitorAsync(isIndented);
        HtmlView preView = new HtmlView(() -> pre, template, false);
        template.resolve(preView);
        preView.getVisitor().resolve(null);
        return pre;
    }

    public static HtmlDoc doc(Appendable out) {
        return new HtmlDoc(new HtmlDocVisitor(out, true));
    }

    public static <M> HtmlView<M> view(Appendable out, HtmlTemplate template) {
        return HtmlFlow.view(out, template, true, false);
    }

    static <M> HtmlView<M> view(Appendable out, HtmlTemplate template, boolean isIndented, boolean threadSafe) {
        PreprocessingVisitor pre = HtmlFlow.preprocessing(template, isIndented);
        return new HtmlView(() -> new HtmlViewVisitor(out, isIndented, pre.getFirst()), template, threadSafe);
    }

    public static <M> HtmlView<M> view(HtmlTemplate template) {
        return HtmlFlow.view(template, true, false);
    }

    static <M> HtmlView<M> view(HtmlTemplate template, boolean isIndented, boolean threadSafe) {
        PreprocessingVisitor pre = HtmlFlow.preprocessing(template, isIndented);
        return new HtmlView(() -> new HtmlViewVisitor(new StringBuilder(), isIndented, pre.getFirst()), template, threadSafe);
    }

    public static <M> HtmlViewAsync<M> viewAsync(HtmlTemplate template) {
        return HtmlFlow.viewAsync(template, true, false);
    }

    static <M> HtmlViewAsync<M> viewAsync(HtmlTemplate template, boolean isIndented, boolean threadSafe) {
        PreprocessingVisitorAsync pre = HtmlFlow.preprocessingAsync(template, isIndented);
        return new HtmlViewAsync(new HtmlViewVisitorAsync(isIndented, pre.getFirst()), template, threadSafe);
    }
}

