/*
 * Decompiled with CFR 0.152.
 */
package htmlflow;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.stream.Collectors;
import org.xmlet.htmlapifaster.Div;
import org.xmlet.htmlapifaster.Element;
import org.xmlet.htmlapifaster.Html;
import org.xmlet.htmlapifaster.Tr;

public abstract class HtmlPage
implements Element<HtmlPage, Element<?, ?>> {
    public static final String HEADER;
    private static final String NEWLINE;
    private static final String HEADER_TEMPLATE = "templates/HtmlView-Header.txt";

    public abstract Html<HtmlPage> html();

    public final Div<HtmlPage> div() {
        return new Div((Element)this);
    }

    public final Tr<HtmlPage> tr() {
        return new Tr((Element)this);
    }

    public abstract HtmlPage setIndented(boolean var1);

    public final HtmlPage self() {
        return this;
    }

    public abstract HtmlPage threadSafe();

    public Element __() {
        throw new IllegalStateException(this.getName() + " is the root of Html tree and it has not any parent.");
    }

    public Element getParent() {
        throw new IllegalStateException(this.getName() + " is the root of Html tree and it has not any parent.");
    }

    static {
        NEWLINE = System.getProperty("line.separator");
        try {
            URL headerUrl = HtmlPage.class.getClassLoader().getResource(HEADER_TEMPLATE);
            if (headerUrl == null) {
                throw new FileNotFoundException(HEADER_TEMPLATE);
            }
            InputStream headerStream = headerUrl.openStream();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(headerStream));){
                HEADER = reader.lines().collect(Collectors.joining(NEWLINE));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

