/*
 * Decompiled with CFR 0.152.
 */
package htmlflow;

import htmlflow.HtmlFlow;
import htmlflow.HtmlPage;
import htmlflow.HtmlTemplate;
import htmlflow.visitor.HtmlViewVisitorAsync;
import java.util.concurrent.CompletableFuture;
import org.xmlet.htmlapifaster.Element;
import org.xmlet.htmlapifaster.Html;

public class HtmlViewAsync<M>
extends HtmlPage {
    private final HtmlTemplate template;
    private final HtmlViewVisitorAsync visitor;
    private final boolean threadSafe;

    HtmlViewAsync(HtmlViewVisitorAsync visitor, HtmlTemplate template) {
        this(visitor, template, true);
    }

    public HtmlViewAsync(HtmlViewVisitorAsync visitor, HtmlTemplate template, boolean safe) {
        this.visitor = visitor;
        this.template = template;
        this.threadSafe = safe;
    }

    @Override
    public final Html<HtmlPage> html() {
        this.visitor.write(HEADER);
        return new Html((Element)this);
    }

    @Override
    public HtmlViewAsync<M> setIndented(boolean isIndented) {
        return HtmlFlow.viewAsync(this.template, isIndented, this.threadSafe);
    }

    public HtmlViewVisitorAsync getVisitor() {
        return this.visitor;
    }

    public String getName() {
        return "HtmlViewAsync";
    }

    @Override
    public HtmlViewAsync<M> threadSafe() {
        return new HtmlViewAsync<M>(this.visitor, this.template);
    }

    public HtmlViewAsync<M> threadUnsafe() {
        return new HtmlViewAsync<M>(this.visitor, this.template, false);
    }

    public final CompletableFuture<Void> writeAsync(Appendable out, M model) {
        if (this.threadSafe) {
            return this.visitor.clone(out).finishedAsync(model);
        }
        this.visitor.setAppendable(out);
        return this.visitor.finishedAsync(model);
    }

    public final CompletableFuture<String> renderAsync() {
        return this.renderAsync(null);
    }

    public final CompletableFuture<String> renderAsync(M model) {
        StringBuilder str = new StringBuilder();
        return this.writeAsync(str, model).thenApply(nothing -> str.toString());
    }
}

