/*
 * Decompiled with CFR 0.152.
 */
package htmlflow.flowifier;

import htmlflow.flowifier.HtmlToJavaHtmlFlowNodeVisitor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.DocumentType;
import org.jsoup.nodes.Entities;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.xmlet.htmlapifaster.EnumAutocompleteType;
import org.xmlet.htmlapifaster.EnumBorderType;
import org.xmlet.htmlapifaster.EnumContenteditableType;
import org.xmlet.htmlapifaster.EnumCrossoriginCrossOriginType;
import org.xmlet.htmlapifaster.EnumDirType;
import org.xmlet.htmlapifaster.EnumDisplayType;
import org.xmlet.htmlapifaster.EnumDraggableType;
import org.xmlet.htmlapifaster.EnumEnctypeType;
import org.xmlet.htmlapifaster.EnumFormenctypeEnctypeType;
import org.xmlet.htmlapifaster.EnumFormmethodMethodType;
import org.xmlet.htmlapifaster.EnumFormtargetBrowsingContext;
import org.xmlet.htmlapifaster.EnumHttpEquivType;
import org.xmlet.htmlapifaster.EnumKindType;
import org.xmlet.htmlapifaster.EnumMediaType;
import org.xmlet.htmlapifaster.EnumMethodType;
import org.xmlet.htmlapifaster.EnumOverflowType;
import org.xmlet.htmlapifaster.EnumRelType;
import org.xmlet.htmlapifaster.EnumRevType;
import org.xmlet.htmlapifaster.EnumSandboxType;
import org.xmlet.htmlapifaster.EnumScopeType;
import org.xmlet.htmlapifaster.EnumShapeType;
import org.xmlet.htmlapifaster.EnumSpellcheckType;
import org.xmlet.htmlapifaster.EnumTranslateType;
import org.xmlet.htmlapifaster.EnumTypeButtonType;
import org.xmlet.htmlapifaster.EnumTypeContentType;
import org.xmlet.htmlapifaster.EnumTypeInputType;
import org.xmlet.htmlapifaster.EnumTypeOlType;
import org.xmlet.htmlapifaster.EnumTypeScriptType;
import org.xmlet.htmlapifaster.EnumTypeSimpleContentType;
import org.xmlet.htmlapifaster.EnumWrapType;
import org.xmlet.xsdasmfaster.classes.infrastructure.EnumInterface;

public abstract class AbstractHtmlToJavaHtmlFlowNodeVisitor<T extends Appendable>
implements HtmlToJavaHtmlFlowNodeVisitor<T> {
    private static final Logger LOGGER = Logger.getLogger(AbstractHtmlToJavaHtmlFlowNodeVisitor.class.getCanonicalName());
    private static final Class[] ENUM_INTERFACE_SUBCLASSES = new Class[]{EnumAutocompleteType.class, EnumBorderType.class, EnumContenteditableType.class, EnumCrossoriginCrossOriginType.class, EnumDirType.class, EnumDisplayType.class, EnumDraggableType.class, EnumEnctypeType.class, EnumFormenctypeEnctypeType.class, EnumFormmethodMethodType.class, EnumFormtargetBrowsingContext.class, EnumHttpEquivType.class, EnumKindType.class, EnumMediaType.class, EnumMethodType.class, EnumOverflowType.class, EnumRelType.class, EnumRevType.class, EnumSandboxType.class, EnumScopeType.class, EnumShapeType.class, EnumSpellcheckType.class, EnumTranslateType.class, EnumTypeButtonType.class, EnumTypeContentType.class, EnumTypeInputType.class, EnumTypeOlType.class, EnumTypeScriptType.class, EnumTypeSimpleContentType.class, EnumWrapType.class};
    private final Supplier<T> appendableSupplier;
    private final boolean indented;
    private T appendable;

    protected AbstractHtmlToJavaHtmlFlowNodeVisitor(Supplier<T> appendableSupplier, boolean indented) {
        this.appendableSupplier = Objects.requireNonNull(appendableSupplier);
        this.indented = indented;
    }

    @Override
    public final T getAppendable() {
        return this.appendable;
    }

    @Override
    public void appendHeader() throws IOException {
        this.appendable = (Appendable)this.appendableSupplier.get();
        this.appendable.append("import htmlflow.*;\n");
        this.appendable.append("import org.xmlet.htmlapifaster.*;\n\n");
        this.appendable.append("public class Flowified {\n");
        this.appendable.append("    public static void get(StringBuilder out) {\n");
        this.appendable.append("        HtmlFlow.doc(out).setIndented(").append(Boolean.toString(this.indented)).append(")\n");
    }

    @Override
    public void appendFooter() throws IOException {
        this.appendable.append("            ;\n");
        this.appendable.append("    }\n");
        this.appendable.append("}\n");
    }

    private String characterLiteralWithoutSingleQuotes(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
            case '\"': {
                return "\"";
            }
            case '\'': {
                return "\\'";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return Character.isISOControl(c) ? String.format("\\u%04x", c) : Character.toString(c);
    }

    private String stringLiteralWithDoubleQuotes(String value, String indent) {
        StringBuilder result = new StringBuilder(value.length() + 2);
        result.append('\"');
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\'') {
                result.append("'");
                continue;
            }
            if (c == '\"') {
                result.append("\\\"");
                continue;
            }
            result.append(this.characterLiteralWithoutSingleQuotes(c));
            if (c != '\n' || i + 1 >= value.length()) continue;
            result.append("\"\n").append(indent).append(indent).append("+ \"");
        }
        result.append('\"');
        return result.toString();
    }

    @Override
    public String convertJavaStringContentToJavaDeclarableString(String unescaped) {
        return unescaped == null ? null : this.stringLiteralWithDoubleQuotes(unescaped, "");
    }

    @Override
    public boolean isUncloseable(Node node) {
        return node instanceof Document || node instanceof DataNode || node instanceof Comment || node instanceof TextNode || node instanceof DocumentType;
    }

    private String toEnumAttributeValue(Class<? extends EnumInterface<String>> enumInterfaceClass, Attribute attribute) {
        EnumInterface attrValEnum = Arrays.stream(enumInterfaceClass.getEnumConstants()).map(EnumInterface.class::cast).filter(enumInterface -> enumInterface.getValue().equals(attribute.getValue())).findFirst().orElse(null);
        String enumAttrValue = attrValEnum == null ? null : enumInterfaceClass.getSimpleName() + "." + ((Enum)attrValEnum).name();
        return enumAttrValue;
    }

    @Override
    public Class<?> getClassFromNodeName(String nodeName) {
        Class<?> nodeClass;
        String nodeClassname = nodeName.substring(0, 1).toUpperCase(Locale.ENGLISH) + nodeName.substring(1).toLowerCase(Locale.ENGLISH);
        try {
            nodeClass = Class.forName("org.xmlet.htmlapifaster." + nodeClassname);
        }
        catch (ClassNotFoundException cnfe) {
            LOGGER.warning("Class " + nodeClassname + " not found for the node name " + nodeName);
            nodeClass = null;
        }
        return nodeClass;
    }

    @Override
    public Method getMethodFromAttribute(Class<?> nodeClass, Attribute attribute) {
        String attrKey = attribute.getKey();
        String attrMethodName = "attr" + attrKey.substring(0, 1).toUpperCase(Locale.ENGLISH) + attrKey.substring(1);
        return Arrays.stream(nodeClass.getMethods()).filter(method -> method.getName().equals(attrMethodName) && method.getParameterCount() == 1 && Stream.concat(Stream.of(String.class, Boolean.class, Long.class, Integer.class), Arrays.stream(ENUM_INTERFACE_SUBCLASSES)).anyMatch(candidateClass -> candidateClass.equals(method.getParameterTypes()[0]))).findFirst().orElse(null);
    }

    public void head(Node node, int depth) {
        try {
            if (depth == 0) {
                this.appendHeader();
            }
            if (!(node instanceof Document) && !(node instanceof DocumentType)) {
                this.appendable.append("        ");
                for (int spaceIndex = 0; spaceIndex < depth * 4; ++spaceIndex) {
                    this.appendable.append(' ');
                }
                if (node instanceof TextNode) {
                    TextNode textNode = (TextNode)node;
                    this.appendable.append(".raw(").append(this.convertJavaStringContentToJavaDeclarableString(Entities.escape((String)textNode.getWholeText()))).append(")").append("\n");
                    textNode.toString();
                } else if (node instanceof DataNode) {
                    DataNode dataNode = (DataNode)node;
                    this.appendable.append(".raw(").append(this.convertJavaStringContentToJavaDeclarableString(dataNode.getWholeData())).append(")").append("\n");
                } else if (node instanceof Comment) {
                    Comment comment = (Comment)node;
                    this.appendable.append(".comment(").append(this.convertJavaStringContentToJavaDeclarableString(comment.getData())).append(")").append("\n");
                } else {
                    this.appendable.append(".").append(node.nodeName()).append("()");
                    Class<?> nodeClass = this.getClassFromNodeName(node.nodeName());
                    if (nodeClass != null) {
                        for (Attribute attribute : node.attributes().asList()) {
                            this.appendAttribute(attribute, nodeClass);
                        }
                    }
                    this.appendable.append("\n");
                }
            }
        }
        catch (IOException ioe) {
            LOGGER.warning("Failed to append the Java source code, cause: " + ioe.getMessage());
        }
    }

    private String escapeInAttribute(String unescaped) {
        return Entities.escape((String)unescaped).replace("\"", "&quot;");
    }

    @Override
    public void appendAttribute(Attribute attribute, Class<?> nodeClass) throws IOException {
        Method attrMethod = this.getMethodFromAttribute(nodeClass, attribute);
        String attrKey = attribute.getKey();
        Object attrVal = attrMethod == null ? null : (attrMethod.getParameterTypes()[0].equals(String.class) ? this.convertJavaStringContentToJavaDeclarableString(this.escapeInAttribute(attribute.getValue())) : (attrMethod.getParameterTypes()[0].equals(Boolean.class) ? (attribute.getValue() == null || attribute.getValue().isEmpty() ? null : (attribute.getValue().equalsIgnoreCase("true") ? "Boolean.TRUE" : "Boolean.FALSE")) : (attrMethod.getParameterTypes()[0].equals(Long.class) ? "Long.valueOf(" + attribute.getValue() + "L)" : (attrMethod.getParameterTypes()[0].equals(Integer.class) ? "Integer.valueOf(" + attribute.getValue() + ")" : (EnumInterface.class.isAssignableFrom(attrMethod.getParameterTypes()[0]) ? this.toEnumAttributeValue(attrMethod.getParameterTypes()[0], attribute) : null)))));
        if (attrMethod == null || attrVal == null) {
            this.appendable.append(".addAttr(").append("\"").append(attrKey).append("\",").append(this.convertJavaStringContentToJavaDeclarableString(this.escapeInAttribute(attribute.getValue()))).append(")");
        } else {
            this.appendable.append(".").append(attrMethod.getName()).append("(").append((CharSequence)attrVal).append(")");
        }
    }

    public void tail(Node node, int depth) {
        try {
            if (!this.isUncloseable(node)) {
                this.appendable.append("        ");
                for (int spaceIndex = 0; spaceIndex < depth * 4; ++spaceIndex) {
                    this.appendable.append(' ');
                }
                this.appendable.append(".__()").append(" //").append(node.nodeName()).append("\n");
            }
            if (depth == 0) {
                this.appendFooter();
            }
        }
        catch (IOException ioe) {
            LOGGER.warning("Failed to append the Java source code, cause: " + ioe.getMessage());
        }
    }
}

