/*
 * Decompiled with CFR 0.152.
 */
package htmlflow.visitor;

import com.google.common.html.HtmlEscapers;
import htmlflow.exceptions.HtmlFlowAppendException;
import htmlflow.visitor.Indentation;
import htmlflow.visitor.Tags;
import java.io.IOException;
import org.xmlet.htmlapifaster.Area;
import org.xmlet.htmlapifaster.Base;
import org.xmlet.htmlapifaster.Br;
import org.xmlet.htmlapifaster.Col;
import org.xmlet.htmlapifaster.Element;
import org.xmlet.htmlapifaster.ElementVisitor;
import org.xmlet.htmlapifaster.Embed;
import org.xmlet.htmlapifaster.Hr;
import org.xmlet.htmlapifaster.Img;
import org.xmlet.htmlapifaster.Input;
import org.xmlet.htmlapifaster.Link;
import org.xmlet.htmlapifaster.Meta;
import org.xmlet.htmlapifaster.Param;
import org.xmlet.htmlapifaster.Root;
import org.xmlet.htmlapifaster.Source;
import org.xmlet.htmlapifaster.Text;

public abstract class HtmlVisitor
extends ElementVisitor {
    protected Appendable out;
    protected int depth;
    protected boolean isClosed = true;
    public final boolean isIndented;

    public final int getDepth() {
        return this.depth;
    }

    public final void setDepth(int v) {
        this.depth = v;
    }

    public final void setIsClosed(boolean isClosed) {
        this.isClosed = isClosed;
    }

    HtmlVisitor(Appendable out, boolean isIndented) {
        this.out = out;
        this.isIndented = isIndented;
    }

    public final Appendable out() {
        return this.out;
    }

    public final HtmlVisitor setAppendable(Appendable appendable) {
        this.out = appendable;
        return this;
    }

    public final void write(String text) {
        try {
            this.out.append(text);
        }
        catch (IOException e) {
            throw new HtmlFlowAppendException(e);
        }
    }

    protected final void write(char c) {
        try {
            this.out.append(c);
        }
        catch (IOException e) {
            throw new HtmlFlowAppendException(e);
        }
    }

    public final void newlineAndIndent() {
        if (this.isClosed) {
            if (this.isIndented) {
                this.write(Indentation.tabs(this.depth));
            }
        } else {
            ++this.depth;
            if (this.isIndented) {
                this.write(Indentation.closedTabs(this.depth));
            } else {
                this.write('>');
            }
            this.isClosed = true;
        }
    }

    public final void visitElement(Element element) {
        this.newlineAndIndent();
        Tags.beginTag(this.out, element.getName());
        this.isClosed = false;
    }

    public final void visitParent(Element element) {
        --this.depth;
        this.newlineAndIndent();
        Tags.endTag(this.out, element.getName());
    }

    protected final void visitParentOnVoidElements() {
        if (!this.isClosed) {
            this.write('>');
        }
        this.isClosed = true;
    }

    public final void visitAttribute(String attributeName, String attributeValue) {
        if (this.isClosed) {
            throw new IllegalStateException("Cannot add attributes after!!!");
        }
        Tags.addAttribute(this.out, attributeName, attributeValue);
    }

    public final void visitAttributeBoolean(String name, String value) {
        if (!value.equals("false")) {
            Tags.addAttribute(this.out, name, value);
        }
    }

    public final <R> void visitText(Text<? extends Element, R> text) {
        this.newlineAndIndent();
        this.write(HtmlEscapers.htmlEscaper().escape(text.getValue()));
    }

    public final <R> void visitRaw(Text<? extends Element, R> text) {
        this.newlineAndIndent();
        this.write(text.getValue());
    }

    public final <R> void visitComment(Text<? extends Element, R> text) {
        this.newlineAndIndent();
        Tags.addComment(this.out, text.getValue());
    }

    public abstract void resolve(Object var1);

    public abstract HtmlVisitor clone(boolean var1);

    public final <Z extends Element> void visitElementRoot(Root<Z> var1) {
    }

    public final <Z extends Element> void visitParentRoot(Root<Z> var1) {
    }

    public final <Z extends Element> void visitParentHr(Hr<Z> element) {
        this.visitParentOnVoidElements();
    }

    public final <Z extends Element> void visitParentEmbed(Embed<Z> element) {
        this.visitParentOnVoidElements();
    }

    public final <Z extends Element> void visitParentInput(Input<Z> element) {
        this.visitParentOnVoidElements();
    }

    public final <Z extends Element> void visitParentMeta(Meta<Z> element) {
        this.visitParentOnVoidElements();
    }

    public final <Z extends Element> void visitParentBr(Br<Z> element) {
        this.visitParentOnVoidElements();
    }

    public final <Z extends Element> void visitParentCol(Col<Z> element) {
        this.visitParentOnVoidElements();
    }

    public final <Z extends Element> void visitParentSource(Source<Z> element) {
        this.visitParentOnVoidElements();
    }

    public final <Z extends Element> void visitParentImg(Img<Z> element) {
        this.visitParentOnVoidElements();
    }

    public final <Z extends Element> void visitParentArea(Area<Z> element) {
        this.visitParentOnVoidElements();
    }

    public final <Z extends Element> void visitParentLink(Link<Z> element) {
        this.visitParentOnVoidElements();
    }

    public final <Z extends Element> void visitParentParam(Param<Z> element) {
        this.visitParentOnVoidElements();
    }

    public final <Z extends Element> void visitParentBase(Base<Z> element) {
        this.visitParentOnVoidElements();
    }
}

