/*
 * Decompiled with CFR 0.152.
 */
package htmlflow.visitor;

import htmlflow.continuations.HtmlContinuation;
import htmlflow.continuations.HtmlContinuationSyncCloseAndIndent;
import htmlflow.continuations.HtmlContinuationSyncDynamic;
import htmlflow.continuations.HtmlContinuationSyncStatic;
import htmlflow.visitor.HtmlVisitor;
import java.lang.reflect.Field;
import java.util.function.BiConsumer;
import org.xmlet.htmlapifaster.Element;
import org.xmlet.htmlapifaster.SuspendConsumer;
import org.xmlet.htmlapifaster.async.AwaitConsumer;

public class PreprocessingVisitor
extends HtmlVisitor {
    private static final String NOT_SUPPORTED_ERROR = "This is a PreprocessingVisitor used to compile templates and not intended to support HTML views!";
    protected int staticBlockIndex = 0;
    protected HtmlContinuation first;
    protected HtmlContinuation last;

    public PreprocessingVisitor(boolean isIndented) {
        super(new StringBuilder(), isIndented);
    }

    public final StringBuilder sb() {
        return (StringBuilder)this.out;
    }

    public final HtmlContinuation getFirst() {
        return this.first;
    }

    public <E extends Element, U> void visitDynamic(E element, BiConsumer<E, U> dynamicHtmlBlock) {
        HtmlContinuationSyncDynamic<E, U> dynamicCont = new HtmlContinuationSyncDynamic<E, U>(this.depth, this.isClosed, element, dynamicHtmlBlock, this, new HtmlContinuationSyncCloseAndIndent(this));
        this.chainContinuationStatic(dynamicCont);
        this.indentAndAdvanceStaticBlockIndex();
    }

    public <M, E extends Element> void visitAwait(E element, AwaitConsumer<E, M> asyncAction) {
        throw new UnsupportedOperationException("Await not allowed in HtmlView. Should use viewAsync() or viewSuspend() to manage an asynchronous view.");
    }

    public <M, E extends Element> void visitSuspending(E element, SuspendConsumer<E, M> suspendAction) {
        throw new UnsupportedOperationException("Suspend not allowed in HtmlView. Should use viewAsync() or viewSuspend() to manage an asynchronous view.");
    }

    protected final void chainContinuationStatic(HtmlContinuation nextContinuation) {
        String staticHtml = this.sb().substring(this.staticBlockIndex);
        String staticHtmlTrimmed = staticHtml.trim();
        HtmlContinuationSyncStatic staticCont = new HtmlContinuationSyncStatic(staticHtmlTrimmed, this, nextContinuation);
        if (this.first == null) {
            this.first = staticCont;
        } else {
            HtmlContinuationSetter.setNext(this.last, staticCont);
        }
        this.last = nextContinuation.next;
    }

    protected final void indentAndAdvanceStaticBlockIndex() {
        this.newlineAndIndent();
        this.staticBlockIndex = this.sb().length();
    }

    @Override
    public void resolve(Object model) {
        HtmlContinuation htmlContinuation;
        String staticHtml = this.sb().substring(this.staticBlockIndex);
        HtmlContinuationSyncStatic staticCont = new HtmlContinuationSyncStatic(staticHtml.trim(), this, null);
        if (this.first == null) {
            this.first = staticCont;
            htmlContinuation = this.first;
        } else {
            htmlContinuation = HtmlContinuationSetter.setNext(this.last, staticCont);
        }
        this.last = htmlContinuation;
    }

    @Override
    public final HtmlVisitor clone(boolean isIndented) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_ERROR);
    }

    public static class HtmlContinuationSetter {
        static final Field fieldNext;

        private HtmlContinuationSetter() {
        }

        public static HtmlContinuation setNext(HtmlContinuation cont, HtmlContinuation next) {
            try {
                fieldNext.set(cont, next);
                return next;
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }

        static {
            try {
                fieldNext = HtmlContinuation.class.getDeclaredField("next");
                fieldNext.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

