/*
 * Decompiled with CFR 0.152.
 */
package org.xmlet.xsdparser.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xmlet.xsdparser.core.utils.UnsolvedReferenceItem;
import org.xmlet.xsdparser.xsdelements.XsdAll;
import org.xmlet.xsdparser.xsdelements.XsdAnnotation;
import org.xmlet.xsdparser.xsdelements.XsdAppInfo;
import org.xmlet.xsdparser.xsdelements.XsdAttribute;
import org.xmlet.xsdparser.xsdelements.XsdAttributeGroup;
import org.xmlet.xsdparser.xsdelements.XsdChoice;
import org.xmlet.xsdparser.xsdelements.XsdComplexContent;
import org.xmlet.xsdparser.xsdelements.XsdComplexType;
import org.xmlet.xsdparser.xsdelements.XsdDocumentation;
import org.xmlet.xsdparser.xsdelements.XsdElement;
import org.xmlet.xsdparser.xsdelements.XsdExtension;
import org.xmlet.xsdparser.xsdelements.XsdGroup;
import org.xmlet.xsdparser.xsdelements.XsdImport;
import org.xmlet.xsdparser.xsdelements.XsdInclude;
import org.xmlet.xsdparser.xsdelements.XsdList;
import org.xmlet.xsdparser.xsdelements.XsdNamedElements;
import org.xmlet.xsdparser.xsdelements.XsdRestriction;
import org.xmlet.xsdparser.xsdelements.XsdSchema;
import org.xmlet.xsdparser.xsdelements.XsdSequence;
import org.xmlet.xsdparser.xsdelements.XsdSimpleContent;
import org.xmlet.xsdparser.xsdelements.XsdSimpleType;
import org.xmlet.xsdparser.xsdelements.XsdUnion;
import org.xmlet.xsdparser.xsdelements.elementswrapper.NamedConcreteElement;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ReferenceBase;
import org.xmlet.xsdparser.xsdelements.elementswrapper.UnsolvedReference;
import org.xmlet.xsdparser.xsdelements.exceptions.ParsingException;
import org.xmlet.xsdparser.xsdelements.xsdrestrictions.XsdEnumeration;
import org.xmlet.xsdparser.xsdelements.xsdrestrictions.XsdFractionDigits;
import org.xmlet.xsdparser.xsdelements.xsdrestrictions.XsdLength;
import org.xmlet.xsdparser.xsdelements.xsdrestrictions.XsdMaxExclusive;
import org.xmlet.xsdparser.xsdelements.xsdrestrictions.XsdMaxInclusive;
import org.xmlet.xsdparser.xsdelements.xsdrestrictions.XsdMaxLength;
import org.xmlet.xsdparser.xsdelements.xsdrestrictions.XsdMinExclusive;
import org.xmlet.xsdparser.xsdelements.xsdrestrictions.XsdMinInclusive;
import org.xmlet.xsdparser.xsdelements.xsdrestrictions.XsdMinLength;
import org.xmlet.xsdparser.xsdelements.xsdrestrictions.XsdPattern;
import org.xmlet.xsdparser.xsdelements.xsdrestrictions.XsdTotalDigits;
import org.xmlet.xsdparser.xsdelements.xsdrestrictions.XsdWhiteSpace;

public class XsdParser {
    private static final Map<String, BiFunction<XsdParser, Node, ReferenceBase>> parseMappers = new HashMap<String, BiFunction<XsdParser, Node, ReferenceBase>>();
    private static final Map<String, String> xsdTypesToJava = new HashMap<String, String>();
    private List<ReferenceBase> parseElements = new ArrayList<ReferenceBase>();
    private List<UnsolvedReference> unsolvedElements = new ArrayList<UnsolvedReference>();
    private List<UnsolvedReferenceItem> parserUnsolvedElementsMap = new ArrayList<UnsolvedReferenceItem>();
    private List<String> schemaLocations = new ArrayList<String>();

    public XsdParser(String filePath) {
        this.schemaLocations.add(filePath);
        for (int index = 0; this.schemaLocations.size() > index; ++index) {
            String schemaLocation = this.schemaLocations.get(index);
            this.parseFile(schemaLocation);
        }
        this.resolveRefs();
    }

    private void parseFile(String filePath) {
        try {
            if (!new File(filePath).exists()) {
                throw new FileNotFoundException();
            }
            Node schemaNode = this.getSchemaNode(filePath);
            if (!this.isXsdSchema(schemaNode)) {
                throw new ParsingException("The top level element of a XSD file should be the xsd:schema node.");
            }
            XsdSchema.parse(this, schemaNode);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Exception while parsing.", e);
        }
    }

    private boolean isXsdSchema(Node node) {
        String schemaNodeName = node.getNodeName();
        return schemaNodeName.equals("xsd:schema") || schemaNodeName.equals("xs:schema");
    }

    private Node getSchemaNode(String filePath) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(filePath);
        doc.getDocumentElement().normalize();
        return doc.getFirstChild();
    }

    private void resolveRefs() {
        Map<String, List<NamedConcreteElement>> concreteElementsMap = this.parseElements.stream().filter(concreteElement -> concreteElement instanceof NamedConcreteElement).map(concreteElement -> (NamedConcreteElement)concreteElement).collect(Collectors.groupingBy(NamedConcreteElement::getName));
        HashMap typeReferredElements = new HashMap();
        this.unsolvedElements.forEach(unsolvedElement -> this.replaceUnsolvedReference(concreteElementsMap, (UnsolvedReference)unsolvedElement));
    }

    private void replaceUnsolvedReference(Map<String, List<NamedConcreteElement>> concreteElementsMap, UnsolvedReference unsolvedReference) {
        List<NamedConcreteElement> concreteElements;
        int n;
        if (unsolvedReference.getRef().equals("matchingOperations") && unsolvedReference.getParent() instanceof XsdComplexType && ((XsdComplexType)unsolvedReference.getParent()).getName() != null && ((XsdComplexType)unsolvedReference.getParent()).getName().equals("matching")) {
            n = 5;
        }
        if (unsolvedReference.getRef().equals("matching") && unsolvedReference.getParent() instanceof XsdElement) {
            n = 5;
        }
        if ((concreteElements = concreteElementsMap.get(unsolvedReference.getRef())) != null) {
            Map<String, String> oldElementAttributes = unsolvedReference.getElement().getElementFieldsMap();
            for (NamedConcreteElement concreteElement : concreteElements) {
                NamedConcreteElement substitutionElementWrapper;
                if (!unsolvedReference.isTypeRef()) {
                    XsdNamedElements substitutionElement = concreteElement.getElement().clone(oldElementAttributes);
                    substitutionElementWrapper = (NamedConcreteElement)ReferenceBase.createFromXsd(substitutionElement);
                } else {
                    substitutionElementWrapper = concreteElement;
                }
                unsolvedReference.getParent().replaceUnsolvedElements(substitutionElementWrapper);
            }
        } else {
            this.storeUnsolvedItem(unsolvedReference);
        }
    }

    private void storeUnsolvedItem(UnsolvedReference unsolvedReference) {
        if (this.parserUnsolvedElementsMap.isEmpty()) {
            this.parserUnsolvedElementsMap.add(new UnsolvedReferenceItem(unsolvedReference));
        } else {
            Optional<UnsolvedReferenceItem> innerEntry = this.parserUnsolvedElementsMap.stream().filter(unsolvedReferenceObj -> unsolvedReferenceObj.getUnsolvedReference().getRef().equals(unsolvedReference.getRef())).findFirst();
            if (innerEntry.isPresent()) {
                innerEntry.ifPresent(entry -> entry.getParents().add(unsolvedReference.getParent()));
            } else {
                this.parserUnsolvedElementsMap.add(new UnsolvedReferenceItem(unsolvedReference));
            }
        }
    }

    public List<UnsolvedReferenceItem> getUnsolvedReferences() {
        return this.parserUnsolvedElementsMap;
    }

    public Stream<XsdElement> getResultXsdElements() {
        ArrayList elements = new ArrayList();
        this.getResultXsdSchemas().forEach(schema -> schema.getChildrenElements().forEach(elements::add));
        return elements.stream();
    }

    public Stream<XsdSchema> getResultXsdSchemas() {
        return this.parseElements.stream().filter(element -> element.getElement() instanceof XsdSchema).map(element -> (XsdSchema)element.getElement());
    }

    public void addUnsolvedReference(UnsolvedReference unsolvedReference) {
        this.unsolvedElements.add(unsolvedReference);
    }

    public void addFileToParse(String schemaLocation) {
        if (!this.schemaLocations.contains(schemaLocation)) {
            this.schemaLocations.add(schemaLocation);
        }
    }

    public static Map<String, String> getXsdTypesToJava() {
        return xsdTypesToJava;
    }

    public static Map<String, BiFunction<XsdParser, Node, ReferenceBase>> getParseMappers() {
        return parseMappers;
    }

    public void addParsedElement(ReferenceBase wrappedElement) {
        this.parseElements.add(wrappedElement);
    }

    static {
        parseMappers.put("xsd:all", XsdAll::parse);
        parseMappers.put("xs:all", XsdAll::parse);
        parseMappers.put("xsd:attribute", XsdAttribute::parse);
        parseMappers.put("xs:attribute", XsdAttribute::parse);
        parseMappers.put("xsd:attributeGroup", XsdAttributeGroup::parse);
        parseMappers.put("xs:attributeGroup", XsdAttributeGroup::parse);
        parseMappers.put("xsd:choice", XsdChoice::parse);
        parseMappers.put("xs:choice", XsdChoice::parse);
        parseMappers.put("xsd:complexType", XsdComplexType::parse);
        parseMappers.put("xs:complexType", XsdComplexType::parse);
        parseMappers.put("xsd:element", XsdElement::parse);
        parseMappers.put("xs:element", XsdElement::parse);
        parseMappers.put("xsd:group", XsdGroup::parse);
        parseMappers.put("xs:group", XsdGroup::parse);
        parseMappers.put("xsd:include", XsdInclude::parse);
        parseMappers.put("xs:include", XsdInclude::parse);
        parseMappers.put("xsd:import", XsdImport::parse);
        parseMappers.put("xs:import", XsdImport::parse);
        parseMappers.put("xsd:sequence", XsdSequence::parse);
        parseMappers.put("xs:sequence", XsdSequence::parse);
        parseMappers.put("xsd:simpleType", XsdSimpleType::parse);
        parseMappers.put("xs:simpleType", XsdSimpleType::parse);
        parseMappers.put("xsd:list", XsdList::parse);
        parseMappers.put("xs:list", XsdList::parse);
        parseMappers.put("xsd:restriction", XsdRestriction::parse);
        parseMappers.put("xs:restriction", XsdRestriction::parse);
        parseMappers.put("xsd:union", XsdUnion::parse);
        parseMappers.put("xs:union", XsdUnion::parse);
        parseMappers.put("xsd:annotation", XsdAnnotation::parse);
        parseMappers.put("xs:annotation", XsdAnnotation::parse);
        parseMappers.put("xsd:appinfo", XsdAppInfo::parse);
        parseMappers.put("xs:appinfo", XsdAppInfo::parse);
        parseMappers.put("xsd:complexContent", XsdComplexContent::parse);
        parseMappers.put("xs:complexContent", XsdComplexContent::parse);
        parseMappers.put("xsd:documentation", XsdDocumentation::parse);
        parseMappers.put("xs:documentation", XsdDocumentation::parse);
        parseMappers.put("xsd:extension", XsdExtension::parse);
        parseMappers.put("xs:extension", XsdExtension::parse);
        parseMappers.put("xsd:simpleContent", XsdSimpleContent::parse);
        parseMappers.put("xs:simpleContent", XsdSimpleContent::parse);
        parseMappers.put("xsd:enumeration", XsdEnumeration::parse);
        parseMappers.put("xs:enumeration", XsdEnumeration::parse);
        parseMappers.put("xsd:fractionDigits", XsdFractionDigits::parse);
        parseMappers.put("xs:fractionDigits", XsdFractionDigits::parse);
        parseMappers.put("xsd:length", XsdLength::parse);
        parseMappers.put("xs:length", XsdLength::parse);
        parseMappers.put("xsd:maxExclusive", XsdMaxExclusive::parse);
        parseMappers.put("xs:maxExclusive", XsdMaxExclusive::parse);
        parseMappers.put("xsd:maxInclusive", XsdMaxInclusive::parse);
        parseMappers.put("xs:maxInclusive", XsdMaxInclusive::parse);
        parseMappers.put("xsd:maxLength", XsdMaxLength::parse);
        parseMappers.put("xs:maxLength", XsdMaxLength::parse);
        parseMappers.put("xsd:minExclusive", XsdMinExclusive::parse);
        parseMappers.put("xs:minExclusive", XsdMinExclusive::parse);
        parseMappers.put("xsd:minInclusive", XsdMinInclusive::parse);
        parseMappers.put("xs:minInclusive", XsdMinInclusive::parse);
        parseMappers.put("xsd:minLength", XsdMinLength::parse);
        parseMappers.put("xs:minLength", XsdMinLength::parse);
        parseMappers.put("xsd:pattern", XsdPattern::parse);
        parseMappers.put("xs:pattern", XsdPattern::parse);
        parseMappers.put("xsd:totalDigits", XsdTotalDigits::parse);
        parseMappers.put("xs:totalDigits", XsdTotalDigits::parse);
        parseMappers.put("xsd:whiteSpace", XsdWhiteSpace::parse);
        parseMappers.put("xs:whiteSpace", XsdWhiteSpace::parse);
        String string = "String";
        String xmlGregorianCalendar = "XMLGregorianCalendar";
        String duration = "Duration";
        String bigInteger = "BigInteger";
        String integer = "Integer";
        String shortString = "Short";
        String qName = "QName";
        String longString = "Long";
        String byteString = "Byte";
        xsdTypesToJava.put("xsd:anyURI", string);
        xsdTypesToJava.put("xs:anyURI", string);
        xsdTypesToJava.put("xsd:boolean", "Boolean");
        xsdTypesToJava.put("xs:boolean", "Boolean");
        xsdTypesToJava.put("xsd:date", xmlGregorianCalendar);
        xsdTypesToJava.put("xs:date", xmlGregorianCalendar);
        xsdTypesToJava.put("xsd:dateTime", xmlGregorianCalendar);
        xsdTypesToJava.put("xs:dateTime", xmlGregorianCalendar);
        xsdTypesToJava.put("xsd:time", xmlGregorianCalendar);
        xsdTypesToJava.put("xs:time", xmlGregorianCalendar);
        xsdTypesToJava.put("xsd:duration", duration);
        xsdTypesToJava.put("xs:duration", duration);
        xsdTypesToJava.put("xsd:dayTimeDuration", duration);
        xsdTypesToJava.put("xs:dayTimeDuration", duration);
        xsdTypesToJava.put("xsd:yearMonthDuration", duration);
        xsdTypesToJava.put("xs:yearMonthDuration", duration);
        xsdTypesToJava.put("xsd:gDay", xmlGregorianCalendar);
        xsdTypesToJava.put("xs:gDay", xmlGregorianCalendar);
        xsdTypesToJava.put("xsd:gMonth", xmlGregorianCalendar);
        xsdTypesToJava.put("xs:gMonth", xmlGregorianCalendar);
        xsdTypesToJava.put("xsd:gMonthDay", xmlGregorianCalendar);
        xsdTypesToJava.put("xs:gMonthDay", xmlGregorianCalendar);
        xsdTypesToJava.put("xsd:gYear", xmlGregorianCalendar);
        xsdTypesToJava.put("xs:gYear", xmlGregorianCalendar);
        xsdTypesToJava.put("xsd:gYearMonth", xmlGregorianCalendar);
        xsdTypesToJava.put("xs:gYearMonth", xmlGregorianCalendar);
        xsdTypesToJava.put("xsd:decimal", "BigDecimal");
        xsdTypesToJava.put("xs:decimal", "BigDecimal");
        xsdTypesToJava.put("xsd:integer", bigInteger);
        xsdTypesToJava.put("xs:integer", bigInteger);
        xsdTypesToJava.put("xsd:nonPositiveInteger", bigInteger);
        xsdTypesToJava.put("xs:nonPositiveInteger", bigInteger);
        xsdTypesToJava.put("xsd:negativeInteger", bigInteger);
        xsdTypesToJava.put("xs:negativeInteger", bigInteger);
        xsdTypesToJava.put("xsd:long", longString);
        xsdTypesToJava.put("xs:long", longString);
        xsdTypesToJava.put("xsd:int", integer);
        xsdTypesToJava.put("xs:int", integer);
        xsdTypesToJava.put("xsd:short", shortString);
        xsdTypesToJava.put("xs:short", shortString);
        xsdTypesToJava.put("xsd:byte", byteString);
        xsdTypesToJava.put("xs:byte", byteString);
        xsdTypesToJava.put("xsd:nonNegativeInteger", bigInteger);
        xsdTypesToJava.put("xs:nonNegativeInteger", bigInteger);
        xsdTypesToJava.put("xsd:unsignedLong", bigInteger);
        xsdTypesToJava.put("xs:unsignedLong", bigInteger);
        xsdTypesToJava.put("xsd:unsignedInt", longString);
        xsdTypesToJava.put("xs:unsignedInt", longString);
        xsdTypesToJava.put("xsd:unsignedShort", integer);
        xsdTypesToJava.put("xs:unsignedShort", integer);
        xsdTypesToJava.put("xsd:unsignedByte", shortString);
        xsdTypesToJava.put("xs:unsignedByte", shortString);
        xsdTypesToJava.put("xsd:positiveInteger", bigInteger);
        xsdTypesToJava.put("xs:positiveInteger", bigInteger);
        xsdTypesToJava.put("xsd:double", "Double");
        xsdTypesToJava.put("xs:double", "Double");
        xsdTypesToJava.put("xsd:float", "Float");
        xsdTypesToJava.put("xs:float", "Float");
        xsdTypesToJava.put("xsd:QName", qName);
        xsdTypesToJava.put("xs:QName", qName);
        xsdTypesToJava.put("xsd:NOTATION", qName);
        xsdTypesToJava.put("xs:NOTATION", qName);
        xsdTypesToJava.put("xsd:string", string);
        xsdTypesToJava.put("xs:string", string);
        xsdTypesToJava.put("xsd:normalizedString", string);
        xsdTypesToJava.put("xs:normalizedString", string);
        xsdTypesToJava.put("xsd:token", string);
        xsdTypesToJava.put("xs:token", string);
        xsdTypesToJava.put("xsd:language", string);
        xsdTypesToJava.put("xs:language", string);
        xsdTypesToJava.put("xsd:NMTOKEN", string);
        xsdTypesToJava.put("xs:NMTOKEN", string);
        xsdTypesToJava.put("xsd:Name", string);
        xsdTypesToJava.put("xs:Name", string);
        xsdTypesToJava.put("xsd:NCName", string);
        xsdTypesToJava.put("xs:NCName", string);
        xsdTypesToJava.put("xsd:ID", string);
        xsdTypesToJava.put("xs:ID", string);
        xsdTypesToJava.put("xsd:IDREF", string);
        xsdTypesToJava.put("xs:IDREF", string);
        xsdTypesToJava.put("xsd:ENTITY", string);
        xsdTypesToJava.put("xs:ENTITY", string);
        xsdTypesToJava.put("xsd:untypedAtomic", string);
        xsdTypesToJava.put("xs:untypedAtomic", string);
    }
}

