/*
 * Decompiled with CFR 0.152.
 */
package org.xmlet.xsdparser.xsdelements;

import java.util.Map;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import org.w3c.dom.Node;
import org.xmlet.xsdparser.core.XsdParser;
import org.xmlet.xsdparser.xsdelements.AttributeValidations;
import org.xmlet.xsdparser.xsdelements.XsdElement;
import org.xmlet.xsdparser.xsdelements.XsdMultipleElements;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ReferenceBase;
import org.xmlet.xsdparser.xsdelements.visitors.XsdAbstractElementVisitor;
import org.xmlet.xsdparser.xsdelements.visitors.XsdAllVisitor;

public class XsdAll
extends XsdMultipleElements {
    public static final String XSD_TAG = "xsd:all";
    public static final String XS_TAG = "xs:all";
    private final XsdAllVisitor visitor = new XsdAllVisitor(this);
    private Integer minOccurs;
    private Integer maxOccurs;

    private XsdAll(@NotNull XsdParser parser, @NotNull Map<String, String> elementFieldsMapParam) {
        super(parser, elementFieldsMapParam);
    }

    @Override
    public void setFields(@NotNull Map<String, String> elementFieldsMapParam) {
        super.setFields(elementFieldsMapParam);
        this.minOccurs = AttributeValidations.validateNonNegativeInteger(XSD_TAG, "minOccurs", this.elementFieldsMap.getOrDefault("minOccurs", "1"));
        this.maxOccurs = AttributeValidations.validateNonNegativeInteger(XSD_TAG, "maxOccurs", this.elementFieldsMap.getOrDefault("maxOccurs", "1"));
    }

    @Override
    public void accept(XsdAbstractElementVisitor visitorParam) {
        super.accept(visitorParam);
        visitorParam.visit(this);
    }

    @Override
    public XsdAllVisitor getVisitor() {
        return this.visitor;
    }

    public static ReferenceBase parse(@NotNull XsdParser parser, Node node) {
        return XsdAll.xsdParseSkeleton(node, new XsdAll(parser, XsdAll.convertNodeMap(node.getAttributes())));
    }

    public Integer getMinOccurs() {
        return this.minOccurs;
    }

    public Integer getMaxOccurs() {
        return this.maxOccurs;
    }

    public Stream<XsdElement> getChildrenElements() {
        return this.getXsdElements().filter(element -> element instanceof XsdElement).map(element -> (XsdElement)element);
    }
}

