/*
 * Decompiled with CFR 0.152.
 */
package org.xmlet.xsdparser.xsdelements;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import org.w3c.dom.Node;
import org.xmlet.xsdparser.core.XsdParser;
import org.xmlet.xsdparser.xsdelements.XsdAbstractElement;
import org.xmlet.xsdparser.xsdelements.XsdAll;
import org.xmlet.xsdparser.xsdelements.XsdAnnotatedElements;
import org.xmlet.xsdparser.xsdelements.XsdAttribute;
import org.xmlet.xsdparser.xsdelements.XsdAttributeGroup;
import org.xmlet.xsdparser.xsdelements.XsdChoice;
import org.xmlet.xsdparser.xsdelements.XsdElement;
import org.xmlet.xsdparser.xsdelements.XsdGroup;
import org.xmlet.xsdparser.xsdelements.XsdMultipleElements;
import org.xmlet.xsdparser.xsdelements.XsdNamedElements;
import org.xmlet.xsdparser.xsdelements.XsdSequence;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ConcreteElement;
import org.xmlet.xsdparser.xsdelements.elementswrapper.NamedConcreteElement;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ReferenceBase;
import org.xmlet.xsdparser.xsdelements.elementswrapper.UnsolvedReference;
import org.xmlet.xsdparser.xsdelements.visitors.XsdAbstractElementVisitor;
import org.xmlet.xsdparser.xsdelements.visitors.XsdExtensionVisitor;

public class XsdExtension
extends XsdAnnotatedElements {
    public static final String XSD_TAG = "xsd:extension";
    public static final String XS_TAG = "xs:extension";
    private XsdExtensionVisitor visitor = new XsdExtensionVisitor(this);
    private ReferenceBase childElement;
    private ReferenceBase base;

    private XsdExtension(@NotNull XsdParser parser, @NotNull Map<String, String> elementFieldsMapParam) {
        super(parser, elementFieldsMapParam);
    }

    @Override
    public void setFields(@NotNull Map<String, String> elementFieldsMapParam) {
        super.setFields(elementFieldsMapParam);
        String baseValue = this.elementFieldsMap.getOrDefault("base", null);
        if (baseValue != null) {
            this.base = new UnsolvedReference(baseValue, new XsdElement(this, this.parser, new HashMap<String, String>()));
            this.parser.addUnsolvedReference((UnsolvedReference)this.base);
        }
    }

    @Override
    public void replaceUnsolvedElements(NamedConcreteElement element) {
        super.replaceUnsolvedElements(element);
        XsdNamedElements elem = element.getElement();
        String elemName = elem.getRawName();
        if (this.base instanceof UnsolvedReference && elem instanceof XsdElement && ((UnsolvedReference)this.base).getRef().equals(elemName)) {
            this.base = element;
        }
        if (this.childElement instanceof UnsolvedReference && elem instanceof XsdGroup && ((UnsolvedReference)this.childElement).getRef().equals(elemName)) {
            this.childElement = element;
        }
        this.visitor.replaceUnsolvedAttributes(element);
    }

    @Override
    public XsdExtensionVisitor getVisitor() {
        return this.visitor;
    }

    @Override
    public void accept(XsdAbstractElementVisitor visitorParam) {
        super.accept(visitorParam);
        visitorParam.visit(this);
    }

    @Override
    public List<ReferenceBase> getElements() {
        return this.childElement == null ? Collections.emptyList() : this.childElement.getElement().getElements();
    }

    public XsdElement getBase() {
        return this.base instanceof ConcreteElement ? (XsdElement)this.base.getElement() : null;
    }

    public static ReferenceBase parse(@NotNull XsdParser parser, Node node) {
        return XsdExtension.xsdParseSkeleton(node, new XsdExtension(parser, XsdExtension.convertNodeMap(node.getAttributes())));
    }

    public Stream<XsdAttribute> getXsdAttributes() {
        return this.visitor.getXsdAttributes();
    }

    public Stream<XsdAttributeGroup> getXsdAttributeGroup() {
        return this.visitor.getXsdAttributeGroup();
    }

    public XsdAbstractElement getXsdChildElement() {
        if (this.childElement == null) {
            return null;
        }
        return this.childElement instanceof UnsolvedReference ? null : this.childElement.getElement();
    }

    public void setChildElement(ReferenceBase childElement) {
        this.childElement = childElement;
    }

    public XsdGroup getChildAsGroup() {
        return this.childElement.getElement() instanceof XsdGroup ? (XsdGroup)this.childElement.getElement() : null;
    }

    public XsdAll getChildAsAll() {
        return this.childrenIsMultipleElement() ? XsdMultipleElements.getChildAsdAll((XsdMultipleElements)this.childElement.getElement()) : null;
    }

    public XsdChoice getChildAsChoice() {
        return this.childrenIsMultipleElement() ? XsdMultipleElements.getChildAsChoice((XsdMultipleElements)this.childElement.getElement()) : null;
    }

    public XsdSequence getChildAsSequence() {
        return this.childrenIsMultipleElement() ? XsdMultipleElements.getChildAsSequence((XsdMultipleElements)this.childElement.getElement()) : null;
    }

    private boolean childrenIsMultipleElement() {
        return this.childElement.getElement() instanceof XsdMultipleElements;
    }
}

