/*
 * Decompiled with CFR 0.152.
 */
package org.xmlet.xsdparser.xsdelements.xsdrestrictions;

import java.util.Map;
import javax.validation.constraints.NotNull;
import org.xmlet.xsdparser.core.XsdParser;
import org.xmlet.xsdparser.xsdelements.AttributeValidations;
import org.xmlet.xsdparser.xsdelements.XsdAnnotatedElements;
import org.xmlet.xsdparser.xsdelements.visitors.XsdAnnotatedElementsVisitor;

public abstract class XsdDoubleRestrictions
extends XsdAnnotatedElements {
    private XsdAnnotatedElementsVisitor visitor = new XsdAnnotatedElementsVisitor(this);
    private String restrictionName;
    private boolean fixed;
    private double value;

    XsdDoubleRestrictions(@NotNull XsdParser parser, @NotNull Map<String, String> elementFieldsMapParam, String restrictionName) {
        super(parser, elementFieldsMapParam);
        this.restrictionName = restrictionName;
    }

    @Override
    public XsdAnnotatedElementsVisitor getVisitor() {
        return this.visitor;
    }

    @Override
    public void setFields(@NotNull Map<String, String> elementFieldsMapParam) {
        super.setFields(elementFieldsMapParam);
        this.fixed = AttributeValidations.validateBoolean(this.elementFieldsMap.getOrDefault("fixed", "false"));
        this.value = AttributeValidations.validateRequiredDouble(this.restrictionName, "value", (String)this.elementFieldsMap.get("value"));
    }

    public static boolean hasDifferentValue(XsdDoubleRestrictions o1, XsdDoubleRestrictions o2) {
        if (o1 == null && o2 == null) {
            return false;
        }
        double o1Value = Double.MAX_VALUE;
        if (o1 != null) {
            o1Value = o1.getValue();
        }
        if (o2 != null) {
            double o2Value = o2.getValue();
            return o2Value == o1Value;
        }
        return false;
    }

    public double getValue() {
        return this.value;
    }

    public boolean isFixed() {
        return this.fixed;
    }
}

