/*
 * Decompiled with CFR 0.152.
 */
package org.xmlet.xsdparser.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xmlet.xsdparser.core.XsdParserCore;
import org.xmlet.xsdparser.core.utils.ConfigEntryData;
import org.xmlet.xsdparser.core.utils.ParseData;
import org.xmlet.xsdparser.core.utils.ParserConfig;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ReferenceBase;
import org.xmlet.xsdparser.xsdelements.exceptions.ParsingException;

public class XsdParserJar
extends XsdParserCore {
    private static ClassLoader classLoader;

    public XsdParserJar(String jarPath, String filePath) {
        this.parse(jarPath, filePath);
    }

    public XsdParserJar(String jarPath, String filePath, ParserConfig config) {
        XsdParserCore.updateConfig(config);
        this.parse(jarPath, filePath);
    }

    private void parse(String jarPath, String filePath) {
        this.setClassLoader(jarPath);
        this.parseJarFile(filePath);
        for (int index = 0; this.schemaLocations.size() > index; ++index) {
            String schemaLocation = (String)this.schemaLocations.get(index);
            this.parseJarFile(schemaLocation);
        }
        this.resolveRefs();
    }

    private void parseJarFile(String filePath) {
        this.currentFile = filePath.replace("\\", "/");
        InputStream inputStream = classLoader.getResourceAsStream(filePath);
        try {
            ConfigEntryData xsdSchemaConfig = XsdParserJar.getParseMappers("schema");
            if (xsdSchemaConfig == null) {
                throw new ParserConfigurationException("XsdSchema not correctly configured.");
            }
            ReferenceBase referenceBase = xsdSchemaConfig.parserFunction.apply(new ParseData(this, this.getSchemaNode(inputStream), xsdSchemaConfig.visitorFunction));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Exception while parsing.", e);
            throw new RuntimeException(e);
        }
    }

    private Node getSchemaNode(InputStream inputStream) throws ParserConfigurationException, IOException, SAXException {
        Document doc = this.getDocumentBuilder().parse(inputStream);
        doc.getDocumentElement().normalize();
        NodeList nodes = doc.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!this.isXsdSchema(node)) continue;
            return node;
        }
        throw new ParsingException("The top level element of a XSD file should be the xsd:schema node.");
    }

    private void setClassLoader(String jarPath) {
        if (!jarPath.endsWith(".jar")) {
            throw new ParsingException("The jarPath received doesn't represent a jar file.");
        }
        ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
        URL url = originalCl.getResource(jarPath);
        if (url == null) {
            try {
                url = new URL("file:/" + jarPath);
            }
            catch (MalformedURLException e) {
                throw new ParsingException("Invalid jar name.");
            }
        }
        URLClassLoader urlCl = URLClassLoader.newInstance(new URL[]{url}, originalCl);
        Thread.currentThread().setContextClassLoader(urlCl);
        classLoader = urlCl;
    }
}

