/*
 * Decompiled with CFR 0.152.
 */
package org.xmlet.xsdparser.xsdelements;

import java.util.Map;
import java.util.function.Function;
import javax.validation.constraints.NotNull;
import org.xmlet.xsdparser.core.XsdParserCore;
import org.xmlet.xsdparser.core.utils.ParseData;
import org.xmlet.xsdparser.xsdelements.AttributeValidations;
import org.xmlet.xsdparser.xsdelements.XsdAbstractElement;
import org.xmlet.xsdparser.xsdelements.XsdMultipleElements;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ReferenceBase;
import org.xmlet.xsdparser.xsdelements.visitors.XsdAbstractElementVisitor;

public class XsdAll
extends XsdMultipleElements {
    public static final String XSD_TAG = "xsd:all";
    public static final String XS_TAG = "xs:all";
    public static final String TAG = "all";
    private Integer minOccurs;
    private Integer maxOccurs;

    private XsdAll(@NotNull XsdParserCore parser, @NotNull Map<String, String> attributesMap, @NotNull Function<XsdAbstractElement, XsdAbstractElementVisitor> visitorFunction) {
        super(parser, attributesMap, visitorFunction);
        this.minOccurs = AttributeValidations.validateNonNegativeInteger(XSD_TAG, "minOccurs", attributesMap.getOrDefault("minOccurs", "1"));
        this.maxOccurs = AttributeValidations.validateNonNegativeInteger(XSD_TAG, "maxOccurs", attributesMap.getOrDefault("maxOccurs", "1"));
    }

    @Override
    public void accept(XsdAbstractElementVisitor visitorParam) {
        super.accept(visitorParam);
        visitorParam.visit(this);
    }

    public static ReferenceBase parse(@NotNull ParseData parseData) {
        return XsdAll.xsdParseSkeleton(parseData.node, new XsdAll(parseData.parserInstance, XsdAll.convertNodeMap(parseData.node.getAttributes()), parseData.visitorFunction));
    }

    @Override
    public XsdAll clone(@NotNull Map<String, String> placeHolderAttributes) {
        placeHolderAttributes.putAll(this.attributesMap);
        XsdAll elementCopy = new XsdAll(this.getParser(), placeHolderAttributes, this.visitorFunction);
        for (ReferenceBase element : this.getElements()) {
            elementCopy.elements.add(ReferenceBase.clone(this.parser, element, elementCopy));
        }
        elementCopy.cloneOf = this;
        elementCopy.setParent(null);
        return elementCopy;
    }

    public Integer getMinOccurs() {
        return this.minOccurs;
    }

    public Integer getMaxOccurs() {
        return this.maxOccurs;
    }
}

