/*
 * Decompiled with CFR 0.152.
 */
package org.xmlet.xsdparser.xsdelements;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.validation.constraints.NotNull;
import org.xmlet.xsdparser.core.XsdParserCore;
import org.xmlet.xsdparser.core.utils.ParseData;
import org.xmlet.xsdparser.xsdelements.AttributeValidations;
import org.xmlet.xsdparser.xsdelements.XsdAbstractElement;
import org.xmlet.xsdparser.xsdelements.XsdBuiltInDataType;
import org.xmlet.xsdparser.xsdelements.XsdComplexType;
import org.xmlet.xsdparser.xsdelements.XsdNamedElements;
import org.xmlet.xsdparser.xsdelements.XsdSchema;
import org.xmlet.xsdparser.xsdelements.XsdSimpleType;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ConcreteElement;
import org.xmlet.xsdparser.xsdelements.elementswrapper.NamedConcreteElement;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ReferenceBase;
import org.xmlet.xsdparser.xsdelements.elementswrapper.UnsolvedReference;
import org.xmlet.xsdparser.xsdelements.enums.BlockEnum;
import org.xmlet.xsdparser.xsdelements.enums.FinalEnum;
import org.xmlet.xsdparser.xsdelements.enums.FormEnum;
import org.xmlet.xsdparser.xsdelements.exceptions.ParsingException;
import org.xmlet.xsdparser.xsdelements.visitors.XsdAbstractElementVisitor;

public class XsdElement
extends XsdNamedElements {
    public static final String XSD_TAG = "xsd:element";
    public static final String XS_TAG = "xs:element";
    public static final String TAG = "element";
    private ReferenceBase complexType;
    private ReferenceBase simpleType;
    private ReferenceBase type;
    private ReferenceBase substitutionGroup;
    private String defaultObj;
    private String fixed;
    private FormEnum form;
    private boolean nillable;
    private boolean abstractObj;
    private BlockEnum block;
    private FinalEnum finalObj;
    private Integer minOccurs;
    private String maxOccurs;
    private static String xsdElementIsXsdSchema = "xsd:element is a xsd:schema element.";

    public XsdElement(@NotNull XsdParserCore parser, @NotNull Map<String, String> attributesMap, @NotNull Function<XsdAbstractElement, XsdAbstractElementVisitor> visitorFunction) {
        super(parser, attributesMap, visitorFunction);
        String typeString = attributesMap.get("type");
        if (typeString != null) {
            if (XsdParserCore.isXsdTypeToJava(typeString)) {
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put("name", typeString);
                this.type = ReferenceBase.createFromXsd(new XsdBuiltInDataType(parser, attributes, this));
            } else {
                this.type = new UnsolvedReference(typeString, new XsdElement(this, this.parser, new HashMap<String, String>(), visitorFunction));
                parser.addUnsolvedReference((UnsolvedReference)this.type);
            }
        }
        String formDefault = AttributeValidations.getFormDefaultValue(this.parent);
        String blockDefault = AttributeValidations.getBlockDefaultValue(this.parent);
        String finalDefault = AttributeValidations.getFinalDefaultValue(this.parent);
        String localSubstitutionGroup = attributesMap.getOrDefault("substitutionGroup", null);
        if (localSubstitutionGroup != null) {
            this.substitutionGroup = new UnsolvedReference(localSubstitutionGroup, new XsdElement(this, this.parser, new HashMap<String, String>(), visitorFunction));
            parser.addUnsolvedReference((UnsolvedReference)this.substitutionGroup);
        }
        this.defaultObj = attributesMap.getOrDefault("default", this.defaultObj);
        this.fixed = attributesMap.getOrDefault("fixed", this.fixed);
        this.form = AttributeValidations.belongsToEnum(FormEnum.QUALIFIED, attributesMap.getOrDefault("form", formDefault));
        this.nillable = AttributeValidations.validateBoolean(attributesMap.getOrDefault("nillable", "false"));
        this.abstractObj = AttributeValidations.validateBoolean(attributesMap.getOrDefault("abstract", "false"));
        this.block = AttributeValidations.belongsToEnum(BlockEnum.ALL, attributesMap.getOrDefault("block", blockDefault));
        this.finalObj = AttributeValidations.belongsToEnum(FinalEnum.ALL, attributesMap.getOrDefault("final", finalDefault));
        this.minOccurs = AttributeValidations.validateNonNegativeInteger(XSD_TAG, "minOccurs", attributesMap.getOrDefault("minOccurs", "1"));
        this.maxOccurs = AttributeValidations.maxOccursValidation(XSD_TAG, attributesMap.getOrDefault("maxOccurs", "1"));
    }

    public XsdElement(XsdAbstractElement parent, @NotNull XsdParserCore parser, @NotNull Map<String, String> elementFieldsMapParam, @NotNull Function<XsdAbstractElement, XsdAbstractElementVisitor> visitorFunction) {
        this(parser, elementFieldsMapParam, visitorFunction);
        this.setParent(parent);
    }

    @Override
    public void validateSchemaRules() {
        super.validateSchemaRules();
        this.rule2();
        this.rule3();
        this.rule4();
        this.rule5();
        this.rule6();
        this.rule7();
    }

    private void rule7() {
        if (this.parent instanceof XsdSchema && this.attributesMap.containsKey("form")) {
            throw new ParsingException("xsd:element element: The form attribute can only be present when the parent of the " + xsdElementIsXsdSchema);
        }
    }

    private void rule6() {
    }

    private void rule5() {
    }

    private void rule4() {
        if (!(this.parent instanceof XsdSchema) && this.substitutionGroup != null) {
            throw new ParsingException("xsd:element element: The substitutionGroup attribute can only be present when the parent of the " + xsdElementIsXsdSchema);
        }
    }

    private void rule3() {
        if (this.parent instanceof XsdSchema && this.attributesMap.containsKey("ref")) {
            throw new ParsingException("xsd:element element: The ref attribute cannot be present when the parent of the " + xsdElementIsXsdSchema);
        }
    }

    private void rule2() {
        if (this.parent instanceof XsdSchema && this.name == null) {
            throw new ParsingException("xsd:element element: The name attribute is required when the parent of the " + xsdElementIsXsdSchema);
        }
    }

    @Override
    public void accept(XsdAbstractElementVisitor visitorParam) {
        super.accept(visitorParam);
        visitorParam.visit(this);
    }

    @Override
    public XsdElement clone(@NotNull Map<String, String> placeHolderAttributes) {
        placeHolderAttributes.putAll(this.attributesMap);
        placeHolderAttributes.remove("type");
        placeHolderAttributes.remove("ref");
        placeHolderAttributes.remove("substitutionGroup");
        XsdElement elementCopy = new XsdElement(this.parent, this.parser, placeHolderAttributes, this.visitorFunction);
        if (this.simpleType != null) {
            elementCopy.simpleType = ReferenceBase.clone(this.parser, this.simpleType, elementCopy);
        }
        if (this.complexType != null) {
            elementCopy.complexType = ReferenceBase.clone(this.parser, this.complexType, elementCopy);
        }
        if (this.substitutionGroup != null) {
            if (this.substitutionGroup instanceof ConcreteElement) {
                elementCopy.substitutionGroup = ReferenceBase.clone(this.parser, this.substitutionGroup, elementCopy);
            } else {
                elementCopy.substitutionGroup = new UnsolvedReference(((UnsolvedReference)this.substitutionGroup).getRef(), new XsdElement(elementCopy, this.parser, new HashMap<String, String>(), this.visitorFunction));
                this.parser.addUnsolvedReference((UnsolvedReference)elementCopy.substitutionGroup);
            }
        }
        if (this.type != null) {
            if (this.type instanceof ConcreteElement) {
                elementCopy.type = ReferenceBase.clone(this.parser, this.type, elementCopy);
            } else {
                elementCopy.type = new UnsolvedReference(((UnsolvedReference)this.type).getRef(), new XsdElement(elementCopy, this.parser, new HashMap<String, String>(), this.visitorFunction));
                this.parser.addUnsolvedReference((UnsolvedReference)elementCopy.type);
            }
        }
        elementCopy.cloneOf = this;
        elementCopy.parent = null;
        return elementCopy;
    }

    @Override
    public void replaceUnsolvedElements(NamedConcreteElement element) {
        boolean isComplexOrSimpleType;
        super.replaceUnsolvedElements(element);
        XsdNamedElements elem = element.getElement();
        boolean bl = isComplexOrSimpleType = elem instanceof XsdComplexType || elem instanceof XsdSimpleType;
        if (this.type instanceof UnsolvedReference && isComplexOrSimpleType && XsdElement.compareReference(element, (UnsolvedReference)this.type)) {
            this.type = element;
        }
        if (this.substitutionGroup instanceof UnsolvedReference && elem instanceof XsdElement && XsdElement.compareReference(element, (UnsolvedReference)this.substitutionGroup)) {
            this.substitutionGroup = element;
        }
    }

    public XsdComplexType getXsdComplexType() {
        return this.complexType == null || this.complexType instanceof UnsolvedReference ? this.getXsdComplexTypeFromType() : (XsdComplexType)this.complexType.getElement();
    }

    public XsdSimpleType getXsdSimpleType() {
        return this.simpleType == null || this.simpleType instanceof UnsolvedReference ? this.getXsdSimpleTypeFromType() : (XsdSimpleType)this.simpleType.getElement();
    }

    private XsdComplexType getXsdComplexTypeFromType() {
        XsdAbstractElement typeElement;
        if (this.type instanceof ConcreteElement && (typeElement = this.type.getElement()) instanceof XsdComplexType) {
            return (XsdComplexType)typeElement;
        }
        return null;
    }

    private XsdSimpleType getXsdSimpleTypeFromType() {
        XsdAbstractElement typeElement;
        if (this.type instanceof ConcreteElement && (typeElement = this.type.getElement()) instanceof XsdSimpleType) {
            return (XsdSimpleType)typeElement;
        }
        return null;
    }

    public XsdNamedElements getTypeAsXsd() {
        if (this.type instanceof NamedConcreteElement) {
            return ((NamedConcreteElement)this.type).getElement();
        }
        return null;
    }

    public XsdComplexType getTypeAsComplexType() {
        XsdAbstractElement baseType;
        if (this.type instanceof NamedConcreteElement && (baseType = this.type.getElement()) instanceof XsdComplexType) {
            return (XsdComplexType)baseType;
        }
        return null;
    }

    public XsdSimpleType getTypeAsSimpleType() {
        XsdAbstractElement baseType;
        if (this.type instanceof NamedConcreteElement && (baseType = this.type.getElement()) instanceof XsdSimpleType) {
            return (XsdSimpleType)baseType;
        }
        return null;
    }

    public XsdBuiltInDataType getTypeAsBuiltInDataType() {
        XsdAbstractElement baseType;
        if (this.type instanceof NamedConcreteElement && (baseType = this.type.getElement()) instanceof XsdBuiltInDataType) {
            return (XsdBuiltInDataType)baseType;
        }
        return null;
    }

    public static ReferenceBase parse(@NotNull ParseData parseData) {
        return XsdElement.xsdParseSkeleton(parseData.node, new XsdElement(parseData.parserInstance, XsdElement.convertNodeMap(parseData.node.getAttributes()), parseData.visitorFunction));
    }

    public String getFinal() {
        return this.finalObj.getValue();
    }

    public boolean isNillable() {
        return this.nillable;
    }

    public Integer getMinOccurs() {
        return this.minOccurs;
    }

    public String getMaxOccurs() {
        return this.maxOccurs;
    }

    public boolean isAbstractObj() {
        return this.abstractObj;
    }

    public void setComplexType(ReferenceBase complexType) {
        this.complexType = complexType;
    }

    public void setSimpleType(ReferenceBase simpleType) {
        this.simpleType = simpleType;
    }

    public String getBlock() {
        return this.block.getValue();
    }

    public String getForm() {
        return this.form.getValue();
    }

    public String getType() {
        if (this.type instanceof NamedConcreteElement) {
            return ((NamedConcreteElement)this.type).getName();
        }
        return this.attributesMap.getOrDefault("type", null);
    }

    public ReferenceBase getSubstitutionGroup() {
        return this.substitutionGroup;
    }

    public XsdElement getXsdSubstitutionGroup() {
        return this.substitutionGroup instanceof ConcreteElement ? (XsdElement)this.substitutionGroup.getElement() : null;
    }
}

