/*
 * Decompiled with CFR 0.152.
 */
package org.xmlet.xsdparser.xsdelements;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import org.xmlet.xsdparser.core.XsdParserCore;
import org.xmlet.xsdparser.core.utils.ConfigEntryData;
import org.xmlet.xsdparser.core.utils.ParseData;
import org.xmlet.xsdparser.xsdelements.XsdAbstractElement;
import org.xmlet.xsdparser.xsdelements.XsdAll;
import org.xmlet.xsdparser.xsdelements.XsdAnnotatedElements;
import org.xmlet.xsdparser.xsdelements.XsdAttribute;
import org.xmlet.xsdparser.xsdelements.XsdAttributeGroup;
import org.xmlet.xsdparser.xsdelements.XsdBuiltInDataType;
import org.xmlet.xsdparser.xsdelements.XsdChoice;
import org.xmlet.xsdparser.xsdelements.XsdComplexType;
import org.xmlet.xsdparser.xsdelements.XsdElement;
import org.xmlet.xsdparser.xsdelements.XsdGroup;
import org.xmlet.xsdparser.xsdelements.XsdNamedElements;
import org.xmlet.xsdparser.xsdelements.XsdSequence;
import org.xmlet.xsdparser.xsdelements.XsdSimpleType;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ConcreteElement;
import org.xmlet.xsdparser.xsdelements.elementswrapper.NamedConcreteElement;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ReferenceBase;
import org.xmlet.xsdparser.xsdelements.elementswrapper.UnsolvedReference;
import org.xmlet.xsdparser.xsdelements.exceptions.ParsingException;
import org.xmlet.xsdparser.xsdelements.visitors.XsdAbstractElementVisitor;
import org.xmlet.xsdparser.xsdelements.visitors.XsdRestrictionsVisitor;
import org.xmlet.xsdparser.xsdelements.xsdrestrictions.XsdEnumeration;
import org.xmlet.xsdparser.xsdelements.xsdrestrictions.XsdFractionDigits;
import org.xmlet.xsdparser.xsdelements.xsdrestrictions.XsdLength;
import org.xmlet.xsdparser.xsdelements.xsdrestrictions.XsdMaxExclusive;
import org.xmlet.xsdparser.xsdelements.xsdrestrictions.XsdMaxInclusive;
import org.xmlet.xsdparser.xsdelements.xsdrestrictions.XsdMaxLength;
import org.xmlet.xsdparser.xsdelements.xsdrestrictions.XsdMinExclusive;
import org.xmlet.xsdparser.xsdelements.xsdrestrictions.XsdMinInclusive;
import org.xmlet.xsdparser.xsdelements.xsdrestrictions.XsdMinLength;
import org.xmlet.xsdparser.xsdelements.xsdrestrictions.XsdPattern;
import org.xmlet.xsdparser.xsdelements.xsdrestrictions.XsdTotalDigits;
import org.xmlet.xsdparser.xsdelements.xsdrestrictions.XsdWhiteSpace;

public class XsdRestriction
extends XsdAnnotatedElements {
    public static final String XSD_TAG = "xsd:restriction";
    public static final String XS_TAG = "xs:restriction";
    public static final String TAG = "restriction";
    private ReferenceBase base;
    private List<XsdEnumeration> enumeration = new ArrayList<XsdEnumeration>();
    private XsdFractionDigits fractionDigits;
    private XsdLength length;
    private XsdMaxExclusive maxExclusive;
    private XsdMaxInclusive maxInclusive;
    private XsdMaxLength maxLength;
    private XsdMinExclusive minExclusive;
    private XsdMinInclusive minInclusive;
    private XsdMinLength minLength;
    private List<XsdPattern> pattern = new ArrayList<XsdPattern>();
    private XsdTotalDigits totalDigits;
    private XsdWhiteSpace whiteSpace;
    private ReferenceBase group;
    private XsdAll all;
    private XsdChoice choice;
    private XsdSequence sequence;
    private String baseString;

    private XsdRestriction(@NotNull XsdParserCore parser, @NotNull Map<String, String> attributesMap, @NotNull Function<XsdAbstractElement, XsdAbstractElementVisitor> visitorFunction) {
        super(parser, attributesMap, visitorFunction);
        String baseValue;
        this.baseString = baseValue = (String)attributesMap.getOrDefault("base", null);
        if (baseValue != null) {
            if (XsdParserCore.isXsdTypeToJava(baseValue)) {
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put("name", baseValue);
                this.base = ReferenceBase.createFromXsd(new XsdBuiltInDataType(parser, attributes, this));
            } else {
                ConfigEntryData config = XsdParserCore.getParseMappers("element");
                if (config == null) {
                    throw new ParsingException("Invalid Parsing Configuration for XsdElement.");
                }
                this.base = new UnsolvedReference(baseValue, new XsdElement(this, this.parser, new HashMap<String, String>(), config.visitorFunction));
                parser.addUnsolvedReference((UnsolvedReference)this.base);
            }
        }
    }

    public XsdRestriction(XsdAbstractElement parent, @NotNull XsdParserCore parser, @NotNull Map<String, String> elementFieldsMapParam, @NotNull Function<XsdAbstractElement, XsdAbstractElementVisitor> visitorFunction) {
        this(parser, elementFieldsMapParam, visitorFunction);
        this.setParent(parent);
    }

    @Override
    public void accept(XsdAbstractElementVisitor visitorParam) {
        super.accept(visitorParam);
        visitorParam.visit(this);
    }

    @Override
    public void replaceUnsolvedElements(NamedConcreteElement element) {
        boolean isComplexOrSimpleType;
        super.replaceUnsolvedElements(element);
        ((XsdRestrictionsVisitor)this.visitor).replaceUnsolvedAttributes(this.parser, element, this);
        XsdNamedElements elem = element.getElement();
        boolean bl = isComplexOrSimpleType = elem instanceof XsdComplexType || elem instanceof XsdSimpleType;
        if (this.base instanceof UnsolvedReference && isComplexOrSimpleType && XsdRestriction.compareReference(element, (UnsolvedReference)this.base)) {
            this.base = element;
        }
        if (this.group instanceof UnsolvedReference && this.group.getElement() instanceof XsdGroup && elem instanceof XsdGroup && XsdRestriction.compareReference(element, (UnsolvedReference)this.group)) {
            this.group = element;
        }
    }

    @Override
    public XsdRestriction clone(@NotNull Map<String, String> placeHolderAttributes) {
        placeHolderAttributes.putAll(this.attributesMap);
        placeHolderAttributes.remove("base");
        XsdRestriction elementCopy = new XsdRestriction(this.parser, placeHolderAttributes, this.visitorFunction);
        if (this.enumeration != null) {
            elementCopy.enumeration = this.enumeration.stream().map(enumerationObj -> (XsdEnumeration)enumerationObj.clone(enumerationObj.getAttributesMap(), elementCopy)).collect(Collectors.toList());
        }
        if (this.fractionDigits != null) {
            elementCopy.fractionDigits = (XsdFractionDigits)this.fractionDigits.clone(this.fractionDigits.getAttributesMap(), elementCopy);
        }
        if (this.length != null) {
            elementCopy.length = (XsdLength)this.length.clone(this.length.getAttributesMap(), elementCopy);
        }
        if (this.maxExclusive != null) {
            elementCopy.maxExclusive = (XsdMaxExclusive)this.maxExclusive.clone(this.maxExclusive.getAttributesMap(), elementCopy);
        }
        if (this.maxInclusive != null) {
            elementCopy.maxInclusive = (XsdMaxInclusive)this.maxInclusive.clone(this.maxInclusive.getAttributesMap(), elementCopy);
        }
        if (this.maxLength != null) {
            elementCopy.maxLength = (XsdMaxLength)this.maxLength.clone(this.maxLength.getAttributesMap(), elementCopy);
        }
        if (this.minExclusive != null) {
            elementCopy.minExclusive = (XsdMinExclusive)this.minExclusive.clone(this.minExclusive.getAttributesMap(), elementCopy);
        }
        if (this.minInclusive != null) {
            elementCopy.minInclusive = (XsdMinInclusive)this.minInclusive.clone(this.minInclusive.getAttributesMap(), elementCopy);
        }
        if (this.minLength != null) {
            elementCopy.minLength = (XsdMinLength)this.minLength.clone(this.minLength.getAttributesMap(), elementCopy);
        }
        if (this.pattern != null) {
            elementCopy.pattern = this.pattern.stream().map(patternObj -> (XsdPattern)patternObj.clone(patternObj.getAttributesMap(), elementCopy)).collect(Collectors.toList());
        }
        if (this.totalDigits != null) {
            elementCopy.totalDigits = (XsdTotalDigits)this.totalDigits.clone(this.totalDigits.getAttributesMap(), elementCopy);
        }
        if (this.whiteSpace != null) {
            elementCopy.whiteSpace = (XsdWhiteSpace)this.whiteSpace.clone(this.whiteSpace.getAttributesMap(), elementCopy);
        }
        if (this.all != null) {
            elementCopy.all = (XsdAll)this.all.clone(this.all.getAttributesMap(), elementCopy);
        }
        if (this.choice != null) {
            elementCopy.choice = (XsdChoice)this.choice.clone(this.choice.getAttributesMap(), elementCopy);
        }
        if (this.sequence != null) {
            elementCopy.sequence = (XsdSequence)this.sequence.clone(this.sequence.getAttributesMap(), elementCopy);
        }
        if (this.group != null) {
            elementCopy.group = ReferenceBase.clone(this.parser, this.group, elementCopy);
        }
        elementCopy.cloneOf = this;
        elementCopy.parent = null;
        elementCopy.base = this.base;
        return elementCopy;
    }

    public static ReferenceBase parse(@NotNull ParseData parseData) {
        return XsdRestriction.xsdParseSkeleton(parseData.node, new XsdRestriction(parseData.parserInstance, XsdRestriction.convertNodeMap(parseData.node.getAttributes()), parseData.visitorFunction));
    }

    public Stream<XsdAttribute> getXsdAttributes() {
        return ((XsdRestrictionsVisitor)this.visitor).getXsdAttributes();
    }

    public Stream<XsdAttributeGroup> getXsdAttributeGroup() {
        return ((XsdRestrictionsVisitor)this.visitor).getXsdAttributeGroups();
    }

    public XsdComplexType getBaseAsComplexType() {
        XsdAbstractElement baseType;
        if (this.base instanceof NamedConcreteElement && (baseType = this.base.getElement()) instanceof XsdComplexType) {
            return (XsdComplexType)baseType;
        }
        return null;
    }

    public XsdSimpleType getBaseAsSimpleType() {
        XsdAbstractElement baseType;
        if (this.base instanceof NamedConcreteElement && (baseType = this.base.getElement()) instanceof XsdSimpleType) {
            return (XsdSimpleType)baseType;
        }
        return null;
    }

    public XsdBuiltInDataType getBaseAsBuiltInDataType() {
        XsdAbstractElement baseType;
        if (this.base instanceof NamedConcreteElement && (baseType = this.base.getElement()) instanceof XsdBuiltInDataType) {
            return (XsdBuiltInDataType)baseType;
        }
        return null;
    }

    public String getBase() {
        return this.baseString;
    }

    public List<XsdEnumeration> getEnumeration() {
        return this.enumeration;
    }

    void setEnumeration(List<XsdEnumeration> enumeration) {
        this.enumeration = enumeration;
    }

    public XsdFractionDigits getFractionDigits() {
        return this.fractionDigits;
    }

    public void setFractionDigits(XsdFractionDigits fractionDigits) {
        this.fractionDigits = fractionDigits;
    }

    public XsdLength getLength() {
        return this.length;
    }

    public void setLength(XsdLength length) {
        this.length = length;
    }

    public XsdMaxExclusive getMaxExclusive() {
        return this.maxExclusive;
    }

    public void setMaxExclusive(XsdMaxExclusive maxExclusive) {
        this.maxExclusive = maxExclusive;
    }

    public XsdMaxInclusive getMaxInclusive() {
        return this.maxInclusive;
    }

    public void setMaxInclusive(XsdMaxInclusive maxInclusive) {
        this.maxInclusive = maxInclusive;
    }

    public XsdMaxLength getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(XsdMaxLength maxLength) {
        this.maxLength = maxLength;
    }

    public XsdMinExclusive getMinExclusive() {
        return this.minExclusive;
    }

    public void setMinExclusive(XsdMinExclusive minExclusive) {
        this.minExclusive = minExclusive;
    }

    public XsdMinInclusive getMinInclusive() {
        return this.minInclusive;
    }

    public void setMinInclusive(XsdMinInclusive minInclusive) {
        this.minInclusive = minInclusive;
    }

    public XsdMinLength getMinLength() {
        return this.minLength;
    }

    public void setMinLength(XsdMinLength minLength) {
        this.minLength = minLength;
    }

    public XsdPattern getPattern() {
        Optional optionalXsdPattern;
        if (this.pattern != null && (optionalXsdPattern = this.pattern.stream().findFirst()).isPresent()) {
            return (XsdPattern)optionalXsdPattern.get();
        }
        return null;
    }

    public List<XsdPattern> getPatterns() {
        return this.pattern;
    }

    public void setPattern(List<XsdPattern> pattern) {
        this.pattern = pattern;
    }

    public void add(XsdPattern patternMember) {
        this.pattern.add(patternMember);
    }

    public XsdTotalDigits getTotalDigits() {
        return this.totalDigits;
    }

    public void setTotalDigits(XsdTotalDigits totalDigits) {
        this.totalDigits = totalDigits;
    }

    public XsdWhiteSpace getWhiteSpace() {
        return this.whiteSpace;
    }

    public void setWhiteSpace(XsdWhiteSpace whiteSpace) {
        this.whiteSpace = whiteSpace;
    }

    public void add(XsdEnumeration enumerationMember) {
        this.enumeration.add(enumerationMember);
    }

    public XsdGroup getGroup() {
        return this.group instanceof ConcreteElement ? (XsdGroup)this.group.getElement() : null;
    }

    public void setGroup(ReferenceBase group) {
        this.group = group;
    }

    public XsdAll getAll() {
        return this.all;
    }

    public void setAll(XsdAll all) {
        this.all = all;
    }

    public XsdChoice getChoice() {
        return this.choice;
    }

    public void setChoice(XsdChoice choice) {
        this.choice = choice;
    }

    public XsdSequence getSequence() {
        return this.sequence;
    }

    public void setSequence(XsdSequence sequence) {
        this.sequence = sequence;
    }
}

