/*
 * Decompiled with CFR 0.152.
 */
package org.xmlet.xsdparser.xsdelements;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import org.xmlet.xsdparser.core.XsdParserCore;
import org.xmlet.xsdparser.core.utils.ParseData;
import org.xmlet.xsdparser.xsdelements.AttributeValidations;
import org.xmlet.xsdparser.xsdelements.XsdAbstractElement;
import org.xmlet.xsdparser.xsdelements.XsdChoice;
import org.xmlet.xsdparser.xsdelements.XsdGroup;
import org.xmlet.xsdparser.xsdelements.XsdMultipleElements;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ReferenceBase;
import org.xmlet.xsdparser.xsdelements.visitors.XsdAbstractElementVisitor;

public class XsdSequence
extends XsdMultipleElements {
    public static final String XSD_TAG = "xsd:sequence";
    public static final String XS_TAG = "xs:sequence";
    public static final String TAG = "sequence";
    private Integer minOccurs;
    private String maxOccurs;

    private XsdSequence(@NotNull XsdParserCore parser, @NotNull Map<String, String> attributesMap, @NotNull Function<XsdAbstractElement, XsdAbstractElementVisitor> visitorFunction) {
        super(parser, attributesMap, visitorFunction);
        this.minOccurs = AttributeValidations.validateNonNegativeInteger(XSD_TAG, "minOccurs", attributesMap.getOrDefault("minOccurs", "1"));
        this.maxOccurs = AttributeValidations.maxOccursValidation(XSD_TAG, attributesMap.getOrDefault("maxOccurs", "1"));
    }

    @Override
    public void accept(XsdAbstractElementVisitor visitorParam) {
        super.accept(visitorParam);
        visitorParam.visit(this);
    }

    @Override
    public XsdSequence clone(@NotNull Map<String, String> placeHolderAttributes) {
        placeHolderAttributes.putAll(this.attributesMap);
        XsdSequence elementCopy = new XsdSequence(this.getParser(), placeHolderAttributes, this.visitorFunction);
        for (ReferenceBase element : this.getElements()) {
            elementCopy.elements.add(ReferenceBase.clone(this.parser, element, elementCopy));
        }
        elementCopy.cloneOf = this;
        elementCopy.setParent(null);
        return elementCopy;
    }

    public static ReferenceBase parse(@NotNull ParseData parseData) {
        return XsdSequence.xsdParseSkeleton(parseData.node, new XsdSequence(parseData.parserInstance, XsdSequence.convertNodeMap(parseData.node.getAttributes()), parseData.visitorFunction));
    }

    public Integer getMinOccurs() {
        return this.minOccurs;
    }

    public String getMaxOccurs() {
        return this.maxOccurs;
    }

    public Stream<XsdChoice> getChildrenChoices() {
        return this.getXsdElements().filter(element -> element instanceof XsdChoice).map(element -> (XsdChoice)element);
    }

    public Stream<XsdSequence> getChildrenSequences() {
        return this.getXsdElements().filter(element -> element instanceof XsdSequence).map(element -> (XsdSequence)element);
    }

    public Stream<XsdGroup> getChildrenGroups() {
        return this.getXsdElements().filter(element -> element instanceof XsdGroup).map(element -> (XsdGroup)element);
    }
}

