/*
 * Decompiled with CFR 0.152.
 */
package org.xmlet.xsdparser.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xmlet.xsdparser.core.XsdParserCore;
import org.xmlet.xsdparser.core.utils.ConfigEntryData;
import org.xmlet.xsdparser.core.utils.ParseData;
import org.xmlet.xsdparser.core.utils.ParserConfig;
import org.xmlet.xsdparser.xsdelements.XsdSchema;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ReferenceBase;
import org.xmlet.xsdparser.xsdelements.exceptions.ParsingException;

public class XsdParser
extends XsdParserCore {
    public XsdParser(String filePath) {
        this.parse(filePath);
    }

    public XsdParser(String filePath, ParserConfig config) {
        XsdParserCore.updateConfig(config);
        this.parse(filePath);
    }

    private void parse(String filePath) {
        this.schemaLocations.add(filePath);
        for (int index = 0; this.schemaLocations.size() > index; ++index) {
            String schemaLocation = (String)this.schemaLocations.get(index);
            this.parseFile(schemaLocation);
        }
        this.resolveRefs();
    }

    private void parseFile(String filePath) {
        try {
            String parentFile;
            if (!new File(filePath).exists() && this.isRelativePath(filePath) && !new File(filePath = (parentFile = (String)this.schemaLocationsMap.get(filePath)).substring(0, parentFile.lastIndexOf(47) + 1).concat(filePath)).exists()) {
                throw new FileNotFoundException(filePath);
            }
            this.currentFile = filePath.replace("\\", "/");
            ConfigEntryData xsdSchemaConfig = parseMappers.getOrDefault("xsd:schema", parseMappers.getOrDefault("xs:schema", null));
            if (xsdSchemaConfig == null) {
                throw new ParserConfigurationException("XsdSchema not correctly configured.");
            }
            ReferenceBase schemaReference = xsdSchemaConfig.parserFunction.apply(new ParseData(this, this.getSchemaNode(filePath), xsdSchemaConfig.visitorFunction));
            ((XsdSchema)schemaReference.getElement()).setFilePath(filePath);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Exception while parsing.", e);
            throw new RuntimeException(e);
        }
    }

    private Node getSchemaNode(String filePath) throws IOException, SAXException, ParserConfigurationException {
        Document doc = this.getDocumentBuilder().parse(filePath);
        doc.getDocumentElement().normalize();
        NodeList nodes = doc.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!this.isXsdSchema(node)) continue;
            return node;
        }
        throw new ParsingException("The top level element of a XSD file should be the xsd:schema node.");
    }
}

